/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.descriptor.DescriptorPackage;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.symrefs.ElementSetReference;
import org.eclipse.emf.compare.mpatch.transform.impl.WeakeningHelper;
import org.eclipse.emf.ecore.EReference;

public class UnboundSymbolicReferencesWeakening
implements IMPatchTransformation {
    public static final String LABEL = "Unbound Symbolic References";
    private static final String DESCRIPTION = "This transformation removes the bounds of Symbolic References. This is an optional transformation and might change the result of MPatch application!\n\nIt allow changes to be applicable not only to one but to many model elements. When applying differences to another model, by default, each change must be applied to exactly one model element. However, when changing the bounds to [1..*], changes are applicable to more than one just one model element. For instance, a change describing a class moved to another package might be applied not to a single but to a set of classes.";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 10;
    }

    public boolean isOptional() {
        return true;
    }

    public int transform(MPatchModel mpatch) {
        return UnboundSymbolicReferencesWeakening.weakenBounds(mpatch);
    }

    public static int weakenBounds(MPatchModel mpatch) {
        int counter = 0;
        for (IElementReference ref : WeakeningHelper.getWeakenableSymbolicReferences(mpatch)) {
            if (!UnboundSymbolicReferencesWeakening.isWeakenable(ref) || !ref.setUpperBound(-1)) continue;
            ++counter;
        }
        return counter;
    }

    private static boolean isWeakenable(IElementReference ref) {
        if (ref instanceof ElementSetReference || ref instanceof ModelDescriptorReference) {
            if (ref.eContainer() == null) {
                throw new IllegalArgumentException("Symbolic Reference must be contained somewhere: " + ref);
            }
            EReference feature = ref.eContainmentFeature();
            if (MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT.equals(feature)) {
                return true;
            }
            if (MPatchPackage.Literals.INDEP_CHANGE__RESULTING_ELEMENT.equals(feature)) {
                return true;
            }
            if (MPatchPackage.Literals.INDEP_ADD_REM_REFERENCE_CHANGE__CHANGED_REFERENCE.equals(feature)) {
                return true;
            }
            if (DescriptorPackage.Literals.EREFERENCE_TO_ELEMENT_REFERENCE_MAP__VALUE.equals(feature)) {
                return true;
            }
        }
        return false;
    }
}

