/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.EMFCompareMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    protected static final int DEFAULT_INITIAL_CAPACITY = 31;
    protected static final float DEFAULT_LOAD_FACTOR = 0.6f;
    protected static final float MINIMUM_LOAD_FACTOR = 0.05f;
    protected static final Object NULL_KEY = new Object();
    protected static final Object REMOVED_ENTRY = new Object();
    private static final int[] FIRST_PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97};
    private static final int[] DEFAULT_PRIME_LIST = new int[]{31, 67, 137, 277, 557, 1117, 2237, 4481, 8963, 17929, 35863, 71741, 143483, 286973, 573953, 0x118411, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103, Integer.MAX_VALUE};
    private static final long serialVersionUID = -890704446117047482L;
    protected int freeSlots;
    protected transient K[] keys;
    protected float loadFactor = 0.6f;
    protected int nextPrimeIndex;
    protected int threshold;
    protected transient int usedSlots;
    protected transient V[] values;

    public EMFCompareMap() {
        ++this.nextPrimeIndex;
        this.freeSlots = this.threshold = 17;
        this.keys = new Object[31];
        this.values = new Object[31];
    }

    public EMFCompareMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public EMFCompareMap(int initialCapacity, float theLoadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("EMFCompareMap.NegativeCapacity"));
        }
        if (theLoadFactor <= 0.0f || Float.isNaN(theLoadFactor)) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("EMFCompareMap.IllegalLoadFactor", Float.valueOf(theLoadFactor)));
        }
        this.loadFactor = theLoadFactor;
        int newCapacity = this.getNearestPrime((int)((float)initialCapacity / Math.max(0.05f, this.loadFactor)));
        this.changeCapacity(newCapacity);
        this.keys = new Object[newCapacity];
        this.values = new Object[newCapacity];
    }

    public EMFCompareMap(Map<K, V> map) {
        this(map.size());
        this.putAll(map);
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.usedSlots = 0;
        this.freeSlots = this.capacity();
        int i = 0;
        while (i < this.keys.length) {
            this.keys[i] = null;
            this.values[i] = null;
            ++i;
        }
    }

    public Object clone() {
        try {
            EMFCompareMap map = (EMFCompareMap)super.clone();
            map.putAll(this);
            return map;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean result = false;
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null && this.keys[i] != REMOVED_ENTRY) {
                if (value == null && this.values[i] == null) {
                    result = true;
                    break;
                }
                if (value != null && (this.values[i] == value || this.values[i] != null && this.values[i].equals(value))) {
                    result = true;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object another) {
        boolean result = false;
        if (another == this) {
            result = true;
        } else if (another instanceof Map && ((Map)another).size() == this.size()) {
            if (this.size() == 0) {
                result = true;
            }
            for (Map.Entry<K, V> entry : this.entrySet()) {
                if (!((Map)another).containsKey(entry.getKey())) continue;
                Object otherValue = ((Map)another).get(entry.getKey());
                result = this.equal(otherValue, entry.getValue());
            }
        }
        return result;
    }

    @Override
    public V get(Object key) {
        int index = this.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            hash += entry.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public V put(K key, V value) {
        Object effectiveKey = key;
        if (key == null) {
            effectiveKey = NULL_KEY;
        }
        V oldValue = null;
        int index = this.insertionIndexFor(effectiveKey);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            oldValue = this.values[index];
            isNewMapping = false;
        }
        boolean usedFreeSlot = this.keys[index] == null;
        this.keys[index] = effectiveKey;
        this.values[index] = value;
        if (isNewMapping) {
            this.postInsert(usedFreeSlot);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkCapacity(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Object effectiveKey = key;
        if (key == null) {
            effectiveKey = NULL_KEY;
        }
        V oldValue = null;
        int index = this.indexOf(effectiveKey);
        if (index >= 0) {
            oldValue = this.values[index];
            this.removeEntryForIndex(index);
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.usedSlots;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry<K, V> e = i.next();
            buf.append(e.toString());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public Collection<V> values() {
        return new ValueSet();
    }

    protected int capacity() {
        return this.keys.length;
    }

    protected void changeCapacity(int newCapacity) {
        this.threshold = newCapacity - 1;
        int candidate = (int)Math.floor((float)newCapacity * this.loadFactor);
        if (candidate < this.threshold) {
            this.threshold = candidate;
        }
        this.freeSlots = newCapacity - this.usedSlots;
    }

    protected void checkCapacity(int desiredSlots) {
        if (desiredSlots > this.threshold - this.size()) {
            this.resize(this.getNearestPrime((int)Math.ceil((float)desiredSlots + (float)this.size() / this.loadFactor) + 1));
        }
    }

    protected boolean equal(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    protected int getNearestPrime(int number) {
        if (this.nextPrimeIndex > 0) {
            return DEFAULT_PRIME_LIST[this.nextPrimeIndex++];
        }
        int isPrime = number <= 2 ? 2 : Math.abs(number);
        int nearestPrime = -1;
        if (isPrime < 100 && Arrays.binarySearch(FIRST_PRIMES, isPrime) >= 0) {
            nearestPrime = isPrime;
        } else if ((isPrime & 1) == 0) {
            nearestPrime = this.getNearestPrime(isPrime + 1);
        } else if (isPrime % 6 != 1 && isPrime % 6 != 5) {
            nearestPrime = this.getNearestPrime(isPrime + 5 - isPrime % 6);
        } else {
            int[] nArray = FIRST_PRIMES;
            int n = FIRST_PRIMES.length;
            int n2 = 0;
            while (n2 < n) {
                int prime = nArray[n2];
                if (isPrime % prime == 0) {
                    nearestPrime = this.getNearestPrime(isPrime + 2);
                }
                ++n2;
            }
            if (nearestPrime == -1) {
                int d = isPrime - 1;
                int r = 1;
                while ((d & 1) == 0) {
                    d >>= 1;
                    ++r;
                }
                int loops = 10;
                int i = 0;
                while (i < 10) {
                    int y = (int)Math.pow(Math.random() * (double)isPrime + 1.0, d) % isPrime;
                    if (y != 1) {
                        boolean pass = false;
                        int j = 1;
                        while (j < r) {
                            if (y != isPrime - 1) {
                                pass = true;
                                break;
                            }
                            y = (int)Math.pow(y, 2.0) % isPrime;
                            ++j;
                        }
                        if (!pass) {
                            nearestPrime = this.getNearestPrime(isPrime + 2);
                        }
                    }
                    ++i;
                }
            }
            if (nearestPrime == -1) {
                nearestPrime = isPrime;
            }
        }
        return nearestPrime;
    }

    protected int indexOf(Object key) {
        int length;
        Object effectiveKey = key;
        if (key == null) {
            effectiveKey = NULL_KEY;
        }
        int mask = Integer.MAX_VALUE;
        int hash = effectiveKey.hashCode() & Integer.MAX_VALUE;
        int index = hash % (length = this.keys.length);
        K current = this.keys[index];
        if (!(current == null || current != REMOVED_ENTRY && this.equal(current, effectiveKey))) {
            int hashProbe = 1 + hash % (length - 2);
            while (!(current == null || current != REMOVED_ENTRY && this.equal(current, effectiveKey))) {
                if ((index -= hashProbe) < 0) {
                    index += length;
                }
                current = this.keys[index];
            }
        }
        if (current == null) {
            return -1;
        }
        return index;
    }

    protected int insertionIndexFor(K key) {
        int length;
        int mask = Integer.MAX_VALUE;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % (length = this.keys.length);
        K current = this.keys[index];
        if (current == null) {
            return index;
        }
        if (current != REMOVED_ENTRY && this.equal(current, key)) {
            return -index - 1;
        }
        int hashProbe = 1 + hash % (length - 2);
        if (current != REMOVED_ENTRY) {
            while (current != null && current != REMOVED_ENTRY && !this.equal(current, key)) {
                if ((index -= hashProbe) < 0) {
                    index += length;
                }
                current = this.keys[index];
            }
        }
        if (current == REMOVED_ENTRY) {
            int removedIndex = index;
            while (!(current == null || current != REMOVED_ENTRY && this.equal(current, key))) {
                if ((index -= hashProbe) < 0) {
                    index += length;
                }
                current = this.keys[index];
            }
            if (current == null) {
                index = removedIndex;
            }
        }
        if (current != null) {
            return -index - 1;
        }
        return index;
    }

    protected void postInsert(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this.freeSlots;
        }
        ++this.usedSlots;
        if (this.usedSlots > this.threshold || this.freeSlots == 0) {
            int newCapacity = this.getNearestPrime(this.capacity() << 1);
            this.resize(newCapacity);
        }
    }

    protected Map.Entry<K, V> removeEntry(Object e) {
        Map.Entry entry;
        V oldValue;
        Object result = !(e instanceof Map.Entry) ? null : ((oldValue = this.remove((entry = (Map.Entry)e).getKey())) == null && entry.getValue() != null ? null : entry);
        return result;
    }

    protected void removeEntryForIndex(int index) {
        --this.usedSlots;
        this.keys[index] = REMOVED_ENTRY;
        this.values[index] = null;
    }

    protected void resize(int newCapacity) {
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        this.keys = new Object[newCapacity];
        this.values = new Object[newCapacity];
        int i = 0;
        while (i < oldKeys.length) {
            if (oldKeys[i] != null && oldKeys[i] != REMOVED_ENTRY) {
                int index = this.insertionIndexFor(oldKeys[i]);
                this.keys[index] = oldKeys[i];
                this.values[index] = oldValues[i];
            }
            ++i;
        }
        this.changeCapacity(newCapacity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHashIterator<E>
    implements Iterator<E> {
        protected Entry currentEntry;
        protected K currentKey;
        protected V currentValue;
        private int expectedSize;
        private int nextIndex;

        public AbstractHashIterator() {
            this.expectedSize = EMFCompareMap.this.usedSlots;
            while (this.nextIndex < EMFCompareMap.this.keys.length && (EMFCompareMap.this.keys[this.nextIndex] == null || EMFCompareMap.this.keys[this.nextIndex] == REMOVED_ENTRY)) {
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < EMFCompareMap.this.keys.length;
        }

        @Override
        public void remove() {
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            if (this.expectedSize != EMFCompareMap.this.usedSlots) {
                throw new ConcurrentModificationException();
            }
            EMFCompareMap.this.remove(this.currentKey);
            this.currentEntry = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedSize = EMFCompareMap.this.usedSlots;
        }

        protected void nextEntry() {
            if (this.expectedSize != EMFCompareMap.this.usedSlots) {
                throw new ConcurrentModificationException();
            }
            this.currentKey = EMFCompareMap.this.keys[this.nextIndex];
            this.currentValue = EMFCompareMap.this.values[this.nextIndex];
            this.currentEntry = new Entry(this.currentKey, this.currentValue, this.nextIndex);
            ++this.nextIndex;
            while (this.nextIndex < EMFCompareMap.this.keys.length && (EMFCompareMap.this.keys[this.nextIndex] == null || EMFCompareMap.this.keys[this.nextIndex] == REMOVED_ENTRY)) {
                ++this.nextIndex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    implements Map.Entry<K, V> {
        private final int index;
        private final K key;
        private V value;

        public Entry(K entryKey, V entryValue, int entryIndex) {
            this.key = entryKey;
            this.value = entryValue;
            this.index = entryIndex;
        }

        @Override
        public final boolean equals(Object another) {
            Map.Entry other;
            boolean result = false;
            if (another == this) {
                result = true;
            } else if (another instanceof Map.Entry && EMFCompareMap.this.equal(this.key, (other = (Map.Entry)another).getKey()) && EMFCompareMap.this.equal(this.value, other.getValue())) {
                result = true;
            }
            return result;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public final int hashCode() {
            int keyHash = 0;
            int valueHash = 0;
            if (this.key != null) {
                keyHash = this.key.hashCode();
            }
            if (this.value != null) {
                valueHash = this.value.hashCode();
            }
            return keyHash ^ valueHash;
        }

        @Override
        public V setValue(V newValue) {
            if (EMFCompareMap.this.values[this.index] != this.value) {
                throw new ConcurrentModificationException();
            }
            Object oldValue = this.value;
            EMFCompareMap.this.values[this.index] = newValue;
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.key == NULL_KEY) {
                result.append("null");
            } else {
                result.append(this.key.toString());
            }
            result.append('=');
            if (this.value == null) {
                result.append("null");
            } else {
                result.append(this.value.toString());
            }
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends AbstractHashIterator<Map.Entry<K, V>> {
        @Override
        public Map.Entry<K, V> next() {
            this.nextEntry();
            return this.currentEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public void clear() {
            EMFCompareMap.this.clear();
        }

        @Override
        public boolean contains(Object e) {
            boolean result = false;
            if (!(e instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)e;
            if (EMFCompareMap.this.containsKey(entry.getKey())) {
                Object candidate = EMFCompareMap.this.get(entry.getKey());
                result = candidate == null ? entry.getValue() == null : entry.getValue().equals(candidate);
            }
            return result;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object e) {
            return EMFCompareMap.this.removeEntry(e) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                for (Object entry : c) {
                    if (!this.contains(entry)) continue;
                    this.remove(entry);
                    modified = true;
                }
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean modified = false;
            Object[] retainedKeys = new Object[c.size()];
            int indx = 0;
            for (Object entry : c) {
                if (!(entry instanceof Map.Entry)) continue;
                retainedKeys[indx++] = ((Map.Entry)entry).getKey();
            }
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                boolean removeIt = true;
                Object[] objectArray = retainedKeys;
                int n = retainedKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (entry.getKey() == o) {
                        removeIt = false;
                        break;
                    }
                    ++n2;
                }
                if (!removeIt) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return EMFCompareMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends AbstractHashIterator<K> {
        @Override
        public K next() {
            this.nextEntry();
            return this.currentKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        @Override
        public void clear() {
            EMFCompareMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return EMFCompareMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            return EMFCompareMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return EMFCompareMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends AbstractHashIterator<V> {
        @Override
        public V next() {
            this.nextEntry();
            return this.currentValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueSet
    extends AbstractSet<V> {
        @Override
        public void clear() {
            EMFCompareMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return EMFCompareMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EMFCompareMap.this.size();
        }
    }
}

