/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareEObjectCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 2701874812215174395L;
    private final transient DiffModel diffModel;
    private final transient DiffResourceSet diffResourceSet;
    private final List<ResourceDependencyChange> dependencyChanges = new ArrayList<ResourceDependencyChange>();

    public EMFCompareEObjectCopier(DiffModel diff) {
        this.diffModel = diff;
        if (this.diffModel.eContainer() instanceof DiffResourceSet) {
            this.diffResourceSet = (DiffResourceSet)this.diffModel.eContainer();
            for (EObject child : this.diffModel.eContainer().eContents()) {
                if (!(child instanceof ResourceDependencyChange)) continue;
                this.dependencyChanges.add((ResourceDependencyChange)child);
            }
        } else {
            this.diffResourceSet = null;
        }
    }

    public EMFCompareEObjectCopier(DiffResourceSet diff) {
        this.diffModel = null;
        this.diffResourceSet = diff;
        for (EObject child : this.diffResourceSet.eContents()) {
            if (!(child instanceof ResourceDependencyChange)) continue;
            this.dependencyChanges.add((ResourceDependencyChange)child);
        }
    }

    public void copyReferences() {
        HashSet entrySetCopy = new HashSet(this.entrySet());
        for (Map.Entry entry : entrySetCopy) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EClass eClass = eObject.eClass();
            int j = 0;
            while (j < eClass.getFeatureCount()) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
                if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                    if (eStructuralFeature instanceof EReference) {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (!eReference.isContainment() && !eReference.isContainer()) {
                            this.copyReference(eReference, eObject, copyEObject);
                        }
                    } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                        this.copyFeatureMap(eObject, eStructuralFeature);
                    }
                }
                ++j;
            }
        }
    }

    @Deprecated
    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value) {
        return this.copyReferenceValue(targetReference, target, value, -1);
    }

    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value, int index) {
        EObject targetValue = (EObject)this.get(value);
        EObject copy = targetValue != null ? targetValue : (this.mergeLinkedDiff(value) ? (EObject)this.get(value) : (value.eResource() == null || value.eResource().getURI().isPlatformPlugin() ? value : this.copy(value)));
        Object referenceValue = target.eGet((EStructuralFeature)targetReference);
        if (referenceValue instanceof List && targetReference.isMany()) {
            if (copy.eIsProxy() && copy instanceof InternalEObject) {
                URI proxURI = ((InternalEObject)copy).eProxyURI();
                boolean found = false;
                Iterator it = ((List)referenceValue).iterator();
                while (!found && it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof InternalEObject)) continue;
                    found = proxURI.equals((Object)((InternalEObject)obj).eProxyURI());
                }
                if (!found) {
                    List targetList = (List)referenceValue;
                    if (index > -1 && index < targetList.size()) {
                        targetList.add(index, copy);
                    } else {
                        targetList.add(copy);
                    }
                }
            } else {
                List targetList = (List)referenceValue;
                if (!targetList.contains(copy)) {
                    if (index > -1 && index < targetList.size()) {
                        targetList.add(index, copy);
                    } else {
                        targetList.add(copy);
                    }
                }
            }
        } else if (copy.eIsProxy() && copy instanceof InternalEObject) {
            URI proxURI = ((InternalEObject)copy).eProxyURI();
            if (referenceValue instanceof InternalEObject && !proxURI.equals((Object)((InternalEObject)referenceValue).eProxyURI())) {
                target.eSet((EStructuralFeature)targetReference, (Object)copy);
            }
        } else {
            target.eSet((EStructuralFeature)targetReference, (Object)copy);
        }
        return copy;
    }

    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value, EObject matchedValue, int index) {
        EObject actualValue = value;
        if (value == null && matchedValue != null) {
            this.handleLinkedResourceDependencyChange(matchedValue);
            actualValue = (EObject)this.get(matchedValue);
        }
        if (matchedValue != null) {
            this.put(actualValue, matchedValue);
            Object referenceValue = target.eGet((EStructuralFeature)targetReference);
            if (referenceValue instanceof List) {
                List targetList = (List)referenceValue;
                int targetListSize = targetList.size();
                if (index > -1 && index < targetListSize) {
                    targetList.add(index, matchedValue);
                } else {
                    targetList.add(matchedValue);
                }
            } else {
                target.eSet((EStructuralFeature)targetReference, (Object)matchedValue);
            }
            return matchedValue;
        }
        return this.copyReferenceValue(targetReference, target, actualValue, index);
    }

    @Deprecated
    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value, EObject matchedValue) {
        return this.copyReferenceValue(targetReference, target, value, matchedValue, -1);
    }

    public void copyXMIIDs() {
        for (Map.Entry entry : this.entrySet()) {
            EObject original = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (!(original.eResource() instanceof XMIResource) || !(copy.eResource() instanceof XMIResource)) continue;
            XMIResource originResource = (XMIResource)original.eResource();
            XMIResource copyResource = (XMIResource)copy.eResource();
            if (originResource.getID(original) == null) continue;
            copyResource.setID(copy, originResource.getID(original));
            TreeIterator originalIterator = original.eAllContents();
            TreeIterator copyIterator = copy.eAllContents();
            while (originalIterator.hasNext()) {
                EObject nextOriginalChild = (EObject)originalIterator.next();
                EObject nextCopyChild = (EObject)copyIterator.next();
                copyResource.setID(nextCopyChild, originResource.getID(nextOriginalChild));
            }
        }
    }

    public DiffModel getDiffModel() {
        return this.diffModel;
    }

    public DiffResourceSet getDiffResourceSet() {
        return this.diffResourceSet;
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (!eObject.eIsSet((EStructuralFeature)eReference)) {
            return;
        }
        Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
        if (eReference == EcorePackage.eINSTANCE.getEPackage_EFactoryInstance()) {
            super.copyReference(eReference, eObject, copyEObject);
        } else if (eReference.isMany()) {
            List referencedObjectsList = (List)referencedEObject;
            if (referencedObjectsList == null) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
            } else if (referencedObjectsList.size() == 0) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)referencedObjectsList);
            } else {
                for (Object referencedEObj : referencedObjectsList) {
                    Object copyReferencedEObject = this.get(referencedEObj);
                    if (copyReferencedEObject != null) {
                        ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(copyReferencedEObject);
                        continue;
                    }
                    if (this.mergeLinkedDiff((EObject)referencedEObj)) {
                        ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(this.get(referencedEObj));
                        continue;
                    }
                    if (referencedEObj instanceof EObject) {
                        Object copyReferencedObject = this.findReferencedObjectCopy((EObject)referencedEObj);
                        ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(copyReferencedObject);
                        continue;
                    }
                    ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(referencedEObj);
                }
            }
        } else if (referencedEObject == null) {
            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
        } else {
            Object copyReferencedEObject = this.get(referencedEObject);
            if (copyReferencedEObject != null) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
            } else if (this.mergeLinkedDiff((EObject)referencedEObject)) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), this.get(referencedEObject));
            } else if (referencedEObject instanceof EObject) {
                Object copyReferencedObject = this.findReferencedObjectCopy((EObject)referencedEObject);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedObject);
            } else {
                ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(referencedEObject);
            }
        }
    }

    protected Object findReferencedObjectCopy(EObject referencedEObject) {
        EObject copyReferencedObject = referencedEObject;
        if (referencedEObject.eResource() == null) {
            return this.findReferencedObjectCopyNullResource(referencedEObject);
        }
        Resource referencedResource = referencedEObject.eResource();
        String uriFragment = referencedEObject.eResource().getURIFragment(referencedEObject);
        Resource leftResource = null;
        Resource rightResource = null;
        if (this.diffResourceSet != null) {
            Iterator diffModels = this.diffResourceSet.getDiffModels().iterator();
            while (diffModels.hasNext() && leftResource == null && rightResource == null) {
                Resource resource;
                DiffModel aDiffModel = (DiffModel)diffModels.next();
                DiffModel referencedDiffModel = null;
                if (!aDiffModel.getLeftRoots().isEmpty() && ((EObject)aDiffModel.getLeftRoots().get(0)).eResource() != null) {
                    resource = ((EObject)aDiffModel.getLeftRoots().get(0)).eResource();
                    if (referencedEObject.eResource() == resource) {
                        referencedDiffModel = aDiffModel;
                    }
                }
                if (referencedDiffModel == null && !aDiffModel.getRightRoots().isEmpty() && ((EObject)aDiffModel.getRightRoots().get(0)).eResource() != null) {
                    resource = ((EObject)aDiffModel.getRightRoots().get(0)).eResource();
                    if (referencedEObject.eResource() == resource) {
                        referencedDiffModel = aDiffModel;
                    }
                }
                if (referencedDiffModel == null) continue;
                leftResource = ((EObject)referencedDiffModel.getLeftRoots().get(0)).eResource();
                rightResource = ((EObject)referencedDiffModel.getRightRoots().get(0)).eResource();
            }
        } else if (this.diffModel != null) {
            if (!this.diffModel.getLeftRoots().isEmpty() && ((EObject)this.diffModel.getLeftRoots().get(0)).eResource() != null) {
                leftResource = ((EObject)this.diffModel.getLeftRoots().get(0)).eResource();
            }
            if (!this.diffModel.getRightRoots().isEmpty() && ((EObject)this.diffModel.getRightRoots().get(0)).eResource() != null) {
                rightResource = ((EObject)this.diffModel.getRightRoots().get(0)).eResource();
            }
        }
        if (referencedResource == leftResource && rightResource != null) {
            copyReferencedObject = rightResource.getEObject(uriFragment);
        } else if (referencedResource == rightResource && leftResource != null) {
            copyReferencedObject = leftResource.getEObject(uriFragment);
        }
        return copyReferencedObject;
    }

    protected Object findReferencedObjectCopyNullResource(EObject referencedObject) {
        EObject copyReferencedObject = referencedObject;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)referencedObject);
        EObject leftRoot = null;
        EObject rightRoot = null;
        if (this.diffResourceSet != null) {
            Iterator diffModels = this.diffResourceSet.getDiffModels().iterator();
            while (diffModels.hasNext() && leftRoot == null && rightRoot == null) {
                DiffModel aDiffModel = (DiffModel)diffModels.next();
                DiffModel referencedDiffModel = null;
                int rootIndex = 0;
                int i = 0;
                while (i < aDiffModel.getLeftRoots().size()) {
                    if (rootContainer == aDiffModel.getLeftRoots().get(i)) {
                        referencedDiffModel = aDiffModel;
                        rootIndex = i;
                    }
                    ++i;
                }
                if (referencedDiffModel == null) {
                    i = 0;
                    while (i < aDiffModel.getRightRoots().size()) {
                        if (rootContainer == aDiffModel.getRightRoots().get(i)) {
                            referencedDiffModel = aDiffModel;
                            rootIndex = i;
                        }
                        ++i;
                    }
                }
                if (referencedDiffModel == null) continue;
                if (referencedDiffModel.getLeftRoots().size() >= rootIndex) {
                    leftRoot = (EObject)referencedDiffModel.getLeftRoots().get(rootIndex);
                }
                if (referencedDiffModel.getRightRoots().size() < rootIndex) continue;
                rightRoot = (EObject)referencedDiffModel.getRightRoots().get(rootIndex);
            }
        } else if (this.diffModel != null) {
            int rootIndex = -1;
            int i = 0;
            while (i < this.diffModel.getLeftRoots().size()) {
                if (rootContainer == this.diffModel.getLeftRoots().get(i)) {
                    rootIndex = i;
                }
                ++i;
            }
            i = 0;
            while (i < this.diffModel.getRightRoots().size()) {
                if (rootContainer == this.diffModel.getRightRoots().get(i)) {
                    rootIndex = i;
                }
                ++i;
            }
            if (this.diffModel.getLeftRoots().size() >= rootIndex) {
                leftRoot = (EObject)this.diffModel.getLeftRoots().get(rootIndex);
            }
            if (this.diffModel.getRightRoots().size() >= rootIndex) {
                rightRoot = (EObject)this.diffModel.getRightRoots().get(rootIndex);
            }
        }
        String uriFragment = EcoreUtil.getURI((EObject)referencedObject).toString().substring(2);
        copyReferencedObject = rootContainer == leftRoot && rightRoot != null ? EMFCompareEObjectCopier.getEObject(rightRoot, uriFragment) : (rootContainer == rightRoot && leftRoot != null ? EMFCompareEObjectCopier.getEObject(leftRoot, uriFragment) : referencedObject);
        return copyReferencedObject;
    }

    private void copyFeatureMap(EObject eObject, EStructuralFeature eStructuralFeature) {
        FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
        FeatureMap copyFeatureMap = (FeatureMap)((EObject)this.get(eObject)).eGet(this.getTarget(eStructuralFeature));
        int copyFeatureMapSize = copyFeatureMap.size();
        int k = 0;
        while (k < featureMap.size()) {
            block5: {
                block6: {
                    Object copyReferencedEObject;
                    EStructuralFeature feature;
                    block7: {
                        feature = featureMap.getEStructuralFeature(k);
                        if (!(feature instanceof EReference)) break block6;
                        Object referencedEObject = featureMap.getValue(k);
                        copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject != null || referencedEObject == null) break block7;
                        EReference reference = (EReference)feature;
                        if (!this.useOriginalReferences || reference.isContainment() || reference.getEOpposite() != null) break block5;
                        copyReferencedEObject = referencedEObject;
                    }
                    if (!copyFeatureMap.add(feature, copyReferencedEObject)) {
                        int l = 0;
                        while (l < copyFeatureMapSize) {
                            if (copyFeatureMap.getEStructuralFeature(l) == feature && copyFeatureMap.getValue(l) == copyReferencedEObject) {
                                copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                --copyFeatureMapSize;
                                break block5;
                            }
                            ++l;
                        }
                    }
                    break block5;
                }
                copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
            }
            ++k;
        }
    }

    private void handleLinkedResourceDependencyChange(EObject element) {
        for (ResourceDependencyChange dependencyChange : new ArrayList<ResourceDependencyChange>(this.dependencyChanges)) {
            Resource resource = ((EObject)dependencyChange.getRoots().get(0)).eResource();
            if (resource != element.eResource() || dependencyChange.eContainer() == null) continue;
            EcoreUtil.remove((EObject)dependencyChange);
            this.dependencyChanges.remove(dependencyChange);
            this.put(element, element);
            break;
        }
    }

    private boolean mergeLinkedDiff(EObject element) {
        boolean hasMerged = false;
        TreeIterator diffIterator = this.diffResourceSet != null ? this.diffResourceSet.eAllContents() : this.diffModel.eAllContents();
        while (diffIterator.hasNext()) {
            EObject next = (EObject)diffIterator.next();
            if (next instanceof ModelElementChangeLeftTarget) {
                if (((ModelElementChangeLeftTarget)next).getLeftElement() != element) continue;
                MergeService.merge((ModelElementChangeLeftTarget)next, true);
                hasMerged = true;
                break;
            }
            if (!(next instanceof ModelElementChangeRightTarget) || ((ModelElementChangeRightTarget)next).getRightElement() != element) continue;
            MergeService.merge((ModelElementChangeRightTarget)next, false);
            hasMerged = true;
            break;
        }
        return hasMerged;
    }

    private static EObject getEObject(EObject container, String fragment) {
        String uriFragment = fragment;
        int length = uriFragment.length();
        if (length > 0) {
            int index;
            if (uriFragment.charAt(0) == '/') {
                ArrayList<String> uriFragmentPath = new ArrayList<String>(4);
                int start = 1;
                int i = 1;
                while (i < length) {
                    if (uriFragment.charAt(i) == '/') {
                        if (start == i) {
                            uriFragmentPath.add("");
                        } else {
                            uriFragmentPath.add(uriFragment.substring(start, i));
                        }
                        start = i + 1;
                    }
                    ++i;
                }
                uriFragmentPath.add(uriFragment.substring(start));
                return EMFCompareEObjectCopier.getEObject(container, uriFragmentPath);
            }
            if (uriFragment.charAt(length - 1) == '?' && (index = uriFragment.lastIndexOf(63, length - 2)) > 0) {
                uriFragment = uriFragment.substring(0, index);
            }
        }
        return EMFCompareEObjectCopier.getEObjectByID(container, uriFragment);
    }

    private static EObject getEObject(EObject container, List<String> uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = container;
        int i = 1;
        while (i < size && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
            ++i;
        }
        return eObject;
    }

    private static EObject getEObjectByID(EObject container, String id) {
        EObject result = null;
        TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)container, (boolean)false);
        while (result == null && iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            String eObjectId = EcoreUtil.getID((EObject)eObject);
            if (eObjectId == null || !eObjectId.equals(id)) continue;
            result = eObject;
        }
        return result;
    }
}

