/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.synchronization;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.logical.synchronization.EMFDelta;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.team.core.diff.IDiff;

public class EMFResourceDelta
extends EMFDelta {
    private Resource localResource;
    private Resource remoteResource;
    private Resource ancestorResource;
    private IDiff diff;
    private DiffModel diffModel;

    public EMFResourceDelta(EMFDelta parent, DiffModel diffModel, IDiff resourceDiff, Resource localResource, Resource remoteResource, Resource ancestorResource) {
        super(parent);
        this.diff = resourceDiff;
        this.diffModel = diffModel;
        this.localResource = localResource;
        this.remoteResource = remoteResource;
        this.ancestorResource = ancestorResource;
        this.createChildren();
    }

    public void clear() {
        this.localResource = null;
        this.remoteResource = null;
        this.ancestorResource = null;
        this.diff = null;
        this.diffModel = null;
        super.clear();
    }

    public Object getLocal() {
        return this.localResource;
    }

    public Object getAncestor() {
        return this.ancestorResource;
    }

    public Object getRemote() {
        return this.remoteResource;
    }

    public IDiff getDiff() {
        return this.diff;
    }

    public IPath getPath() {
        IResource localIResource = EclipseModelUtils.findIResource((Resource)this.localResource);
        if (localIResource != null) {
            return localIResource.getFullPath();
        }
        return Path.EMPTY;
    }

    public boolean isDeltaFor(Object object) {
        if (!(object instanceof Resource)) {
            return false;
        }
        boolean isDelta = false;
        IResource localIResource = EclipseModelUtils.findIResource((Resource)this.localResource);
        IResource compareTo = EclipseModelUtils.findIResource((Resource)((Resource)object));
        if (localIResource != null && compareTo != null) {
            isDelta = localIResource.getFullPath().equals((Object)compareTo.getFullPath());
        }
        return isDelta;
    }

    protected void createChildren() {
        if (this.diffModel.getOwnedElements().size() == 1) {
            DiffGroup group = (DiffGroup)this.diffModel.getOwnedElements().get(0);
            for (DiffElement childDiff : group.getSubDiffElements()) {
                this.createChildDelta(childDiff);
            }
        }
    }
}

