/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.filter;

import java.util.ArrayList;
import org.eclipse.emf.compare.ui.viewer.AbstractOrderingAction;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterDescriptor;
import org.eclipse.emf.compare.ui.viewer.filter.FiltersMenu;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureMergeViewer;

public class FilteringAction
extends AbstractOrderingAction {
    private IDifferenceFilter relatedFilter;
    private FiltersMenu menu;

    public FilteringAction(DifferenceFilterDescriptor desc, ParameterizedStructureMergeViewer viewer, FiltersMenu pMenu) {
        super(desc.getName(), 2, viewer);
        this.relatedFilter = desc.getExtension();
        this.menu = pMenu;
    }

    public FilteringAction(DifferenceFilterDescriptor desc, ParameterizedStructureMergeViewer viewer, boolean checked, FiltersMenu pMenu) {
        this(desc, viewer, pMenu);
        this.setChecked(checked);
        this.menu = pMenu;
    }

    protected void doRun(ParameterizedStructureContentProvider provider) {
        ArrayList<IDifferenceFilter> filters = new ArrayList<IDifferenceFilter>();
        if (this.isChecked()) {
            this.menu.getSelectedFilters().add(this.relatedFilter);
        } else {
            this.menu.getSelectedFilters().remove(this.relatedFilter);
        }
        filters.addAll(this.menu.getSelectedFilters());
        this.mViewer.getCompareConfiguration().setProperty("structure.ordering.filters", filters);
    }
}

