/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.WizardLauncher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffElementTransformAction
implements IEditorActionDelegate,
ISelectionListener {
    private Collection<DiffElement> selection = new HashSet<DiffElement>();
    private IWorkbenchSite site;
    private IAction action;
    private EList<EObject> rightRoots;
    private EList<EObject> leftRoots;
    private static final String DEFAULT_FILE_NAME = "result.mpatch";

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setSelection(selection);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null && !targetEditor.getSite().equals(this.site)) {
            if (this.site != null) {
                this.site.getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
            }
            this.site = targetEditor.getSite();
            this.site.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        }
        this.action = action;
    }

    public void run(IAction action) {
        if (this.selection.size() > 0) {
            DiffGroup container = DiffFactory.eINSTANCE.createDiffGroup();
            container.getSubDiffElements().addAll(EcoreUtil.copyAll(this.selection));
            this.callExportEmfdiffWizard(container);
        } else if (this.site != null) {
            MessageDialog.openInformation((Shell)this.site.getShell(), (String)"No differences selected", (String)"There are no differences selected. Nothing to do...");
        }
    }

    private void callExportEmfdiffWizard(DiffGroup container) {
        ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        DiffModel diffModel = DiffFactory.eINSTANCE.createDiffModel();
        diffModel.getLeftRoots().addAll(this.leftRoots);
        diffModel.getRightRoots().addAll(this.rightRoots);
        snapshot.setDiff(diffModel);
        diffModel.getOwnedElements().add((Object)container);
        if (!this.leftRoots.isEmpty() && ((EObject)this.leftRoots.get(0)).eResource() != null) {
            IFile mPatchFile = CommonUtils.createNewIFile((URI)((EObject)this.leftRoots.get(0)).eResource().getURI(), (String)DEFAULT_FILE_NAME);
            WizardLauncher.openWizard((ComparisonSnapshot)snapshot, mPatchFile);
        } else {
            WizardLauncher.openWizard((ComparisonSnapshot)snapshot);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
    }

    private void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        this.selection.clear();
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof DiffElement) {
                    this.addDiffElementsToSelection((DiffElement)obj, this.selection);
                } else if (obj instanceof DiffModel) {
                    this.addDiffElementsToSelection((DiffModel)obj, this.selection);
                }
                ++n2;
            }
            if (!this.selection.isEmpty()) {
                DiffModel diffModel = this.getDiffModelContainer((EObject)this.selection.iterator().next());
                this.leftRoots = diffModel == null ? null : diffModel.getLeftRoots();
                EList eList = this.rightRoots = diffModel == null ? null : diffModel.getRightRoots();
            }
        }
        if (this.action != null) {
            this.action.setEnabled(!this.selection.isEmpty());
        }
    }

    private DiffModel getDiffModelContainer(EObject obj) {
        if (obj.eContainer() == null) {
            return null;
        }
        if (obj.eContainer() instanceof DiffModel) {
            return (DiffModel)obj.eContainer();
        }
        return this.getDiffModelContainer(obj.eContainer());
    }

    private void addDiffElementsToSelection(DiffModel diffModel, Collection<DiffElement> selection) {
        for (DiffElement diffElement : diffModel.getOwnedElements()) {
            this.addDiffElementsToSelection(diffElement, selection);
        }
    }

    private void addDiffElementsToSelection(DiffElement diffElement, Collection<DiffElement> selection) {
        if (diffElement instanceof DiffGroup) {
            DiffGroup group = (DiffGroup)diffElement;
            for (DiffElement diffElement2 : group.getSubDiffElements()) {
                this.addDiffElementsToSelection(diffElement2, selection);
            }
        } else {
            selection.add(diffElement);
        }
    }
}

