/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.viewmodel;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiagramShowHideElement;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramEdgeChange;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramHideElement;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramLabelChange;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramModelElementChangeRightTarget;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramMoveNode;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramShowElement;
import org.eclipse.emf.compare.diagram.diagramdiff.util.DiagramdiffSwitch;
import org.eclipse.emf.compare.diagram.ui.GMFComparePlugin;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationDiffVisitor {
    private DiagramdiffSwitchVisitor diagramdiffSwitch = new DiagramdiffSwitchVisitor();
    private boolean annote;
    private IMatchManager.MatchSide matchSide;

    public boolean isAnnote() {
        return this.annote;
    }

    public IMatchManager.MatchSide getMatchSide() {
        return this.matchSide;
    }

    public void addEannotations(List<DiffElement> diffs, IMatchManager.MatchSide side) {
        this.annote = true;
        this.matchSide = side;
        this.doVisit(diffs);
    }

    public void removeEAnnotations(List<DiffElement> diffs, IMatchManager.MatchSide side) {
        this.annote = false;
        this.matchSide = side;
        this.doVisit(diffs);
    }

    private void doVisit(List<DiffElement> diffs) {
        MultiStatus status = new MultiStatus("org.eclipse.emf.compare.diagram.ui", 2, "Diff visitor failed.", null);
        for (DiffElement diffElement : diffs) {
            status.merge((IStatus)this.diagramdiffSwitch.doSwitch((EObject)diffElement));
        }
        if (!status.isOK()) {
            EMFComparePlugin.log((String)status.getMessage(), (boolean)false);
        }
    }

    protected boolean annotateNotation(View element, String annotation) {
        boolean result = false;
        if (this.isAnnote()) {
            EAnnotation diffAnnotation = null;
            if (element.getEAnnotation("diff-marker") == null) {
                diffAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                diffAnnotation.setSource("diff-marker");
                result = element.getEAnnotations().add((Object)diffAnnotation);
            } else {
                diffAnnotation = element.getEAnnotation("diff-marker");
            }
            diffAnnotation.getDetails().put((Object)annotation, (Object)"diffDetail");
            result = true;
        } else if (element.getEAnnotation("diff-marker") != null) {
            EAnnotation diffAnnotation = element.getEAnnotation("diff-marker");
            result = element.getEAnnotations().remove((Object)diffAnnotation);
        }
        return result;
    }

    protected boolean isHiddenDiff(DiffElement diff) {
        return !diff.getIsHiddenBy().isEmpty();
    }

    protected IStatus checkResult(boolean ok) {
        if (ok) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiagramdiffSwitchVisitor
    extends DiagramdiffSwitch<IStatus> {
        private DiagramdiffSwitchVisitor() {
        }

        public IStatus caseDiagramLabelChange(DiagramLabelChange diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && GMFComparePlugin.isValid(diff.getLeftElement()) && GMFComparePlugin.isValid(diff.getRightElement())) {
                result = NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT ? (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getLeftElement(), "diff-label-modified")) : (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getRightElement(), "diff-label-modified"));
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramShowElement(DiagramShowElement diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && diff instanceof BusinessDiagramShowHideElement) {
                if (diff.isRemote()) {
                    if (NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.RIGHT) {
                        result = NotationDiffVisitor.this.annotateNotation(((BusinessDiagramShowHideElement)diff).getRightView(), "diff-showed");
                    }
                } else if (NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT) {
                    result = NotationDiffVisitor.this.annotateNotation(((BusinessDiagramShowHideElement)diff).getLeftView(), "diff-showed");
                }
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramHideElement(DiagramHideElement diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && diff instanceof BusinessDiagramShowHideElement) {
                if (diff.isRemote()) {
                    if (NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT) {
                        result = NotationDiffVisitor.this.annotateNotation(((BusinessDiagramShowHideElement)diff).getLeftView(), "diff-hided");
                    }
                } else if (NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.RIGHT) {
                    result = NotationDiffVisitor.this.annotateNotation(((BusinessDiagramShowHideElement)diff).getRightView(), "diff-hided");
                }
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramMoveNode(DiagramMoveNode diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && GMFComparePlugin.isValid(diff.getLeftElement()) && GMFComparePlugin.isValid(diff.getRightElement())) {
                result = NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT ? (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getLeftElement(), "diff-moved")) : (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getRightElement(), "diff-moved"));
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramEdgeChange(DiagramEdgeChange diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && GMFComparePlugin.isValid(diff.getLeftElement()) && GMFComparePlugin.isValid(diff.getRightElement())) {
                result = NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT ? (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getLeftElement(), "diff-moved")) : (result &= NotationDiffVisitor.this.annotateNotation((View)diff.getRightElement(), "diff-moved"));
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramModelElementChangeLeftTarget(DiagramModelElementChangeLeftTarget diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && GMFComparePlugin.isValid(diff.getLeftElement()) && NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.LEFT) {
                result = NotationDiffVisitor.this.annotateNotation((View)diff.getLeftElement(), "diff-added");
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus caseDiagramModelElementChangeRightTarget(DiagramModelElementChangeRightTarget diff) {
            boolean result = true;
            if (!NotationDiffVisitor.this.isHiddenDiff((DiffElement)diff) && GMFComparePlugin.isValid(diff.getRightElement()) && NotationDiffVisitor.this.getMatchSide() == IMatchManager.MatchSide.RIGHT) {
                result = NotationDiffVisitor.this.annotateNotation((View)diff.getRightElement(), "diff-removed");
            }
            return NotationDiffVisitor.this.checkResult(result);
        }

        public IStatus defaultCase(EObject diff) {
            return Status.OK_STATUS;
        }
    }
}

