/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.compare.mpatch.common.CommonMPatchPlugin;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionLoader;
import org.eclipse.emf.compare.mpatch.extension.IMPatchApplication;
import org.eclipse.emf.compare.mpatch.extension.IMPatchResolution;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.extension.IModelDescriptorCreator;
import org.eclipse.emf.compare.mpatch.extension.ISymbolicReferenceCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionManager {
    private static final String EXTENSION_NAME_DESCRIPTOR_CREATOR = "model_descriptor_creator";
    private static final String EXTENSION_NAME_SYMREF_CREATOR = "symbolic_reference_creator";
    private static final String EXTENSION_NAME_APPLIER = "diff_applier";
    private static final String EXTENSION_NAME_TRANSFORMATION = "diff_transformation";
    private static final String EXTENSION_NAME_RESOLUTION = "diff_resolver";
    private final Map<String, IMPatchResolution> allResultions = new TreeMap<String, IMPatchResolution>();
    private final Map<String, IMPatchApplication> allApplications = new TreeMap<String, IMPatchApplication>();
    private final Map<String, ISymbolicReferenceCreator> allSymrefCreators = new TreeMap<String, ISymbolicReferenceCreator>();
    private final Map<String, IModelDescriptorCreator> allModelDescrCreators = new TreeMap<String, IModelDescriptorCreator>();
    private final Map<String, IMPatchTransformation> allTransformations = new TreeMap<String, IMPatchTransformation>();
    private final List<String> mandatoryTransformations = new ArrayList<String>();
    private static final Set<String> NO_DEFAULT_SELECTED_WARNING_SHOWN = new HashSet<String>();
    private static ExtensionManager _INSTANCE = new ExtensionManager();

    private ExtensionManager() {
    }

    public static Map<String, IMPatchResolution> getAllResolutions() {
        if (ExtensionManager._INSTANCE.allResultions.isEmpty()) {
            Collection<IMPatchResolution> allExtensions = ExtensionLoader.getAllExtensions("org.eclipse.emf.compare.mpatch.resolve", EXTENSION_NAME_RESOLUTION);
            for (IMPatchResolution mPatchResolution : allExtensions) {
                ExtensionManager._INSTANCE.allResultions.put(mPatchResolution.getLabel(), mPatchResolution);
            }
        }
        return ExtensionManager._INSTANCE.allResultions;
    }

    public static Map<String, IMPatchTransformation> getAllTransformations() {
        if (ExtensionManager._INSTANCE.allTransformations.isEmpty()) {
            Collection<IMPatchTransformation> allExtensions = ExtensionLoader.getAllExtensions("org.eclipse.emf.compare.mpatch.transform", EXTENSION_NAME_TRANSFORMATION);
            for (IMPatchTransformation mPatchTransformation : allExtensions) {
                if (ExtensionManager._INSTANCE.allTransformations.containsKey(mPatchTransformation.getLabel())) {
                    CommonMPatchPlugin.getDefault().logWarning("Name clash!!! Two transformations found with the same label and one of them will be ignored! Label: " + mPatchTransformation.getLabel(), new RuntimeException());
                    continue;
                }
                ExtensionManager._INSTANCE.allTransformations.put(mPatchTransformation.getLabel(), mPatchTransformation);
                if (mPatchTransformation.isOptional()) continue;
                int index = 0;
                while (ExtensionManager._INSTANCE.mandatoryTransformations.size() > index) {
                    String other = ExtensionManager._INSTANCE.mandatoryTransformations.get(index);
                    if (ExtensionManager._INSTANCE.allTransformations.get(other).getPriority() <= mPatchTransformation.getPriority()) break;
                    ++index;
                }
                ExtensionManager._INSTANCE.mandatoryTransformations.add(index, mPatchTransformation.getLabel());
            }
        }
        return ExtensionManager._INSTANCE.allTransformations;
    }

    public static Map<String, IMPatchApplication> getAllApplications() {
        if (ExtensionManager._INSTANCE.allApplications.isEmpty()) {
            Collection<IMPatchApplication> allExtensions = ExtensionLoader.getAllExtensions("org.eclipse.emf.compare.mpatch.apply", EXTENSION_NAME_APPLIER);
            for (IMPatchApplication mPatchApplication : allExtensions) {
                ExtensionManager._INSTANCE.allApplications.put(mPatchApplication.getLabel(), mPatchApplication);
            }
        }
        return ExtensionManager._INSTANCE.allApplications;
    }

    public static Map<String, ISymbolicReferenceCreator> getAllSymbolicReferenceCreators() {
        if (ExtensionManager._INSTANCE.allSymrefCreators.isEmpty()) {
            Collection<ISymbolicReferenceCreator> allExtensions = ExtensionLoader.getAllExtensions("org.eclipse.emf.compare.mpatch.symbolicreference", EXTENSION_NAME_SYMREF_CREATOR);
            for (ISymbolicReferenceCreator iSymrefCreator : allExtensions) {
                ExtensionManager._INSTANCE.allSymrefCreators.put(iSymrefCreator.getLabel(), iSymrefCreator);
            }
        }
        return ExtensionManager._INSTANCE.allSymrefCreators;
    }

    public static Map<String, IModelDescriptorCreator> getAllModelDescriptorCreators() {
        if (ExtensionManager._INSTANCE.allModelDescrCreators.isEmpty()) {
            Collection<IModelDescriptorCreator> allExtensions = ExtensionLoader.getAllExtensions("org.eclipse.emf.compare.mpatch.modeldescriptor", EXTENSION_NAME_DESCRIPTOR_CREATOR);
            for (IModelDescriptorCreator iModelDescriptorCreator : allExtensions) {
                ExtensionManager._INSTANCE.allModelDescrCreators.put(iModelDescriptorCreator.getLabel(), iModelDescriptorCreator);
            }
        }
        return ExtensionManager._INSTANCE.allModelDescrCreators;
    }

    public static IMPatchResolution getSelectedResolution() {
        String preferredResolution = CommonMPatchPlugin.getDefault().getPreferenceStore().getString("resolution");
        Map<String, IMPatchResolution> allResolutions = ExtensionManager.getAllResolutions();
        if (allResolutions.containsKey(preferredResolution)) {
            return allResolutions.get(preferredResolution);
        }
        if (allResolutions.isEmpty()) {
            CommonMPatchPlugin.getDefault().logError("No MPatch Resolution extension found! Please check installation.");
            return null;
        }
        IMPatchResolution mPatchResolution = allResolutions.values().iterator().next();
        if (NO_DEFAULT_SELECTED_WARNING_SHOWN.add("resolution")) {
            CommonMPatchPlugin.getDefault().logWarning("No MPatch Resolver was selected! So we just take the first we find: " + mPatchResolution.getLabel());
        }
        return mPatchResolution;
    }

    public static IMPatchApplication getSelectedApplication() {
        String preferredApplication = CommonMPatchPlugin.getDefault().getPreferenceStore().getString("application");
        Map<String, IMPatchApplication> allApplications = ExtensionManager.getAllApplications();
        if (allApplications.containsKey(preferredApplication)) {
            return allApplications.get(preferredApplication);
        }
        if (allApplications.isEmpty()) {
            CommonMPatchPlugin.getDefault().logError("No MPatch Application extension found! Please check installation.");
            return null;
        }
        IMPatchApplication mPatchApplication = allApplications.values().iterator().next();
        if (NO_DEFAULT_SELECTED_WARNING_SHOWN.add("application")) {
            CommonMPatchPlugin.getDefault().logWarning("No MPatch Application was selected! So we just take the first we find: " + mPatchApplication.getLabel());
        }
        return mPatchApplication;
    }

    public static ISymbolicReferenceCreator getSelectedSymbolicReferenceCreator() {
        String preferredSymrefCreator = CommonMPatchPlugin.getDefault().getPreferenceStore().getString("symbolic.reference");
        Map<String, ISymbolicReferenceCreator> allSymrefCreators = ExtensionManager.getAllSymbolicReferenceCreators();
        if (allSymrefCreators.containsKey(preferredSymrefCreator)) {
            return allSymrefCreators.get(preferredSymrefCreator);
        }
        if (allSymrefCreators.isEmpty()) {
            CommonMPatchPlugin.getDefault().logError("No MPatch Symbolic Reference Creator extension found! Please check installation.");
            return null;
        }
        ISymbolicReferenceCreator creator = allSymrefCreators.values().iterator().next();
        if (NO_DEFAULT_SELECTED_WARNING_SHOWN.add("symbolic.reference")) {
            CommonMPatchPlugin.getDefault().logWarning("No MPatch Symbolic Reference Creator was selected! So we just take the first we find: " + creator.getLabel());
        }
        return creator;
    }

    public static IModelDescriptorCreator getSelectedModelDescriptorCreator() {
        String preferredModelDescriptorCreator = CommonMPatchPlugin.getDefault().getPreferenceStore().getString("model.descriptor");
        Map<String, IModelDescriptorCreator> allModelDescriptorCreators = ExtensionManager.getAllModelDescriptorCreators();
        if (allModelDescriptorCreators.containsKey(preferredModelDescriptorCreator)) {
            return allModelDescriptorCreators.get(preferredModelDescriptorCreator);
        }
        if (allModelDescriptorCreators.isEmpty()) {
            CommonMPatchPlugin.getDefault().logError("No MPatch Model Descirptor Creator extension found! Please check installation.");
            return null;
        }
        IModelDescriptorCreator creator = allModelDescriptorCreators.values().iterator().next();
        if (NO_DEFAULT_SELECTED_WARNING_SHOWN.add("model.descriptor")) {
            CommonMPatchPlugin.getDefault().logWarning("No MPatch Model Descriptor Creator was selected! So we just take the first we find: " + creator.getLabel());
        }
        return creator;
    }

    public static List<String> getSelectedOptionalTransformations() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> preferencesList = Arrays.asList(CommonMPatchPlugin.getDefault().getPreferenceStore().getString("transformation.order").split(":"));
        Map<String, IMPatchTransformation> allTransformations = ExtensionManager.getAllTransformations();
        for (String transformationLabel : preferencesList) {
            if (!allTransformations.containsKey(transformationLabel) || !allTransformations.get(transformationLabel).isOptional()) continue;
            result.add(transformationLabel);
        }
        return result;
    }

    public static List<String> getUnselectedOptionalTransformations() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> preferencesList = Arrays.asList(CommonMPatchPlugin.getDefault().getPreferenceStore().getString("transformation.order").split(":"));
        Map<String, IMPatchTransformation> allTransformations = ExtensionManager.getAllTransformations();
        for (String label : allTransformations.keySet()) {
            if (preferencesList.contains(label) || !allTransformations.get(label).isOptional()) continue;
            result.add(label);
        }
        return result;
    }

    public static List<String> getMandatoryTransformations() {
        ExtensionManager.getAllTransformations();
        return ExtensionManager._INSTANCE.mandatoryTransformations;
    }

    public static boolean isShowMandatoryTransformationsSet() {
        return CommonMPatchPlugin.getDefault().getPreferenceStore().getBoolean("transformations.hide");
    }
}

