/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeLeftTargetMerger
extends DefaultMerger {
    @Override
    public void doApplyInOrigin() {
        ReferenceChangeLeftTarget theDiff = (ReferenceChangeLeftTarget)this.diff;
        EObject element = theDiff.getLeftElement();
        EObject leftTarget = theDiff.getLeftTarget();
        try {
            EFactory.eRemove((EObject)element, (String)theDiff.getReference().getName(), (Object)leftTarget);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
        }
        TreeIterator siblings = this.getDiffModel().eAllContents();
        while (siblings.hasNext()) {
            Resource res;
            DiffElement link;
            DiffElement op = (DiffElement)siblings.next();
            if (op instanceof ReferenceChangeLeftTarget) {
                link = (ReferenceChangeLeftTarget)op;
                if (!link.getReference().equals(theDiff.getReference().getEOpposite()) || !link.getLeftTarget().equals(element)) continue;
                this.removeFromContainer(link);
                continue;
            }
            if (!(op instanceof ResourceDependencyChange) || (res = ((EObject)(link = (ResourceDependencyChange)op).getRoots().get(0)).eResource()) != leftTarget.eResource()) continue;
            EcoreUtil.remove((EObject)link);
            res.unload();
        }
    }

    @Override
    public void doUndoInTarget() {
        EObject leftElement;
        Object leftRefValue;
        ReferenceChangeLeftTarget theDiff = (ReferenceChangeLeftTarget)this.diff;
        EReference reference = theDiff.getReference();
        EObject element = theDiff.getRightElement();
        EObject leftTarget = theDiff.getLeftTarget();
        EObject rightTarget = theDiff.getRightTarget();
        int index = -1;
        if (reference.isMany() && (leftRefValue = (leftElement = theDiff.getLeftElement()).eGet((EStructuralFeature)reference)) instanceof List) {
            List refLeftValueList = (List)leftRefValue;
            index = refLeftValueList.indexOf(leftTarget);
        }
        EObject copiedValue = MergeService.getCopier(this.diff).copyReferenceValue(reference, element, leftTarget, rightTarget, index);
        TreeIterator siblings = this.getDiffModel().eAllContents();
        while (siblings.hasNext()) {
            ReferenceChange link;
            DiffElement op = (DiffElement)siblings.next();
            if (op instanceof ReferenceChangeLeftTarget) {
                link = (ReferenceChangeLeftTarget)op;
                if (!link.getReference().equals(reference.getEOpposite()) || !link.getLeftTarget().equals(element)) continue;
                this.removeFromContainer(link);
                continue;
            }
            if (!(op instanceof ReferenceOrderChange) || (link = (ReferenceOrderChange)op).getLeftElement() != element || link.getReference() != reference) continue;
            ListIterator targetIterator = link.getLeftTarget().listIterator();
            boolean replaced = false;
            while (!replaced && targetIterator.hasNext()) {
                EObject target = (EObject)targetIterator.next();
                if (!target.eIsProxy() || !ReferenceChangeLeftTargetMerger.equalProxyURIs(((InternalEObject)target).eProxyURI(), EcoreUtil.getURI((EObject)leftTarget))) continue;
                targetIterator.set(copiedValue);
                replaced = true;
            }
        }
    }

    @Override
    protected List<DiffElement> getDependencies(boolean applyInOrigin) {
        if (!applyInOrigin) {
            return this.diff.getRequires();
        }
        return super.getDependencies(applyInOrigin);
    }
}

