/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.synchronization;

import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.impl.ConflictingDiffElementImpl;
import org.eclipse.emf.compare.logical.synchronization.EMFDelta;
import org.eclipse.emf.compare.logical.synchronization.EMFResourceDelta;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.diff.provider.TwoWayDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFEObjectDelta
extends EMFDelta {
    private EObject localObject;
    private EObject remoteObject;
    private EObject ancestorObject;
    private DiffGroup diffGroup;
    private IDiff diff;

    public EMFEObjectDelta(EMFDelta parent, DiffGroup diffGroup) {
        super(parent);
        this.diffGroup = diffGroup;
        EObject rightObject = diffGroup.getRightParent();
        String uriFragment = EcoreUtil.getURI((EObject)rightObject).fragment();
        EMFDelta resourceDeltaContainer = parent;
        while (resourceDeltaContainer.getParent() != null && !(resourceDeltaContainer instanceof EMFResourceDelta)) {
            resourceDeltaContainer = resourceDeltaContainer.getParent();
        }
        if (resourceDeltaContainer instanceof EMFResourceDelta) {
            Resource localResource = (Resource)((EMFResourceDelta)resourceDeltaContainer).getLocal();
            Resource remoteResource = (Resource)((EMFResourceDelta)resourceDeltaContainer).getRemote();
            Resource ancestorResource = (Resource)((EMFResourceDelta)resourceDeltaContainer).getAncestor();
            this.localObject = localResource.getEObject(uriFragment);
            this.remoteObject = remoteResource.getEObject(uriFragment);
            if (ancestorResource != null) {
                this.ancestorObject = ancestorResource.getEObject(uriFragment);
            }
        }
        this.createChildren();
    }

    @Override
    public void clear() {
        this.localObject = null;
        this.remoteObject = null;
        this.ancestorObject = null;
        this.diffGroup = null;
        this.diff = null;
        super.clear();
    }

    @Override
    public IDiff getDiff() {
        if (this.diff == null) {
            int localKind = 0;
            int remoteKind = 0;
            Iterator subDiffIterator = EMFEObjectDelta.getAllSubDifferences((DiffElement)this.diffGroup).iterator();
            while ((localKind == 0 || remoteKind == 0) && subDiffIterator.hasNext()) {
                DiffElement child = (DiffElement)subDiffIterator.next();
                if (child.isRemote()) {
                    remoteKind = 4;
                    continue;
                }
                localKind = 4;
            }
            if (this.ancestorObject != null) {
                TwoWayDiff localDiff = new TwoWayDiff(this.getPath(), localKind, 0);
                TwoWayDiff remoteDiff = new TwoWayDiff(this.getPath(), remoteKind, 0);
                this.diff = new ThreeWayDiff((ITwoWayDiff)localDiff, (ITwoWayDiff)remoteDiff);
            } else {
                this.diff = new TwoWayDiff(this.getPath(), localKind, 0);
            }
        }
        return this.diff;
    }

    @Override
    public Object getRemote() {
        return this.remoteObject;
    }

    @Override
    public Object getLocal() {
        return this.localObject;
    }

    @Override
    public Object getAncestor() {
        return this.ancestorObject;
    }

    @Override
    public IPath getPath() {
        URI uri = EcoreUtil.getURI((EObject)this.diffGroup.getRightParent());
        return new Path(uri.toString());
    }

    @Override
    protected void createChildren() {
        for (DiffElement diffElement : this.diffGroup.getSubDiffElements()) {
            this.createChildDelta(diffElement);
        }
    }

    @Override
    public boolean isDeltaFor(Object object) {
        if (!(object instanceof EObject)) {
            return false;
        }
        URI objectURI = this.localObject != null ? EcoreUtil.getURI((EObject)this.localObject) : (this.remoteObject != null ? EcoreUtil.getURI((EObject)this.remoteObject) : EcoreUtil.getURI((EObject)this.ancestorObject));
        return objectURI.equals((Object)EcoreUtil.getURI((EObject)((EObject)object)));
    }

    private static EList<DiffElement> getAllSubDifferences(DiffElement element) {
        BasicEList ownedDifferences = new BasicEList();
        for (DiffElement diff : element.getSubDiffElements()) {
            if (diff instanceof DiffGroup || diff instanceof ConflictingDiffElementImpl) {
                ownedDifferences.addAll(EMFEObjectDelta.getAllSubDifferences(diff));
                continue;
            }
            ownedDifferences.add((Object)diff);
        }
        return ownedDifferences;
    }
}

