/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.AbstractCheck;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesCheck
extends AbstractCheck {
    @Deprecated
    public AttributesCheck(EcoreUtil.CrossReferencer referencer) {
        super(referencer);
    }

    public AttributesCheck(IMatchManager manager) {
        super(manager);
    }

    public void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next)) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }

    public void checkAttributesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next)) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }

    protected boolean areDistinctValues(Object left, Object right) {
        return this.matcherHelper.areDistinctValues(left, right);
    }

    protected void checkAttributeUpdates(DiffGroup root, Match2Elements mapping, EAttribute attribute) throws FactoryException {
        String attributeName = attribute.getName();
        boolean distinct = false;
        if (attribute.isMany()) {
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attributeName));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attributeName));
            if (leftValue.size() != rightValue.size()) {
                distinct = true;
            } else {
                int i = 0;
                while (!distinct && i < leftValue.size()) {
                    distinct = this.areDistinctValues(leftValue.get(i), rightValue.get(i));
                    ++i;
                }
            }
        } else {
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            distinct = this.areDistinctValues(leftValue, rightValue);
        }
        if (distinct) {
            this.createNonConflictingAttributeChange(root, attribute, mapping.getLeftElement(), mapping.getRightElement());
        }
    }

    protected void checkAttributeUpdates(DiffGroup root, Match3Elements mapping, EAttribute attribute) throws FactoryException {
        String attributeName = attribute.getName();
        boolean rightDistinctFromOrigin = false;
        boolean rightDistinctFromLeft = false;
        boolean leftDistinctFromOrigin = false;
        if (attribute.isMany()) {
            int i;
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attributeName));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attributeName));
            List<Object> ancestorValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)attributeName));
            if (rightValue.size() != ancestorValue.size()) {
                rightDistinctFromOrigin = true;
            } else {
                i = 0;
                while (!rightDistinctFromOrigin && i < rightValue.size()) {
                    rightDistinctFromOrigin = this.areDistinctValues(rightValue.get(i), ancestorValue.get(i));
                    ++i;
                }
            }
            if (leftValue.size() != ancestorValue.size()) {
                leftDistinctFromOrigin = true;
            } else {
                i = 0;
                while (!leftDistinctFromOrigin && i < leftValue.size()) {
                    leftDistinctFromOrigin = this.areDistinctValues(leftValue.get(i), ancestorValue.get(i));
                    ++i;
                }
            }
            if (leftValue.size() != rightValue.size()) {
                rightDistinctFromLeft = true;
            } else {
                i = 0;
                while (!rightDistinctFromLeft && i < leftValue.size()) {
                    rightDistinctFromLeft = this.areDistinctValues(leftValue.get(i), rightValue.get(i));
                    ++i;
                }
            }
        } else {
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            Object ancestorValue = EFactory.eGet((EObject)mapping.getOriginElement(), (String)attributeName);
            rightDistinctFromOrigin = this.areDistinctValues(rightValue, ancestorValue);
            rightDistinctFromLeft = this.areDistinctValues(rightValue, leftValue);
            leftDistinctFromOrigin = this.areDistinctValues(leftValue, ancestorValue);
        }
        if (leftDistinctFromOrigin && !rightDistinctFromOrigin) {
            this.createNonConflictingAttributeChange(root, attribute, mapping.getLeftElement(), mapping.getRightElement());
        } else if (rightDistinctFromOrigin && !leftDistinctFromOrigin) {
            this.createRemoteAttributeChange(root, attribute, mapping);
        } else if (rightDistinctFromOrigin && leftDistinctFromOrigin || rightDistinctFromLeft) {
            this.checkConflictingAttributesUpdate(root, attribute, mapping);
        }
    }

    protected boolean shouldBeIgnored(EAttribute attribute) {
        boolean ignore = attribute.isTransient();
        ignore = ignore || attribute.isDerived();
        return ignore;
    }

    private void checkConflictingAttributesUpdate(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        if (!attribute.isMany()) {
            this.createConflictingAttributeChange(root, attribute, mapping);
        } else {
            ArrayList<Object> remoteDeletedValues = new ArrayList<Object>();
            ArrayList<Object> remoteAddedValues = new ArrayList<Object>();
            ArrayList<Object> deletedValues = new ArrayList<Object>();
            ArrayList<Object> addedValues = new ArrayList<Object>();
            this.populateThreeWayAttributeChanges(mapping, attribute, addedValues, deletedValues, remoteAddedValues, remoteDeletedValues);
            this.createRemoteAttributeDiffs(root, attribute, mapping.getLeftElement(), mapping.getRightElement(), remoteAddedValues, remoteDeletedValues);
            this.createLocalAttributeDiffs(root, attribute, mapping.getLeftElement(), mapping.getRightElement(), addedValues, deletedValues);
        }
    }

    private void createLocalAttributeDiffs(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement, List<Object> addedValues, List<Object> deletedValues) throws FactoryException {
        AttributeChange operation;
        ArrayList<AttributeChangeLeftTarget> addedValuesDiffs = new ArrayList<AttributeChangeLeftTarget>(addedValues.size());
        ArrayList<AttributeChangeRightTarget> deletedValuesDiffs = new ArrayList<AttributeChangeRightTarget>(deletedValues.size());
        for (Object aValue : addedValues) {
            operation = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
            operation.setAttribute(attribute);
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setLeftTarget(aValue);
            root.getSubDiffElements().add((Object)operation);
            addedValuesDiffs.add((AttributeChangeLeftTarget)operation);
        }
        for (Object aValue : deletedValues) {
            operation = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
            operation.setAttribute(attribute);
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setRightTarget(aValue);
            root.getSubDiffElements().add((Object)operation);
            deletedValuesDiffs.add((AttributeChangeRightTarget)operation);
        }
        if (attribute.isOrdered()) {
            this.checkAttributeOrderChange(root, attribute, leftElement, rightElement, addedValuesDiffs, deletedValuesDiffs);
        }
    }

    private void createRemoteAttributeDiffs(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement, List<Object> remoteDeletedValues, List<Object> remoteAddedValues) throws FactoryException {
        AttributeChange operation;
        ArrayList<AttributeChangeLeftTarget> remoteDeletedValuesDiffs = new ArrayList<AttributeChangeLeftTarget>(remoteDeletedValues.size());
        ArrayList<AttributeChangeRightTarget> remoteAddedValuesDiffs = new ArrayList<AttributeChangeRightTarget>(remoteAddedValues.size());
        for (Object aValue : remoteDeletedValues) {
            operation = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
            operation.setAttribute(attribute);
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setLeftTarget(aValue);
            operation.setRemote(true);
            root.getSubDiffElements().add((Object)operation);
            remoteDeletedValuesDiffs.add((AttributeChangeLeftTarget)operation);
        }
        for (Object aValue : remoteAddedValues) {
            operation = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
            operation.setAttribute(attribute);
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setRightTarget(aValue);
            operation.setRemote(true);
            root.getSubDiffElements().add((Object)operation);
            remoteAddedValuesDiffs.add((AttributeChangeRightTarget)operation);
        }
        if (attribute.isOrdered()) {
            this.checkAttributeRemoteOrderChange(root, attribute, leftElement, rightElement, remoteDeletedValuesDiffs, remoteAddedValuesDiffs);
        }
    }

    private void populateThreeWayAttributeChanges(Match3Elements mapping, EAttribute attribute, List<Object> addedValues, List<Object> deletedValues, List<Object> remoteAddedValues, List<Object> remoteDeletedValues) throws FactoryException {
        String attributeName = attribute.getName();
        List<Object> leftValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attributeName));
        List<Object> rightValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attributeName));
        List<Object> ancestorValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)attributeName));
        ArrayList<Object> leftCopy = new ArrayList<Object>(leftValues);
        ArrayList<Object> ancestorCopy = new ArrayList<Object>(ancestorValues);
        for (Object right : rightValues) {
            Object leftMatched = null;
            Iterator leftIterator = leftCopy.iterator();
            while (leftMatched == null && leftIterator.hasNext()) {
                Object next = leftIterator.next();
                if (this.areDistinctValues(right, next)) continue;
                leftMatched = next;
            }
            Object ancestorMatched = null;
            Iterator ancestorIterator = ancestorCopy.iterator();
            while (ancestorMatched == null && ancestorIterator.hasNext()) {
                Object next = ancestorIterator.next();
                if (this.areDistinctValues(right, next)) continue;
                ancestorMatched = next;
            }
            if (leftMatched == null && ancestorMatched == null) {
                remoteAddedValues.add(right);
            } else if (leftMatched == null) {
                deletedValues.add(right);
            }
            if (leftMatched != null) {
                leftCopy.remove(leftMatched);
            }
            if (ancestorMatched == null) continue;
            ancestorCopy.remove(ancestorMatched);
        }
        ArrayList<Object> rightCopy = new ArrayList<Object>(rightValues);
        ancestorCopy = new ArrayList<Object>(ancestorValues);
        for (Object left : leftValues) {
            Object rightMatched = null;
            Iterator rightIterator = rightCopy.iterator();
            while (rightMatched == null && rightIterator.hasNext()) {
                Object next = rightIterator.next();
                if (this.areDistinctValues(left, next)) continue;
                rightMatched = next;
            }
            Object ancestorMatched = null;
            Iterator ancestorIterator = ancestorCopy.iterator();
            while (ancestorMatched == null && ancestorIterator.hasNext()) {
                Object next = ancestorIterator.next();
                if (this.areDistinctValues(left, next)) continue;
                ancestorMatched = next;
            }
            if (rightMatched == null && ancestorMatched == null) {
                addedValues.add(left);
            } else if (rightMatched == null) {
                remoteDeletedValues.add(left);
            }
            if (rightMatched != null) {
                rightCopy.remove(rightMatched);
            }
            if (ancestorMatched == null) continue;
            ancestorCopy.remove(ancestorMatched);
        }
    }

    private void createConflictingAttributeChange(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingAttributeChange(dummyGroup, attribute, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            for (DiffElement subDiff : new ArrayList<DiffElement>((Collection<DiffElement>)dummyGroup.getSubDiffElements())) {
                conflictingDiff.getSubDiffElements().add((Object)subDiff);
            }
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private void createNonConflictingAttributeChange(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement) throws FactoryException {
        if (attribute.isMany()) {
            List<Object> rightValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)rightElement, (String)attribute.getName()));
            List<Object> leftValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)leftElement, (String)attribute.getName()));
            List<Object> addedValues = this.computeAddedValues(leftValues, rightValues);
            List<Object> deletedValues = this.computeDeletedValues(leftValues, rightValues);
            this.createLocalAttributeDiffs(root, attribute, leftElement, rightElement, addedValues, deletedValues);
        } else {
            UpdateAttribute operation = DiffFactory.eINSTANCE.createUpdateAttribute();
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }

    protected void checkAttributeOrderChange(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement, List<AttributeChangeLeftTarget> addedValues, List<AttributeChangeRightTarget> deletedValues) throws FactoryException {
        List<Object> rightValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)rightElement, (String)attribute.getName()));
        List<Object> leftValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)leftElement, (String)attribute.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>(deletedValues.size());
        for (AttributeChangeLeftTarget added : addedValues) {
            leftValues.remove(added.getLeftTarget());
        }
        for (AttributeChangeRightTarget removed : deletedValues) {
            int removedIndex = rightValues.indexOf(removed.getRightTarget());
            removedIndices.add(removedIndex);
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < leftValues.size()) {
            for (Integer removedIndex : new ArrayList(removedIndices)) {
                if (i != removedIndex) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndex);
            }
            if (this.areDistinctValues(leftValues.get(i), rightValues.get(expectedIndex++))) {
                AttributeOrderChange attributeChange = DiffFactory.eINSTANCE.createAttributeOrderChange();
                attributeChange.setAttribute(attribute);
                attributeChange.setLeftElement(leftElement);
                attributeChange.setRightElement(rightElement);
                root.getSubDiffElements().add((Object)attributeChange);
                break;
            }
            ++i;
        }
    }

    protected void checkAttributeRemoteOrderChange(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement, List<AttributeChangeLeftTarget> remoteDeletedValues, List<AttributeChangeRightTarget> remoteAddedValues) throws FactoryException {
        List<Object> rightValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)rightElement, (String)attribute.getName()));
        List<Object> leftValues = this.convertFeatureMapList(EFactory.eGetAsList((EObject)leftElement, (String)attribute.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>(remoteAddedValues.size());
        for (AttributeChangeLeftTarget remoteDeleted : remoteDeletedValues) {
            leftValues.remove(remoteDeleted.getLeftTarget());
        }
        for (AttributeChangeRightTarget remoteAdded : remoteAddedValues) {
            int removedIndex = rightValues.indexOf(remoteAdded.getRightTarget());
            removedIndices.add(removedIndex);
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < leftValues.size()) {
            for (Integer removedIndex : new ArrayList(removedIndices)) {
                if (i != removedIndex) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndex);
            }
            if (this.areDistinctValues(leftValues.get(i), rightValues.get(expectedIndex))) {
                AttributeOrderChange attributeChange = DiffFactory.eINSTANCE.createAttributeOrderChange();
                attributeChange.setAttribute(attribute);
                attributeChange.setLeftElement(leftElement);
                attributeChange.setRightElement(rightElement);
                attributeChange.setRemote(true);
                root.getSubDiffElements().add((Object)attributeChange);
                break;
            }
            ++i;
        }
    }

    private List<Object> computeAddedValues(List<Object> leftValues, List<Object> rightValues) {
        ArrayList<Object> result = new ArrayList<Object>(leftValues);
        ArrayList<Object> rightCopy = new ArrayList<Object>(rightValues);
        for (Object left : leftValues) {
            Object matched = null;
            Iterator rightIterator = rightCopy.iterator();
            while (matched == null && rightIterator.hasNext()) {
                Object next = rightIterator.next();
                if (this.areDistinctValues(left, next)) continue;
                matched = next;
            }
            if (matched == null) continue;
            rightCopy.remove(matched);
            result.remove(left);
        }
        return result;
    }

    private List<Object> computeDeletedValues(List<Object> leftValues, List<Object> rightValues) {
        ArrayList<Object> result = new ArrayList<Object>(rightValues);
        ArrayList<Object> leftCopy = new ArrayList<Object>(leftValues);
        for (Object right : rightValues) {
            Object matched = null;
            Iterator leftIterator = leftCopy.iterator();
            while (matched == null && leftIterator.hasNext()) {
                Object next = leftIterator.next();
                if (this.areDistinctValues(right, next)) continue;
                matched = next;
            }
            if (matched == null) continue;
            leftCopy.remove(matched);
            result.remove(right);
        }
        return result;
    }

    private void createRemoteAttributeChange(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        if (attribute.isMany()) {
            ArrayList<Object> remoteDeletedValues = new ArrayList<Object>();
            ArrayList<Object> remoteAddedValues = new ArrayList<Object>();
            this.populateThreeWayAttributeChanges(mapping, attribute, new ArrayList<Object>(), new ArrayList<Object>(), remoteAddedValues, remoteDeletedValues);
            this.createRemoteAttributeDiffs(root, attribute, mapping.getLeftElement(), mapping.getRightElement(), remoteDeletedValues, remoteAddedValues);
        } else {
            UpdateAttribute operation = DiffFactory.eINSTANCE.createUpdateAttribute();
            operation.setRemote(true);
            operation.setRightElement(mapping.getRightElement());
            operation.setLeftElement(mapping.getLeftElement());
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }

    @Deprecated
    protected final boolean attributeListContains(List<Object> values, Object value) {
        for (Object aValue : values) {
            if (this.areDistinctValues(aValue, value)) continue;
            return true;
        }
        return false;
    }
}

