/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.emf.common.notify.AdapterFactory;

public class RegisteredItemProviderAdapterFactoryDescriptor {
    private static final String DEFAULT_PRIORITY = "5";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private AdapterFactory adapterFactory;
    private int priority;
    private String uri;
    private String name;
    private String id;
    private final IConfigurationElement element;

    public RegisteredItemProviderAdapterFactoryDescriptor(IConfigurationElement e) {
        this.element = e;
        this.adapterFactory = this.getAdapterFactoryFromExtPoint();
        this.priority = this.getPriorityfromExtPoint();
        this.name = this.getNameFromExtPoint();
        this.id = this.getIdFromExtPoint();
    }

    private String getIdFromExtPoint() {
        String value = this.adapterFactory.getClass().getCanonicalName();
        String result = "";
        if (value == null) {
            throw new RuntimeException("Enable to find a correct id for AdapterFactory registered on org.eclipse.emf.compare.itemprovideradapterFactory");
        }
        result = value;
        return result;
    }

    private String getAttribute(String nameEntry, String defaultValue, IConfigurationElement elementEntry) {
        String value = elementEntry.getAttribute(nameEntry);
        String result = "";
        result = value != null ? value : defaultValue;
        return result;
    }

    private String getNameFromExtPoint() {
        String value = this.element.getAttribute(NAME_ATTRIBUTE);
        String result = "";
        if (value == null) {
            throw new RuntimeException("Enable to find a correct name for AdapterFactory registered on org.eclipse.emf.compare.itemprovideradapterFactory");
        }
        result = value;
        return result;
    }

    private AdapterFactory getAdapterFactoryFromExtPoint() {
        Object result;
        try {
            result = this.element.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Object result2 = null;
            throw new RuntimeException("Enable to construct an AdapterFactory from the extension registered on org.eclipse.emf.compare.itemprovideradapterFactory");
        }
        catch (InvalidRegistryObjectException e) {
            Object result3 = null;
            throw new RuntimeException("Enable to construct an AdapterFactory from the extension registered on org.eclipse.emf.compare.itemprovideradapterFactory");
        }
        if (!(result instanceof AdapterFactory)) {
            throw new RuntimeException("The registered class on org.eclipse.emf.compare.itemprovideradapterFactory do not implement AdapterFactory Interface");
        }
        return (AdapterFactory)result;
    }

    private Integer getPriorityfromExtPoint() {
        String priorityS = this.getAttribute(PRIORITY_ATTRIBUTE, DEFAULT_PRIORITY, this.element);
        if (priorityS != null && !"".equals(priorityS)) {
            Integer result;
            try {
                result = Integer.parseInt(priorityS);
            }
            catch (NumberFormatException e) {
                result = new Integer(Integer.parseInt(DEFAULT_PRIORITY));
            }
            return result;
        }
        return new Integer(5);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }
}

