/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class EclipseModelUtils {
    private EclipseModelUtils() {
    }

    public static Monitor createProgressMonitor(Object delegate) {
        Object monitor = delegate instanceof IProgressMonitorWithBlocking ? BasicMonitor.toMonitor((IProgressMonitorWithBlocking)((IProgressMonitorWithBlocking)delegate)) : (delegate instanceof IProgressMonitor ? BasicMonitor.toMonitor((IProgressMonitor)((IProgressMonitor)delegate)) : new BasicMonitor());
        return monitor;
    }

    public static Resource createResource(URI modelURI, String contentType, ResourceSet resourceSet) {
        Resource.Factory.Registry registry = resourceSet.getResourceFactoryRegistry();
        Object resourceFactory = registry.getContentTypeToFactoryMap().get(contentType);
        if (resourceFactory == null && (resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getContentTypeToFactoryMap().get(contentType)) != null) {
            resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put(contentType, resourceFactory);
        }
        return resourceSet.createResource(modelURI, contentType);
    }

    public static String getCommonContentType(URI ... uris) {
        String contentType = null;
        int i = 0;
        while (i < uris.length) {
            if (uris[i] != null && uris[i].isPlatformResource()) {
                Path modelPath = new Path(uris[i].toPlatformString(true));
                String newContentType = null;
                try {
                    IContentDescription contentDescription = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)modelPath).getContentDescription();
                    if (contentDescription != null && contentDescription.getContentType() != null) {
                        newContentType = contentDescription.getContentType().getId();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (contentType == null) {
                    contentType = newContentType;
                } else if (newContentType != null && !contentType.equals(newContentType)) {
                    return null;
                }
            }
            ++i;
        }
        return contentType;
    }

    public static EObject load(IFile file, ResourceSet resourceSet) throws IOException {
        EObject result = null;
        URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
        IContentType contentType = null;
        try {
            if (file.getContentDescription() != null) {
                contentType = file.getContentDescription().getContentType();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Resource modelResource = contentType != null ? EclipseModelUtils.createResource(resourceURI, contentType.getId(), resourceSet) : ModelUtils.createResource(resourceURI, resourceSet);
        try {
            modelResource.load(Collections.emptyMap());
        }
        catch (IOException e) {
            resourceSet.getResources().remove((Object)modelResource);
            modelResource = ModelUtils.createResource(URI.createPlatformPluginURI((String)file.getFullPath().toOSString(), (boolean)true), resourceSet);
            try {
                modelResource.load(Collections.emptyMap());
            }
            catch (IOException ee) {
                throw e;
            }
        }
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static EObject load(IPath path, ResourceSet resourceSet) throws IOException {
        return EclipseModelUtils.load(ResourcesPlugin.getWorkspace().getRoot().getFile(path), resourceSet);
    }

    public static Resource getResource(IFile file, ResourceSet resourceSet) throws IOException {
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().toString().equals(file.getFullPath().toString())) continue;
            return resource;
        }
        return ModelUtils.load(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), resourceSet).eResource();
    }

    public static IResource findIResource(Resource eResource) {
        URI uri = eResource.getURI();
        IResource iResource = null;
        if (uri != null) {
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.trimFragment().toPlatformString(true));
                iResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            } else {
                Path path = new Path(uri.trimFragment().path());
                iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            }
        }
        return iResource;
    }
}

