/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.services;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.group.IDifferenceGroupingFacility;
import org.eclipse.emf.compare.ui.viewer.structure.StructureViewer;
import org.eclipse.emf.compare.ui.views.StructureView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompareServices {
    private CompareServices() {
    }

    public static void setSelection(List<String> objectIds, IEditorPart editor) {
        ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
        if (provider instanceof IInputProvider) {
            ArrayList<EObject> objsToReference = new ArrayList<EObject>();
            Object root = ((IInputProvider)provider).getInput();
            if (root instanceof EObject) {
                for (String id : objectIds) {
                    EObject leftRoot = CompareServices.getElement((EObject)root, IMatchManager.MatchSide.LEFT);
                    EObject obj = CompareServices.getEObject(leftRoot.eResource(), id);
                    if (obj == null) {
                        EObject rightRoot = CompareServices.getElement((EObject)root, IMatchManager.MatchSide.RIGHT);
                        obj = CompareServices.getEObject(rightRoot.eResource(), id);
                    }
                    if (obj == null) continue;
                    objsToReference.add(obj);
                }
            }
            if (objsToReference.size() > 0) {
                EcoreUtil.CrossReferencer crossReferencer = CompareServices.createCrossReferencer((EObject)root);
                editor.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(CompareServices.getDiffsToSelect(objsToReference, crossReferencer)));
            }
        }
    }

    public static void openEditor(CompareEditorInput input, List<String> objectIds) throws InvocationTargetException, InterruptedException, PartInitException {
        CompareServices.openEditor(input);
        CompareServices.initSelection(objectIds, input);
    }

    public static void openEditor(CompareEditorInput input, String objectId) throws InvocationTargetException, InterruptedException, PartInitException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(objectId);
        CompareServices.openEditor(input, ids);
    }

    public static void openView(ComparisonSnapshot input) throws InterruptedException, InvocationTargetException, PartInitException {
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.emf.compare.ui.views.StructureView");
        if (part instanceof StructureView) {
            ((StructureView)part).setInput(input);
            ((StructureView)part).setDifferenceFilters(null);
            ((StructureView)part).setDifferenceGroupingFacility(null);
        }
    }

    public static void openView(ComparisonSnapshot input, List<IDifferenceFilter> filters, IDifferenceGroupingFacility group) throws InterruptedException, InvocationTargetException, PartInitException {
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.emf.compare.ui.views.StructureView");
        if (part instanceof StructureView) {
            ((StructureView)part).setInput(input);
            ((StructureView)part).setDifferenceFilters(filters);
            ((StructureView)part).setDifferenceGroupingFacility(group);
        }
    }

    public static void openView(IEditorPart editor) throws InterruptedException, InvocationTargetException, PartInitException {
        Object root;
        ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
        if (provider instanceof IInputProvider && (root = ((IInputProvider)provider).getInput()) instanceof ComparisonSnapshot) {
            CompareServices.openView((ComparisonSnapshot)root);
        }
    }

    public static void openView(IEditorPart editor, List<IDifferenceFilter> filters, IDifferenceGroupingFacility group) throws InterruptedException, InvocationTargetException, PartInitException {
        Object root;
        ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
        if (provider instanceof IInputProvider && (root = ((IInputProvider)provider).getInput()) instanceof ComparisonSnapshot) {
            CompareServices.openView((ComparisonSnapshot)root, filters, group);
        }
    }

    public static StructureViewer getStructureViewer(Composite parent, ComparisonSnapshot input) {
        StructureViewer viewer = new StructureViewer(parent, new CompareConfiguration());
        viewer.setInput(input);
        return viewer;
    }

    public static StructureViewer getStructureViewer(Composite parent, ComparisonSnapshot input, List<IDifferenceFilter> filters, IDifferenceGroupingFacility groupingFacility) {
        StructureViewer viewer = new StructureViewer(parent, new CompareConfiguration(), filters, groupingFacility);
        viewer.setInput(input);
        return viewer;
    }

    protected static void openEditor(CompareEditorInput input) throws InterruptedException, InvocationTargetException {
        input.run((IProgressMonitor)new NullProgressMonitor());
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    private static EcoreUtil.CrossReferencer createCrossReferencer(EObject comparisonSnapshot) {
        EObject diffRoot = null;
        if (comparisonSnapshot instanceof ComparisonResourceSetSnapshot) {
            diffRoot = CompareServices.getDiffElement(comparisonSnapshot, DiffPackage.Literals.DIFF_RESOURCE_SET);
        } else if (comparisonSnapshot instanceof ComparisonResourceSnapshot) {
            diffRoot = CompareServices.getDiffElement(comparisonSnapshot, DiffPackage.Literals.DIFF_MODEL);
        }
        EcoreUtil.CrossReferencer crossReferencer = new EcoreUtil.CrossReferencer(diffRoot){
            private static final long serialVersionUID = 1L;
            {
                this.crossReference();
            }
        };
        return crossReferencer;
    }

    private static EObject getDiffElement(EObject rootDiff, EClass type) {
        TreeIterator it = rootDiff.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!type.isInstance((Object)obj)) continue;
            return obj;
        }
        return null;
    }

    private static List<DiffElement> getDiffsToSelect(EObject obj, EcoreUtil.CrossReferencer crossReferencer) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        Collection settings = (Collection)crossReferencer.get((Object)obj);
        if (settings != null) {
            for (EStructuralFeature.Setting setting : settings) {
                EObject crossElt = setting.getEObject();
                if (!(crossElt instanceof DiffElement)) continue;
                result.add((DiffElement)crossElt);
            }
        }
        return result;
    }

    private static List<DiffElement> getDiffsToSelect(List<EObject> objs, EcoreUtil.CrossReferencer crossReferencer) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (EObject eObject : objs) {
            List<DiffElement> diffs = CompareServices.getDiffsToSelect(eObject, crossReferencer);
            for (DiffElement diffElement : diffs) {
                if (result.contains(diffElement)) continue;
                result.add(diffElement);
            }
        }
        return result;
    }

    private static EObject getElement(EObject rootDiff, IMatchManager.MatchSide side) {
        EObject result = null;
        TreeIterator it = rootDiff.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof DiffModel)) continue;
            switch (side) {
                case LEFT: {
                    result = (EObject)((DiffModel)obj).getLeftRoots().get(0);
                    break;
                }
                case RIGHT: {
                    result = (EObject)((DiffModel)obj).getRightRoots().get(0);
                    break;
                }
                case ANCESTOR: {
                    result = (EObject)((DiffModel)obj).getAncestorRoots().get(0);
                    break;
                }
            }
        }
        return result;
    }

    private static EObject getEObject(Resource resource, String id) {
        EObject result = null;
        if (resource.getResourceSet() != null) {
            for (Resource res : resource.getResourceSet().getResources()) {
                result = res.getEObject(id);
                if (result == null) {
                    continue;
                }
                break;
            }
        } else {
            result = resource.getEObject(id);
        }
        return result;
    }

    private static void initSelection(List<String> objectIds, CompareEditorInput editorInput) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (page = workbenchWindow.getActivePage()) != null) {
            IEditorReference[] editors;
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                if (editorInput.equals(iEditorReference.getEditorInput())) {
                    IEditorPart editor = iEditorReference.getEditor(true);
                    CompareServices.setSelection(objectIds, editor);
                }
                ++n2;
            }
        }
    }
}

