/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ui.team.AbstractResolvingURIConverter;
import org.eclipse.emf.compare.ui.team.AbstractTeamHandler;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;

public class RevisionComparisonHandler
extends AbstractTeamHandler {
    private boolean leftIsRemote;

    public boolean isLeftRemote() {
        return this.leftIsRemote;
    }

    public boolean loadResources(ICompareInput input) throws IOException, CoreException {
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ITypedElement ancestor = input.getAncestor();
        if (right instanceof FileRevisionTypedElement) {
            IFileRevision rightRevision = ((FileRevisionTypedElement)right).getFileRevision();
            ResourceSetImpl leftResourceSet = new ResourceSetImpl();
            ResourceSetImpl rightResourceSet = new ResourceSetImpl();
            if (left instanceof FileRevisionTypedElement) {
                try {
                    leftResourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(((FileRevisionTypedElement)left).getFileRevision()));
                    this.leftResource = ModelUtils.load((InputStream)((IStreamContentAccessor)left).getContents(), (String)left.getName(), (ResourceSet)leftResourceSet).eResource();
                }
                catch (IOException e) {
                    this.leftResource = ModelUtils.createResource((URI)URI.createURI((String)left.getName()));
                    this.leftIsRemote = true;
                }
            } else if (((ResourceNode)left).getResource().isAccessible()) {
                this.leftResource = EclipseModelUtils.load((IPath)((ResourceNode)left).getResource().getFullPath(), (ResourceSet)leftResourceSet).eResource();
            } else {
                this.leftResource = ModelUtils.createResource((URI)URI.createPlatformResourceURI((String)((ResourceNode)left).getResource().getFullPath().toOSString(), (boolean)true));
                this.leftIsRemote = true;
            }
            try {
                rightResourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(rightRevision));
                this.rightResource = ModelUtils.load((InputStream)((IStreamContentAccessor)right).getContents(), (String)right.getName(), (ResourceSet)rightResourceSet).eResource();
            }
            catch (IOException e) {
                this.rightResource = ModelUtils.createResource((URI)URI.createURI((String)right.getName()));
                this.leftIsRemote = true;
            }
            if (ancestor != null) {
                IFileRevision ancestorRevision = ((FileRevisionTypedElement)ancestor).getFileRevision();
                ResourceSetImpl ancestorResourceSet = new ResourceSetImpl();
                try {
                    ancestorResourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(ancestorRevision));
                    this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)ancestorResourceSet).eResource();
                }
                catch (IOException e) {
                    this.ancestorResource = ModelUtils.createResource((URI)URI.createURI((String)ancestor.getName()));
                }
            }
            return true;
        }
        return false;
    }

    private class RevisionedURIConverter
    extends AbstractResolvingURIConverter {
        private final IFileRevision baseRevision;

        public RevisionedURIConverter(IFileRevision revision) {
            this.baseRevision = revision;
        }

        public URI resolve(URI uri) throws CoreException {
            URI deresolvedURI = uri;
            IStorage storage = this.baseRevision.getStorage(null);
            if (uri.segmentCount() > 0 && uri.isRelative()) {
                if (storage instanceof IFile) {
                    IFile file = (IFile)storage;
                    deresolvedURI = uri.resolve(URI.createURI((String)file.getLocationURI().toString()));
                } else {
                    IResource stateFile = (IResource)storage.getAdapter(IResource.class);
                    if (stateFile == null) {
                        stateFile = (IResource)Platform.getAdapterManager().getAdapter((Object)storage, IResource.class);
                    }
                    if (stateFile == null) {
                        stateFile = EcorePlugin.getWorkspaceRoot().findMember(storage.getFullPath());
                    }
                    if (stateFile != null) {
                        deresolvedURI = uri.resolve(URI.createURI((String)stateFile.getLocationURI().toString()));
                    }
                }
            }
            deresolvedURI = URI.createPlatformResourceURI((String)deresolvedURI.deresolve(URI.createURI((String)(String.valueOf(EcorePlugin.getWorkspaceRoot().getLocationURI().toString()) + '/'))).toString());
            return deresolvedURI;
        }

        public InputStream createInputStream(URI uri) throws IOException {
            InputStream stream = null;
            URI normalizedUri = this.normalize(uri);
            if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
                stream = super.createInputStream(normalizedUri);
            } else {
                IResource targetFile = EcorePlugin.getWorkspaceRoot().findMember((IPath)new Path(normalizedUri.trimFragment().toPlatformString(true)));
                if (targetFile != null) {
                    stream = this.openRevisionStream(targetFile);
                } else {
                    super.createInputStream(normalizedUri);
                }
            }
            return stream;
        }

        private InputStream openRevisionStream(IResource target) {
            IProject project = target.getProject();
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            try {
                IFileHistoryProvider historyProvider;
                IFileHistory history;
                InputStream stream = null;
                if (provider != null && (history = (historyProvider = provider.getFileHistoryProvider()).getFileHistoryFor(target, 0, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    IFileRevision soughtRevision = null;
                    IFileRevision[] iFileRevisionArray = history.getFileRevisions();
                    int n = iFileRevisionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileRevision revision = iFileRevisionArray[n2];
                        if (revision.getTimestamp() <= this.baseRevision.getTimestamp()) {
                            soughtRevision = revision;
                            break;
                        }
                        ++n2;
                    }
                    if (soughtRevision != null) {
                        stream = soughtRevision.getStorage((IProgressMonitor)new NullProgressMonitor()).getContents();
                    }
                }
                if (stream == null) {
                    IFileState soughtState = null;
                    IFileState[] iFileStateArray = ((IFile)target).getHistory((IProgressMonitor)new NullProgressMonitor());
                    int n = iFileStateArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IFileState state = iFileStateArray[n3];
                        if (state.getModificationTime() <= this.baseRevision.getTimestamp()) {
                            soughtState = state;
                            break;
                        }
                        ++n3;
                    }
                    stream = soughtState != null ? soughtState.getContents() : ((IFile)target).getContents();
                }
                return stream;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
    }
}

