/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.logical.RevisionedURIConverter;
import org.eclipse.emf.compare.logical.extension.EMFCompareExtensionRegistry;
import org.eclipse.emf.compare.logical.extension.ModelResolverDescriptor;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelIdentifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFResourceMapping
extends ResourceMapping {
    public static final String REMOTE_RESOURCE_SCHEME = "remote";
    private final IFile file;
    private final Resource emfResource;
    private ResourceSet localResourceSet;
    private ResourceSet remoteResourceSet;
    private ResourceSet ancestorResourceSet;
    private final String providerId;
    private Set<IResource> iResourcesInScope;
    private boolean isResolved;

    public EMFResourceMapping(IFile file, Resource emfResource, String providerId) {
        this.file = file;
        this.emfResource = emfResource;
        this.providerId = providerId;
        this.localResourceSet = emfResource.getResourceSet();
    }

    public Object getModelObject() {
        return this.emfResource;
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public IProject[] getProjects() {
        Set<IResource> physicalResources = this.resolvePhysicalResources();
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>(physicalResources.size());
        for (IResource iResource : physicalResources) {
            projects.add(iResource.getProject());
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (!this.isResolved) {
            this.resolveLocalResourceSet();
            if (context instanceof RemoteResourceMappingContext) {
                RemoteResourceMappingContext remoteContext = (RemoteResourceMappingContext)context;
                for (Resource eResource : this.localResourceSet.getResources()) {
                    RevisionedURIConverter converter;
                    IFile localFile = eResource == this.emfResource ? this.file : (IFile)EclipseModelUtils.findIResource((Resource)eResource);
                    IStorage remoteContents = remoteContext.fetchRemoteContents(localFile, monitor);
                    IStorage ancestorContents = remoteContext.fetchBaseContents(localFile, monitor);
                    if (remoteContents != null) {
                        if (this.remoteResourceSet == null) {
                            this.remoteResourceSet = EMFResourceMapping.createRemoteResourceSet((IResource)localFile, remoteContents);
                        } else {
                            converter = (RevisionedURIConverter)this.remoteResourceSet.getURIConverter();
                            converter.setStorage(remoteContents);
                        }
                        EMFResourceMapping.loadRemoteResource(eResource.getURI(), remoteContents, this.remoteResourceSet);
                    }
                    if (ancestorContents == null) continue;
                    if (this.ancestorResourceSet == null) {
                        this.ancestorResourceSet = EMFResourceMapping.createRemoteResourceSet((IResource)localFile, ancestorContents);
                    } else {
                        converter = (RevisionedURIConverter)this.ancestorResourceSet.getURIConverter();
                        converter.setStorage(ancestorContents);
                    }
                    EMFResourceMapping.loadRemoteResource(eResource.getURI(), ancestorContents, this.ancestorResourceSet);
                }
                if (this.remoteResourceSet != null) {
                    EcoreUtil.resolveAll((ResourceSet)this.remoteResourceSet);
                }
                if (this.ancestorResourceSet != null) {
                    EcoreUtil.resolveAll((ResourceSet)this.ancestorResourceSet);
                }
            }
            this.resolvePhysicalResources();
            this.isResolved = true;
        }
        ResourceTraversal traversal = new ResourceTraversal(this.iResourcesInScope.toArray(new IResource[this.iResourcesInScope.size()]), 1, 0);
        return new ResourceTraversal[]{traversal};
    }

    public void forceResolving(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        this.isResolved = false;
        this.remoteResourceSet = null;
        this.ancestorResourceSet = null;
        this.iResourcesInScope = null;
        this.getTraversals(context, monitor);
    }

    public ResourceSet getLocalResourceSet() {
        return this.localResourceSet;
    }

    public ResourceSet getRemoteResourceSet() {
        return this.remoteResourceSet;
    }

    public ResourceSet getAncestorResourceSet() {
        return this.ancestorResourceSet;
    }

    public Set<IResource> resolvePhysicalResources() {
        IResource iResource;
        if (this.iResourcesInScope != null) {
            return this.iResourcesInScope;
        }
        this.iResourcesInScope = new LinkedHashSet<IResource>();
        for (Resource eResource : this.localResourceSet.getResources()) {
            if (eResource == this.emfResource) {
                this.iResourcesInScope.add((IResource)this.file);
                continue;
            }
            iResource = EclipseModelUtils.findIResource((Resource)eResource);
            if (iResource == null) continue;
            this.iResourcesInScope.add(iResource);
        }
        if (this.remoteResourceSet != null) {
            for (Resource eResource : this.remoteResourceSet.getResources()) {
                iResource = EclipseModelUtils.findIResource((Resource)eResource);
                if (iResource == null) continue;
                this.iResourcesInScope.add(iResource);
            }
        }
        if (this.ancestorResourceSet != null) {
            for (Resource eResource : this.ancestorResourceSet.getResources()) {
                iResource = EclipseModelUtils.findIResource((Resource)eResource);
                if (iResource == null) continue;
                this.iResourcesInScope.add(iResource);
            }
        }
        return this.iResourcesInScope;
    }

    private void resolveLocalResourceSet() {
        Iterator<ModelResolverDescriptor> modelResolverIterator = EMFCompareExtensionRegistry.getRegisteredModelResolvers().iterator();
        boolean resolved = false;
        while (!resolved && modelResolverIterator.hasNext()) {
            ModelResolverDescriptor descriptor = modelResolverIterator.next();
            if (!descriptor.canResolve(new ModelIdentifier(new Resource[]{this.emfResource}))) continue;
            descriptor.getModelResolver().resolve(this.file, this.emfResource);
            resolved = true;
        }
        if (!resolved) {
            EcoreUtil.resolveAll((ResourceSet)this.localResourceSet);
        }
    }

    private static void loadRemoteResource(URI resourceURI, IStorage storage, ResourceSet resourceSet) throws CoreException {
        block13: {
            String resourcePath = resourceURI.path();
            if (resourceURI.isPlatform()) {
                resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
            }
            URI actualURI = URI.createURI((String)("remote:/" + resourcePath));
            Resource resource = resourceSet.createResource(actualURI);
            InputStream remoteStream = null;
            try {
                try {
                    remoteStream = storage.getContents();
                    resource.load(remoteStream, Collections.emptyMap());
                }
                catch (IOException iOException) {
                    if (remoteStream == null) break block13;
                    try {
                        remoteStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (remoteStream != null) {
                    try {
                        remoteStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static ResourceSet createRemoteResourceSet(IResource baseResource, IStorage storage) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(resourceSet.getURIConverter(), storage));
        return resourceSet;
    }
}

