/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.synchronization;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.logical.model.EMFModelProvider;
import org.eclipse.emf.compare.logical.model.EMFResourceMapping;
import org.eclipse.emf.compare.logical.synchronization.EMFDelta;
import org.eclipse.emf.compare.logical.synchronization.EMFResourceDelta;
import org.eclipse.emf.compare.match.engine.GenericMatchScopeProvider;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public class EMFModelDelta
extends EMFDelta {
    private String modelProviderId;
    private ISynchronizationContext context;
    private ResourceSet localResourceSet;
    private ResourceSet remoteResourceSet;
    private ResourceSet ancestorResourceSet;
    private ComparisonSnapshot comparisonSnapshot;

    private EMFModelDelta(ISynchronizationContext context, String modelProviderId) {
        super(null);
        this.modelProviderId = modelProviderId;
        this.context = context;
    }

    public static EMFModelDelta createDelta(ISynchronizationContext context, String modelProviderId, IProgressMonitor monitor) throws CoreException {
        EMFModelDelta delta = new EMFModelDelta(context, modelProviderId);
        delta.initialize(monitor);
        context.getCache().put("org.eclipse.emf.compare.model.provider.sync.cache", (Object)delta);
        return delta;
    }

    public static EMFModelDelta getDelta(ISynchronizationContext context) {
        return (EMFModelDelta)context.getCache().get("org.eclipse.emf.compare.model.provider.sync.cache");
    }

    public void clear() {
        this.localResourceSet = null;
        this.remoteResourceSet = null;
        this.ancestorResourceSet = null;
        this.comparisonSnapshot = null;
        super.clear();
    }

    public Object getAncestor() {
        return this.ancestorResourceSet;
    }

    public Object getLocal() {
        return this.localResourceSet;
    }

    public Object getRemote() {
        return this.remoteResourceSet;
    }

    public IDiff getDiff() {
        return null;
    }

    public IPath getPath() {
        return Path.EMPTY;
    }

    public ComparisonSnapshot getComparisonSnapshot() {
        return this.comparisonSnapshot;
    }

    protected void createChildren() {
        IResourceDiffTree diffTree = this.context.getDiffTree();
        if (this.comparisonSnapshot instanceof ComparisonResourceSetSnapshot) {
            ComparisonResourceSetSnapshot resourceSetSnapshot = (ComparisonResourceSetSnapshot)this.comparisonSnapshot;
            for (DiffModel diffModel : resourceSetSnapshot.getDiffResourceSet().getDiffModels()) {
                if (diffModel.getSubchanges() <= 0) continue;
                Resource local = null;
                Resource remote = null;
                Resource ancestor = null;
                Iterator leftRootsIterator = diffModel.getLeftRoots().iterator();
                while (local == null && leftRootsIterator.hasNext()) {
                    EObject leftRoot = (EObject)leftRootsIterator.next();
                    local = leftRoot.eResource();
                }
                Iterator rightRootsIterator = diffModel.getRightRoots().iterator();
                while (remote == null && rightRootsIterator.hasNext()) {
                    EObject rightRoot = (EObject)rightRootsIterator.next();
                    remote = rightRoot.eResource();
                }
                Iterator ancestorRootsIterator = diffModel.getAncestorRoots().iterator();
                while (ancestor == null && ancestorRootsIterator.hasNext()) {
                    EObject ancestorRoot = (EObject)ancestorRootsIterator.next();
                    ancestor = ancestorRoot.eResource();
                }
                IResource localResource = EclipseModelUtils.findIResource((Resource)local);
                if (localResource == null) continue;
                IDiff diff = diffTree.getDiff(localResource.getFullPath());
                new EMFResourceDelta(this, diffModel, diff, local, remote, ancestor);
            }
        }
    }

    private void initialize(IProgressMonitor monitor) throws CoreException {
        this.clear();
        ResourceMapping[] mappings = EMFModelProvider.getAdditionalMappings(this.context);
        if (mappings == null) {
            mappings = this.context.getScope().getMappings();
        }
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (this.modelProviderId.equals(mapping.getModelProviderId()) && mapping instanceof EMFResourceMapping) {
                EMFResourceMapping emfMapping = (EMFResourceMapping)mapping;
                ResourceSet local = emfMapping.getLocalResourceSet();
                ResourceSet remote = emfMapping.getRemoteResourceSet();
                ResourceSet ancestor = emfMapping.getAncestorResourceSet();
                if (local != null && remote != null && ancestor != null && (this.localResourceSet == null || this.localResourceSet.getResources().size() < local.getResources().size())) {
                    this.localResourceSet = local;
                    this.remoteResourceSet = remote;
                    this.ancestorResourceSet = ancestor;
                }
            }
            ++n2;
        }
        if (this.localResourceSet == null) {
            EMFResourceMapping emfMapping = null;
            int i = 0;
            while (i < mappings.length && emfMapping == null) {
                ResourceMapping mapping = mappings[i];
                if (this.modelProviderId.equals(mapping.getModelProviderId()) && mapping instanceof EMFResourceMapping) {
                    emfMapping = (EMFResourceMapping)mapping;
                }
                ++i;
            }
            if (emfMapping != null) {
                emfMapping.forceResolving(this.context.getScope().getContext(), monitor);
                this.localResourceSet = emfMapping.getLocalResourceSet();
                this.remoteResourceSet = emfMapping.getRemoteResourceSet();
                this.ancestorResourceSet = emfMapping.getAncestorResourceSet();
            }
        }
        this.comparisonSnapshot = this.compare(this.localResourceSet, this.remoteResourceSet, this.ancestorResourceSet, monitor);
        this.createChildren();
    }

    private ComparisonSnapshot compare(ResourceSet local, ResourceSet remote, ResourceSet ancestor, IProgressMonitor monitor) {
        if (local != null) {
            // empty if block
        }
        ComparisonSnapshot comparisonResult = this.doResourceSetCompare(local, remote, ancestor, monitor);
        comparisonResult.setDate(Calendar.getInstance().getTime());
        return comparisonResult;
    }

    private ComparisonSnapshot doResourceSetCompare(ResourceSet local, ResourceSet remote, ResourceSet ancestor, IProgressMonitor monitor) {
        ComparisonResourceSetSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSetSnapshot();
        snapshot.setDiffResourceSet(DiffFactory.eINSTANCE.createDiffResourceSet());
        snapshot.setMatchResourceSet(MatchFactory.eINSTANCE.createMatchResourceSet());
        try {
            MatchResourceSet match;
            EMFCompareMap options = new EMFCompareMap();
            options.put("match.progress.monitor", monitor);
            if (ancestor == null) {
                options.put("match.scope.provider", new GenericMatchScopeProvider(local, remote));
                match = MatchService.doResourceSetMatch((ResourceSet)local, (ResourceSet)remote, (Map)options);
            } else {
                options.put("match.scope.provider", new GenericMatchScopeProvider(local, remote, ancestor));
                match = MatchService.doResourceSetMatch((ResourceSet)local, (ResourceSet)remote, (ResourceSet)ancestor, (Map)options);
            }
            DiffResourceSet diff = DiffService.doDiff((MatchResourceSet)match, (ancestor != null ? 1 : 0) != 0);
            snapshot.setDiffResourceSet(diff);
            snapshot.setMatchResourceSet(match);
        }
        catch (InterruptedException e) {
            EMFComparePlugin.log((Exception)e, (boolean)false);
        }
        catch (EMFCompareException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        return snapshot;
    }
}

