/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.model;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.compare.logical.model.EMFResourceMapping;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public class EMFModelProvider
extends ModelProvider {
    public static final String PROVIDER_ID = "org.eclipse.emf.compare.model.provider";
    public static final String SYNCHRONIZATION_CACHE_KEY = "org.eclipse.emf.compare.model.provider.sync.cache";
    private static final String EMF_ADDITIONAL_MAPPINGS = "org.eclipse.emf.compare.model.provider.additional.mappings";

    public static void cacheAdditionalMappings(ISynchronizationContext context, ResourceMapping[] additionalMappings) {
        context.getCache().put(EMF_ADDITIONAL_MAPPINGS, (Object)additionalMappings);
    }

    public static ResourceMapping[] getAdditionalMappings(ISynchronizationContext context) {
        return (ResourceMapping[])context.getCache().get(EMF_ADDITIONAL_MAPPINGS);
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (resource instanceof IFile && resource.exists() && resource.isAccessible()) {
            return this.getMappings((IFile)resource, monitor);
        }
        return super.getMappings(resource, context, monitor);
    }

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        return super.validateChange(delta, monitor);
    }

    private ResourceMapping[] getMappings(IFile file, IProgressMonitor monitor) {
        ArrayList<EMFResourceMapping> mappings = new ArrayList<EMFResourceMapping>();
        try {
            Resource resource = EclipseModelUtils.getResource((IFile)file, (ResourceSet)this.createLogicalModelResourceSet());
            if (resource != null) {
                mappings.add(new EMFResourceMapping(file, resource, PROVIDER_ID));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    private ResourceSet createLogicalModelResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet;
    }
}

