/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.Emfdiff2mpatchActivator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.WizardLauncher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CompareAndTransformAction
implements IObjectActionDelegate {
    private static final String DEFAULT_FILE_NAME = "result.mpatch";
    private IFile oldFile;
    private IFile newFile;
    private Shell shell;

    public void run(IAction action) {
        ComparisonSnapshot emfdiff;
        if (this.oldFile != null && this.newFile != null && (emfdiff = CompareAndTransformAction.createComparisonSnapshot(this.oldFile, this.newFile, this.shell)) != null) {
            IFile mPatchFile = CommonUtils.createNewIFile((IFile)this.newFile, (String)DEFAULT_FILE_NAME);
            WizardLauncher.openWizard(emfdiff, mPatchFile);
        }
    }

    private static ComparisonSnapshot createComparisonSnapshot(IFile oldFile, IFile newFile, Shell shell) {
        int dialogResult;
        Resource newResource;
        Resource oldResource;
        ComparisonResourceSnapshot emfdiff;
        block6: {
            emfdiff = null;
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                oldResource = resourceSet.getResource(URI.createFileURI((String)oldFile.getFullPath().toString()), true);
                newResource = resourceSet.getResource(URI.createFileURI((String)newFile.getFullPath().toString()), true);
                if (oldResource.getContents().size() != 1) {
                    throw new IllegalArgumentException(oldFile.getFullPath() + " is expected to contain exactly one root model element, but " + oldResource.getContents().size() + " elements found!");
                }
                if (newResource.getContents().size() != 1) {
                    throw new IllegalArgumentException(newFile.getFullPath() + " is expected to contain exactly one root model element, but " + newResource.getContents().size() + " elements found!");
                }
                MessageDialog dialog = new MessageDialog(shell, "Please select the modified model", Dialog.getImage((String)"dialog_question_image"), "Please select the file which contains the MODIFIED version:", 3, new String[]{newFile.getName(), oldFile.getName()}, 0);
                dialogResult = dialog.open();
                if (dialogResult != -1) break block6;
                return null;
            }
            catch (Exception e) {
                String message = "Could not create differences with EMF Compare.";
                Emfdiff2mpatchActivator.getDefault().logError("Could not create differences with EMF Compare.", e);
                MessageDialog.openError((Shell)shell, (String)"Could not create differences with EMF Compare!", (String)("Could not create differences with EMF Compare. See error log for details.\nError message: " + e.getMessage()));
                return null;
            }
        }
        EObject oldModel = (EObject)(dialogResult == 0 ? oldResource : newResource).getContents().get(0);
        EObject newModel = (EObject)(dialogResult == 0 ? newResource : oldResource).getContents().get(0);
        emfdiff = CommonUtils.createEmfdiff((EObject)newModel, (EObject)oldModel);
        if (emfdiff != null) {
            return emfdiff;
        }
        throw new IllegalArgumentException("EMF Compare failed to compute differences.");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object[] files;
        IStructuredSelection structuredSelection;
        this.oldFile = null;
        this.newFile = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 2 && (files = structuredSelection.toArray())[0] instanceof IFile && files[1] instanceof IFile) {
            this.newFile = (IFile)files[0];
            this.oldFile = (IFile)files[1];
        }
        action.setEnabled(this.oldFile != null && this.newFile != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

