/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.ChangeKind;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPatchUtil {
    public static String toSummaryString(Map<ChangeKind, List<IndepChange>> changeMap) {
        String label = "";
        for (ChangeKind kind : MPatchUtil.sortChangeKinds(changeMap.keySet())) {
            label = String.valueOf(label) + (label.length() == 0 ? "" : ", ") + changeMap.get((Object)kind).size() + " " + kind.name().toLowerCase() + (changeMap.get((Object)kind).size() == 1 ? "" : "s");
        }
        return label.length() == 0 ? "(empty)" : "(" + label + ")";
    }

    private static List<ChangeKind> sortChangeKinds(Collection<ChangeKind> changeKinds) {
        ArrayList<ChangeKind> result = new ArrayList<ChangeKind>(8);
        if (changeKinds.contains((Object)ChangeKind.GROUP)) {
            result.add(ChangeKind.GROUP);
        }
        if (changeKinds.contains((Object)ChangeKind.ADDITION)) {
            result.add(ChangeKind.ADDITION);
        }
        if (changeKinds.contains((Object)ChangeKind.DELETION)) {
            result.add(ChangeKind.DELETION);
        }
        if (changeKinds.contains((Object)ChangeKind.MOVE)) {
            result.add(ChangeKind.MOVE);
        }
        if (changeKinds.contains((Object)ChangeKind.CHANGE)) {
            result.add(ChangeKind.CHANGE);
        }
        if (changeKinds.contains((Object)ChangeKind.UNKNOWN)) {
            result.add(ChangeKind.UNKNOWN);
        }
        if (changeKinds.size() > result.size()) {
            throw new UnsupportedOperationException("Unknown change kind detected! Please implement it: " + changeKinds.removeAll(result));
        }
        return result;
    }

    public static Map<ChangeKind, List<IndepChange>> collectChanges(List<IndepChange> changes) {
        HashMap<ChangeKind, List<IndepChange>> map = new HashMap<ChangeKind, List<IndepChange>>();
        for (IndepChange subChange : changes) {
            MPatchUtil.addChangeToMap(map, subChange);
            if (!(subChange instanceof ChangeGroup)) continue;
            MPatchUtil.mergeChangeMaps(map, MPatchUtil.collectChanges(subChange));
        }
        return map;
    }

    public static Map<ChangeKind, List<IndepChange>> collectChanges(IndepChange change) {
        if (change instanceof ChangeGroup) {
            return MPatchUtil.collectChanges(((ChangeGroup)change).getSubChanges());
        }
        HashMap<ChangeKind, List<IndepChange>> map = new HashMap<ChangeKind, List<IndepChange>>();
        MPatchUtil.addChangeToMap(map, change);
        return map;
    }

    private static void mergeChangeMaps(Map<ChangeKind, List<IndepChange>> map1, Map<ChangeKind, List<IndepChange>> map2) {
        for (List<IndepChange> list : map2.values()) {
            for (IndepChange change : list) {
                MPatchUtil.addChangeToMap(map1, change);
            }
        }
    }

    public static void addChangeToMap(Map<ChangeKind, List<IndepChange>> map, IndepChange change) {
        List<IndepChange> list = map.get((Object)change.getChangeKind());
        if (list == null) {
            list = new ArrayList<IndepChange>();
            map.put(change.getChangeKind(), list);
        }
        list.add(change);
    }

    public static <T, S> void addElementToSetMap(T key, S element, Map<T, Set<S>> map) {
        Set<S> set = map.get(key);
        if (set == null) {
            set = new HashSet<S>();
            map.put(key, set);
        }
        set.add(element);
    }

    public static <T, S> void addElementToListMap(T key, S element, Map<T, List<S>> map) {
        List<S> set = map.get(key);
        if (set == null) {
            set = new ArrayList<S>();
            map.put(key, set);
        }
        set.add(element);
    }

    public static String formatValue(Object obj) {
        if (obj == null) {
            return "null";
        }
        String value = obj.toString();
        return MPatchUtil.shorten(value, 10);
    }

    public static String formatSymrefLabel(IElementReference symref) {
        if (symref == null) {
            return "<null>";
        }
        String label = symref.getLabel();
        if (label == null || label.length() == 0) {
            label = symref.getUriReference();
            if (label == null || label.length() == 0) {
                label = "<unknown>";
            } else {
                label = label.substring(label.lastIndexOf("#") + 1);
                label = label.substring(label.lastIndexOf("/") + 1);
            }
        }
        if (symref.getType() != null) {
            String type = "<" + symref.getType().getName() + ">";
            String shortLabel = MPatchUtil.shorten(label, 40);
            label = shortLabel.contains(type) || shortLabel.replaceAll(" ", "").contains(type) ? shortLabel : String.valueOf(MPatchUtil.shorten(label, 30)) + " " + type;
        } else {
            label = MPatchUtil.shorten(label, 35);
        }
        return "[" + label + "]";
    }

    public static String getTextForSymref(IElementReference symref) {
        EStructuralFeature containment = symref.eContainingFeature();
        String prefix = MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT.equals(containment) ? "target" : (MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__NEW_PARENT.equals(containment) ? "new parent" : (MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE__OLD_PARENT.equals(containment) ? "old parent" : (MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE__SUB_MODEL_REFERENCE.equals(containment) ? "existing element" : (MPatchPackage.Literals.INDEP_ADD_REM_REFERENCE_CHANGE__CHANGED_REFERENCE.equals(containment) ? "changed reference" : (MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__OLD_REFERENCE.equals(containment) ? "old reference" : (MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE__NEW_REFERENCE.equals(containment) ? "new reference" : (containment != null && "value".equals(containment.getName()) ? "cross reference" : (containment == null ? "<no owner>" : containment.getName()))))))));
        int lower = symref.getLowerBound();
        int upper = symref.getUpperBound();
        String bounds = "[" + lower + (lower != upper ? ".." + (upper < 0 ? "*" : Integer.valueOf(upper)) : "") + "]";
        return String.valueOf(prefix) + " " + bounds;
    }

    private static String shorten(String string, int limit) {
        if (string.length() > limit) {
            return String.valueOf(string.substring(0, limit - 2)) + "...";
        }
        return string;
    }

    public static Map<IElementReference, IndepChange> collectCrossReferences(List<? extends IndepChange> changes) {
        LinkedHashMap<IElementReference, IndepChange> result = new LinkedHashMap<IElementReference, IndepChange>();
        HashSet<EClass> types = new HashSet<EClass>();
        types.add(MPatchPackage.eINSTANCE.getIndepAddRemElementChange());
        types.add(MPatchPackage.eINSTANCE.getIndepMoveElementChange());
        types.add(MPatchPackage.eINSTANCE.getIndepAddRemReferenceChange());
        types.add(MPatchPackage.eINSTANCE.getIndepUpdateReferenceChange());
        List<EObject> crossReferenceOwners = ExtEcoreUtils.collectTypedElements(changes, types, true);
        for (EObject obj : crossReferenceOwners) {
            IndepChange change;
            if (obj instanceof IndepAddRemElementChange) {
                change = (IndepAddRemElementChange)obj;
                for (IElementReference ref : change.getSubModel().getAllCrossReferences()) {
                    result.put(ref, change);
                }
                continue;
            }
            if (obj instanceof IndepMoveElementChange) {
                change = (IndepMoveElementChange)obj;
                result.put(change.getOldParent(), change);
                result.put(change.getNewParent(), change);
                continue;
            }
            if (obj instanceof IndepAddRemReferenceChange) {
                change = (IndepAddRemReferenceChange)obj;
                result.put(change.getChangedReference(), change);
                continue;
            }
            if (!(obj instanceof IndepUpdateReferenceChange)) continue;
            change = (IndepUpdateReferenceChange)obj;
            if (change.getNewReference() != null) {
                result.put(change.getNewReference(), change);
            }
            if (change.getOldReference() == null) continue;
            result.put(change.getOldReference(), change);
        }
        return result;
    }

    public static Map<String, IModelDescriptor> collectDescriptors(List<? extends IndepChange> changes) {
        HashMap<String, IModelDescriptor> result = new HashMap<String, IModelDescriptor>();
        Set<EClass> types = Collections.singleton(MPatchPackage.eINSTANCE.getIModelDescriptor());
        List<EObject> descriptors = ExtEcoreUtils.collectTypedElements(changes, types, true);
        for (EObject object : descriptors) {
            IModelDescriptor descriptor = (IModelDescriptor)object;
            result.put(descriptor.getSelfReference().getUriReference(), descriptor);
        }
        return result;
    }

    public static IndepChange getChangeFor(IElementReference ref) {
        IElementReference parent = ref;
        while (!(parent instanceof IndepChange) && parent != null) {
            parent = parent.eContainer();
        }
        return parent instanceof IndepChange ? (IndepChange)((Object)parent) : null;
    }

    public static boolean isRelevantFeature(EStructuralFeature feature) {
        if (EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE.equals(feature) || EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES.equals(feature)) {
            return false;
        }
        return !feature.isTransient() && !feature.isDerived() && feature.isChangeable();
    }

    public static List<DiffElement> removeDiffElementOfType(DiffModel diff, Set<EClass> diffTypes) {
        ArrayList<DiffElement> removed = new ArrayList<DiffElement>();
        if (diffTypes.contains(DiffPackage.Literals.DIFF_GROUP)) {
            throw new IllegalArgumentException("DiffGroups are not supported! This would erase all differences!");
        }
        List<EObject> diffElementsToRemove = ExtEcoreUtils.collectTypedElements((List<? extends EObject>)diff.getDifferences(), diffTypes, true);
        for (EObject obj : diffElementsToRemove) {
            EObject parent = obj.eContainer();
            EcoreUtil.remove((EObject)obj);
            removed.add((DiffElement)obj);
            while (parent instanceof DiffElement && ((DiffElement)parent).getSubDiffElements().isEmpty()) {
                EObject newParent = parent.eContainer();
                EcoreUtil.remove((EObject)parent);
                parent = newParent;
            }
        }
        return removed;
    }
}

