/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateModelElement;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.metamodel.util.DiffSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffUtil {
    private DiffUtil() {
    }

    public static boolean isVisible(View view) {
        View container;
        boolean result = view.isVisible();
        if (result && (container = DiffUtil.getNextParent((EObject)view)) != null) {
            result = DiffUtil.isVisible(container);
        }
        return result;
    }

    private static View getNextParent(EObject obj) {
        View result = null;
        if (obj != null) {
            EObject parent = obj.eContainer();
            result = parent instanceof View ? (View)parent : DiffUtil.getNextParent(parent);
        }
        return result;
    }

    public static ITextAwareEditPart getTextEditPart(View view) {
        LabelRequestor labelRequestor = new LabelRequestor(view);
        Display.getDefault().syncExec((Runnable)labelRequestor);
        return labelRequestor.getTextEditPart();
    }

    public static String getLabel(View view) {
        LabelRequestor labelRequestor = new LabelRequestor(view);
        Display.getDefault().syncExec((Runnable)labelRequestor);
        return labelRequestor.getLabel();
    }

    public static IParser getParser(View view) {
        ParserRequestor parserRequestor = new ParserRequestor(view);
        Display.getDefault().syncExec((Runnable)parserRequestor);
        return parserRequestor.getParser();
    }

    public static void setLabel(View view, String label) {
        LabelSetter labelSetter = new LabelSetter(view, label);
        Display.getDefault().syncExec((Runnable)labelSetter);
    }

    private static ITextAwareEditPart findTextAwareEditPart(IGraphicalEditPart parent) {
        ITextAwareEditPart result = null;
        if (parent instanceof ITextAwareEditPart) {
            result = (ITextAwareEditPart)parent;
        } else {
            EditPart primaryChildEditPart = parent.getPrimaryChildEditPart();
            if (primaryChildEditPart instanceof ITextAwareEditPart) {
                return (ITextAwareEditPart)primaryChildEditPart;
            }
            for (Object obj : parent.getChildren()) {
                if (!(obj instanceof ITextAwareEditPart)) continue;
                result = (ITextAwareEditPart)obj;
                break;
            }
        }
        return result;
    }

    public static <T> T eContainer(EObject obj, Class<T> clazz) {
        EObject result = null;
        if (obj != null) {
            if (clazz.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            result = obj.eContainer() != null && clazz.isAssignableFrom(obj.eContainer().getClass()) ? obj.eContainer() : (EObject)DiffUtil.eContainer(obj.eContainer(), clazz);
        }
        return (T)result;
    }

    public static <T> boolean containsAnInstanceFor(DiffGroup root, EObject elementToCompare, Class<T> clazz) {
        if (elementToCompare != null) {
            TreeIterator it = root.eAllContents();
            while (it.hasNext()) {
                DiffElement diff;
                EObject obj = (EObject)it.next();
                if (!(obj instanceof DiffElement) || !elementToCompare.equals(DiffUtil.getElement(diff = (DiffElement)obj, Side.ANY, Edge.class)) || !clazz.isInstance(diff)) continue;
                return true;
            }
        }
        return false;
    }

    public static EObject getProperty(DiffElement diff, Side side) {
        ElementRequestor eltRequest = new ElementRequestor(side);
        return (EObject)eltRequest.doSwitch((EObject)diff);
    }

    public static <T> T getElement(DiffElement diff, Side side, Class<T> clazz) {
        return DiffUtil.eContainer(DiffUtil.getProperty(diff, side), clazz);
    }

    public static List<ModelElementChange> getDiffs(ModelElementChange theDiff, EcoreUtil.CrossReferencer crossReferencer) {
        ArrayList<ModelElementChange> diffs = new ArrayList<ModelElementChange>();
        ModelElementChange semanticDiff = DiffUtil.getSemanticDiff((EObject)theDiff, ModelElementChange.class, crossReferencer);
        if (semanticDiff != null) {
            diffs.add(semanticDiff);
        }
        diffs.add(theDiff);
        return diffs;
    }

    public static List<ModelElementChange> getDiffs(ModelElementChange theDiff) {
        ModelElementChange semanticDiff;
        ArrayList<ModelElementChange> diffs = new ArrayList<ModelElementChange>();
        if (theDiff instanceof DiagramModelElementChange && (semanticDiff = ((DiagramModelElementChange)theDiff).getSemanticDiff()) != null) {
            diffs.add(semanticDiff);
        }
        diffs.add(theDiff);
        return diffs;
    }

    public static <T> T getSemanticDiff(EObject notationalDiff, Class<T> type, EcoreUtil.CrossReferencer crossReferencer) {
        if (notationalDiff instanceof DiffElement) {
            Collection diffs;
            View notationalElement = DiffUtil.getElement((DiffElement)notationalDiff, Side.ANY, View.class);
            EObject semanticElement = notationalElement.getElement();
            if (crossReferencer != null && (diffs = (Collection)crossReferencer.get((Object)semanticElement)) != null) {
                for (EStructuralFeature.Setting setting : diffs) {
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (eStructuralFeature != DiffPackage.eINSTANCE.getModelElementChangeLeftTarget_LeftElement() && eStructuralFeature != DiffPackage.eINSTANCE.getModelElementChangeRightTarget_RightElement() || !type.isInstance(setting.getEObject())) continue;
                    return (T)setting.getEObject();
                }
            }
        }
        return null;
    }

    public static List<DiffElement> getSubDiffElements(DiffElement diffElt) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diff : diffElt.getSubDiffElements()) {
            if (diff instanceof ConflictingDiffElement) {
                result.addAll(DiffUtil.getSubDiffElements(diff));
                continue;
            }
            result.add(diff);
        }
        return result;
    }

    public static boolean isRemote(List<DiffElement> hiddenDiffs) {
        for (DiffElement diffElt : hiddenDiffs) {
            if (diffElt.isRemote()) continue;
            return false;
        }
        return true;
    }

    public static abstract class AbstractLabelHandling
    implements Runnable {
        protected View view;
        protected String label = "";
        protected ITextAwareEditPart mTextEp;

        public AbstractLabelHandling(View pView) {
            this.view = pView;
        }

        public AbstractLabelHandling(View pView, String pLabel) {
            this.view = pView;
            this.label = pLabel;
        }

        public void run() {
            Diagram diagram = this.view.getDiagram();
            ResourceSet resourceSet = diagram.eResource().getResourceSet();
            TransactionalEditingDomain ted = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
            DiagramEditPart diagEp = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, new Shell());
            if (diagEp != null) {
                Object viewEp = diagEp.getViewer().getEditPartRegistry().get(this.view);
                if (viewEp != null && viewEp instanceof IGraphicalEditPart) {
                    ITextAwareEditPart textEp = DiffUtil.findTextAwareEditPart((IGraphicalEditPart)viewEp);
                    if (textEp != null) {
                        this.mTextEp = textEp;
                        this.handle(textEp);
                        textEp.deactivate();
                    }
                    ((IGraphicalEditPart)viewEp).deactivate();
                }
                diagEp.deactivate();
            }
            ted.dispose();
            resourceSet.eAdapters().remove((Object)ted);
        }

        abstract void handle(ITextAwareEditPart var1);

        public ITextAwareEditPart getTextEditPart() {
            return this.mTextEp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ElementRequestor
    extends DiffSwitch<EObject> {
        private Side side;

        public ElementRequestor(Side pSide) {
            this.side = pSide;
        }

        public EObject caseAttributeChange(AttributeChange object) {
            EObject result = null;
            EObject left = object.getLeftElement();
            EObject right = object.getRightElement();
            switch (this.side) {
                case LEFT: {
                    result = left;
                    break;
                }
                case RIGHT: {
                    result = right;
                    break;
                }
                default: {
                    result = left == null ? right : left;
                }
            }
            return result;
        }

        public EObject caseAttributeChangeLeftTarget(AttributeChangeLeftTarget object) {
            return this.caseAttributeChange((AttributeChange)object);
        }

        public EObject caseAttributeChangeRightTarget(AttributeChangeRightTarget object) {
            return this.caseAttributeChange((AttributeChange)object);
        }

        public EObject caseUpdateAttribute(UpdateAttribute object) {
            return this.caseAttributeChange((AttributeChange)object);
        }

        public EObject caseConflictingDiffElement(ConflictingDiffElement object) {
            return object.getOriginElement();
        }

        public EObject caseModelElementChangeLeftTarget(ModelElementChangeLeftTarget object) {
            return object.getLeftElement();
        }

        public EObject caseModelElementChangeRightTarget(ModelElementChangeRightTarget object) {
            return object.getRightElement();
        }

        public EObject caseUpdateModelElement(UpdateModelElement object) {
            EObject result = null;
            EObject left = object.getLeftElement();
            EObject right = object.getRightElement();
            switch (this.side) {
                case LEFT: {
                    result = left;
                    break;
                }
                case RIGHT: {
                    result = right;
                    break;
                }
                default: {
                    result = left == null ? right : left;
                }
            }
            return result;
        }

        public EObject caseReferenceChange(ReferenceChange object) {
            EObject result = null;
            EObject left = object.getLeftElement();
            EObject right = object.getRightElement();
            switch (this.side) {
                case LEFT: {
                    result = left;
                    break;
                }
                case RIGHT: {
                    result = right;
                    break;
                }
                default: {
                    result = left == null ? right : left;
                }
            }
            return result;
        }

        public EObject caseReferenceChangeLeftTarget(ReferenceChangeLeftTarget object) {
            return this.caseReferenceChange((ReferenceChange)object);
        }

        public EObject caseReferenceChangeRightTarget(ReferenceChangeRightTarget object) {
            return this.caseReferenceChange((ReferenceChange)object);
        }

        public EObject caseReferenceOrderChange(ReferenceOrderChange object) {
            return this.caseReferenceChange((ReferenceChange)object);
        }

        public EObject caseUpdateReference(UpdateReference object) {
            return this.caseReferenceChange((ReferenceChange)object);
        }
    }

    public static final class LabelRequestor
    extends AbstractLabelHandling {
        public LabelRequestor(View pView) {
            super(pView);
        }

        public String getLabel() {
            return this.label;
        }

        void handle(ITextAwareEditPart editPart) {
            this.label = editPart.getEditText();
        }
    }

    public static final class LabelSetter
    extends AbstractLabelHandling {
        public LabelSetter(View pView, String pLabel) {
            super(pView, pLabel);
        }

        void handle(ITextAwareEditPart editPart) {
            ICommand iCommand = this.getDirectEditCommand(editPart);
            CommandStack stack = editPart.getViewer().getEditDomain().getCommandStack();
            stack.execute((Command)new ICommandProxy(iCommand));
        }

        private ICommand getDirectEditCommand(ITextAwareEditPart textEp) {
            EObject model = (EObject)textEp.getModel();
            EObjectAdapterEx elementAdapter = null;
            if (model instanceof View) {
                View lview = (View)model;
                elementAdapter = new EObjectAdapterEx(ViewUtil.resolveSemanticElement((View)lview), lview);
            } else {
                elementAdapter = new EObjectAdapterEx(model, null);
            }
            return textEp.getParser().getParseCommand((IAdaptable)elementAdapter, this.label, 0);
        }

        class EObjectAdapterEx
        extends EObjectAdapter {
            private View mView;

            public EObjectAdapterEx(EObject element, View pView) {
                super(element);
                this.mView = pView;
            }

            public Object getAdapter(Class adapter) {
                Object result = null;
                Object o = super.getAdapter(adapter);
                if (o != null) {
                    result = o;
                } else if (adapter.equals(View.class)) {
                    result = this.mView;
                }
                return result;
            }
        }
    }

    public static final class ParserRequestor
    extends AbstractLabelHandling {
        private IParser parser;

        public ParserRequestor(View pView) {
            super(pView);
        }

        public IParser getParser() {
            return this.parser;
        }

        void handle(ITextAwareEditPart editPart) {
            this.parser = editPart.getParser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        ANY,
        LEFT,
        RIGHT;

    }
}

