/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.internal.ComposedAdapterFactoryOrdered;
import org.eclipse.emf.compare.internal.RegisteredItemProviderAdapterFactoryDescriptor;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisteredItemProviderAdapterFactoryRegistry {
    public static final String EXT_POINT_ID_ADAPTER_FACTORY = "org.eclipse.emf.compare.itemprovideradapterFactory";
    private static final Map<String, RegisteredItemProviderAdapterFactoryDescriptor> STORAGE = new HashMap<String, RegisteredItemProviderAdapterFactoryDescriptor>();
    private static ComposedAdapterFactoryOrdered composedAdapterFactory;
    private static int[] priorityCounter;

    static {
        priorityCounter = new int[5];
    }

    private RegisteredItemProviderAdapterFactoryRegistry() {
    }

    public static synchronized RegisteredItemProviderAdapterFactoryDescriptor addExtension(IConfigurationElement element) {
        RegisteredItemProviderAdapterFactoryDescriptor desc = new RegisteredItemProviderAdapterFactoryDescriptor(element);
        STORAGE.put(desc.getId(), desc);
        RegisteredItemProviderAdapterFactoryRegistry.addElementToPriorityCounter(desc);
        return desc;
    }

    public static synchronized void updateAddedElementInComposedAdapterFactory(RegisteredItemProviderAdapterFactoryDescriptor desc) {
        if (composedAdapterFactory != null) {
            int index = 0;
            int i = 0;
            while (i < desc.getPriority() - 1) {
                index += priorityCounter[i];
                ++i;
            }
            composedAdapterFactory.insertAtAdapterFactory(desc.getAdapterFactory(), index);
        }
    }

    private static void addElementToPriorityCounter(RegisteredItemProviderAdapterFactoryDescriptor desc) {
        int n = desc.getPriority() - 1;
        priorityCounter[n] = priorityCounter[n] + 1;
    }

    private static void removeElementToPriorityCounter(RegisteredItemProviderAdapterFactoryDescriptor desc) {
        int n = desc.getPriority() - 1;
        priorityCounter[n] = priorityCounter[n] - 1;
    }

    public static ComposedAdapterFactory createSortedListOfSpecifcIPAF() {
        if (composedAdapterFactory == null) {
            composedAdapterFactory = new ComposedAdapterFactoryOrdered();
            TreeMap<Integer, ArrayList<AdapterFactory>> specificAdapterFactory = new TreeMap<Integer, ArrayList<AdapterFactory>>();
            for (RegisteredItemProviderAdapterFactoryDescriptor registeredItemProviderAdapterFactoryDescriptor : RegisteredItemProviderAdapterFactoryRegistry.getDescriptors()) {
                List list = (List)specificAdapterFactory.get(registeredItemProviderAdapterFactoryDescriptor.getPriority());
                if (list != null) {
                    list.add(registeredItemProviderAdapterFactoryDescriptor.getAdapterFactory());
                    continue;
                }
                specificAdapterFactory.put(registeredItemProviderAdapterFactoryDescriptor.getPriority(), new ArrayList<AdapterFactory>(Collections.singletonList(registeredItemProviderAdapterFactoryDescriptor.getAdapterFactory())));
            }
            for (Map.Entry entry : specificAdapterFactory.entrySet()) {
                List value = (List)entry.getValue();
                for (AdapterFactory adapter : value) {
                    composedAdapterFactory.addAdapterFactory(adapter);
                }
            }
        }
        return composedAdapterFactory;
    }

    public static synchronized List<RegisteredItemProviderAdapterFactoryDescriptor> getDescriptors() {
        return new ArrayList<RegisteredItemProviderAdapterFactoryDescriptor>(STORAGE.values());
    }

    public static void parseInitialContributions() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_ID_ADAPTER_FACTORY).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                RegisteredItemProviderAdapterFactoryRegistry.addExtension(configElements[j]);
                ++j;
            }
            ++i;
        }
    }

    public static synchronized void clearRegistry() {
        STORAGE.clear();
        if (composedAdapterFactory != null) {
            composedAdapterFactory.dispose();
        }
        composedAdapterFactory = null;
    }

    public static synchronized void removeExtension(IConfigurationElement element) {
        RegisteredItemProviderAdapterFactoryDescriptor desc = new RegisteredItemProviderAdapterFactoryDescriptor(element);
        STORAGE.remove(desc.getId());
        RegisteredItemProviderAdapterFactoryRegistry.removeElementToPriorityCounter(desc);
    }

    public static synchronized void removeFromComposedAdapterFactory(IConfigurationElement element) {
        RegisteredItemProviderAdapterFactoryDescriptor desc = new RegisteredItemProviderAdapterFactoryDescriptor(element);
        if (composedAdapterFactory != null) {
            composedAdapterFactory.removeAdapterFactory(desc.getAdapterFactory());
        }
    }
}

