/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ContentTypePropertyTester
extends PropertyTester {
    private static final String PROPERTY_CONTENT_TYPE_ID = "contentTypeId";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile && expectedValue instanceof String && PROPERTY_CONTENT_TYPE_ID.equals(property)) {
            return ContentTypePropertyTester.hasContentType((IFile)receiver, (String)expectedValue);
        }
        return false;
    }

    private static boolean hasContentType(IFile resource, String contentTypeId) {
        IContentType[] contentTypes;
        IContentType expected;
        block21: {
            IContentTypeManager ctManager = Platform.getContentTypeManager();
            expected = ctManager.getContentType(contentTypeId);
            if (expected == null) {
                return false;
            }
            InputStream resourceContent = null;
            contentTypes = null;
            try {
                resourceContent = resource.getContents();
                contentTypes = ctManager.findContentTypesFor(resourceContent, resource.getName());
            }
            catch (CoreException e) {
                ctManager.findContentTypesFor(resource.getName());
                if (resourceContent != null) {
                    try {
                        resourceContent.close();
                    }
                    catch (IOException iOException) {}
                }
                break block21;
            }
            catch (IOException e) {
                try {
                    ctManager.findContentTypesFor(resource.getName());
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (resourceContent != null) {
                        try {
                            resourceContent.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (resourceContent == null) break block21;
            try {
                resourceContent.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean hasContentType = false;
        if (contentTypes != null) {
            int i = 0;
            while (i < contentTypes.length && !hasContentType) {
                if (contentTypes[i].isKindOf(expected)) {
                    hasContentType = true;
                }
                ++i;
            }
        }
        return hasContentType;
    }
}

