/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScopeProvider;
import org.eclipse.emf.compare.match.engine.MatchScopeProviderUtil;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.compare.match.filter.ResourceFilterRegistry;
import org.eclipse.emf.compare.match.internal.service.DefaultMatchEngineSelector;
import org.eclipse.emf.compare.match.internal.statistic.ResourceSimilarity;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchModel;
import org.eclipse.emf.compare.match.service.IMatchEngineSelector;
import org.eclipse.emf.compare.match.service.MatchEngineDescriptor;
import org.eclipse.emf.compare.match.service.MatchEngineRegistry;
import org.eclipse.emf.compare.util.ModelIdentifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchService {
    private static IMatchEngineSelector matchEngineSelector = new DefaultMatchEngineSelector();

    private MatchService() {
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftObject.eResource(), rightObject.eResource(), ancestor.eResource());
        MatchModel result = engine.contentMatch(leftObject, rightObject, ancestor, options);
        engine.reset();
        return result;
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftObject.eResource(), rightObject.eResource());
        MatchModel result = engine.contentMatch(leftObject, rightObject, options);
        engine.reset();
        return result;
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftRoot.eResource(), rightRoot.eResource(), ancestor.eResource());
        MatchModel result = engine.modelMatch(leftRoot, rightRoot, ancestor, options);
        engine.reset();
        return result;
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftRoot.eResource(), rightRoot.eResource());
        MatchModel result = engine.modelMatch(leftRoot, rightRoot, options);
        engine.reset();
        return result;
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftResource, rightResource);
        MatchModel result = engine.resourceMatch(leftResource, rightResource, options);
        engine.reset();
        return result;
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, Map<String, Object> options) throws InterruptedException {
        IMatchEngine engine = MatchService.getBestMatchEngine(leftResource, rightResource, ancestorResource);
        MatchModel result = engine.resourceMatch(leftResource, rightResource, ancestorResource, options);
        engine.reset();
        return result;
    }

    public static MatchResourceSet doResourceSetMatch(ResourceSet leftResourceSet, ResourceSet rightResourceSet, Map<String, Object> options) throws InterruptedException {
        Resource matchedResource;
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(options, leftResourceSet, rightResourceSet);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        MatchService.applyExternalFilter(scopeProvider);
        ArrayList<Resource> remainingLeftResources = new ArrayList<Resource>((Collection<Resource>)leftResourceSet.getResources());
        ArrayList<Resource> remainingRightResources = new ArrayList<Resource>((Collection<Resource>)rightResourceSet.getResources());
        MatchService.removeUnexistingResources(remainingLeftResources);
        MatchService.removeUnexistingResources(remainingRightResources);
        MatchService.applyScopeFilter(leftScope, remainingLeftResources);
        MatchService.applyScopeFilter(rightScope, remainingRightResources);
        MatchResourceSet match = MatchFactory.eINSTANCE.createMatchResourceSet();
        boolean firstResource = true;
        for (Resource res : new ArrayList<Resource>(remainingLeftResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingRightResources);
            if (matchedResource != null) {
                boolean isMatch;
                boolean bl = isMatch = firstResource && remainingRightResources.size() == 1 || MatchService.findMatchingResource(matchedResource, remainingLeftResources) == res;
                if (isMatch) {
                    remainingLeftResources.remove(res);
                    remainingRightResources.remove(matchedResource);
                    MatchModel comparisonResult = MatchService.doResourceMatch(res, matchedResource, options);
                    if (comparisonResult != null) {
                        match.getMatchModels().add((Object)comparisonResult);
                    }
                }
            }
            firstResource = false;
        }
        for (Resource res : new ArrayList<Resource>(remainingLeftResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingRightResources);
            if (matchedResource != null && MatchService.findMatchingResource(matchedResource, remainingLeftResources) == res) {
                remainingLeftResources.remove(res);
                remainingRightResources.remove(matchedResource);
                MatchModel comparisonResult = MatchService.doResourceMatch(res, matchedResource, options);
                if (comparisonResult == null) continue;
                match.getMatchModels().add((Object)comparisonResult);
                continue;
            }
            UnmatchModel unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.LEFT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            remainingLeftResources.remove(res);
            match.getUnmatchedModels().add((Object)unmatched);
        }
        for (Resource res : new ArrayList<Resource>(remainingRightResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingLeftResources);
            if (matchedResource != null && MatchService.findMatchingResource(matchedResource, remainingRightResources) == res) {
                remainingLeftResources.remove(matchedResource);
                remainingRightResources.remove(res);
                MatchModel comparisonResult = MatchService.doResourceMatch(matchedResource, res, options);
                if (comparisonResult == null) continue;
                match.getMatchModels().add((Object)comparisonResult);
                continue;
            }
            UnmatchModel unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.RIGHT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            remainingLeftResources.remove(res);
            match.getUnmatchedModels().add((Object)unmatched);
        }
        return match;
    }

    public static MatchResourceSet doResourceSetMatch(ResourceSet leftResourceSet, ResourceSet rightResourceSet, ResourceSet ancestorResourceSet, Map<String, Object> options) throws InterruptedException {
        UnmatchModel unmatched;
        MatchModel comparisonResult;
        Resource matchedAncestor;
        Resource matchedRight;
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(options, leftResourceSet, rightResourceSet, ancestorResourceSet);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        IMatchScope ancestorScope = scopeProvider.getAncestorScope();
        MatchService.applyExternalFilter(scopeProvider);
        ArrayList<Resource> remainingLeftResources = new ArrayList<Resource>((Collection<Resource>)leftResourceSet.getResources());
        ArrayList<Resource> remainingRightResources = new ArrayList<Resource>((Collection<Resource>)rightResourceSet.getResources());
        ArrayList<Resource> remainingAncestorResources = new ArrayList<Resource>((Collection<Resource>)ancestorResourceSet.getResources());
        MatchService.removeUnexistingResources(remainingLeftResources);
        MatchService.removeUnexistingResources(remainingRightResources);
        MatchService.removeUnexistingResources(remainingAncestorResources);
        MatchService.applyScopeFilter(leftScope, remainingLeftResources);
        MatchService.applyScopeFilter(rightScope, remainingRightResources);
        MatchService.applyScopeFilter(ancestorScope, remainingAncestorResources);
        MatchResourceSet match = MatchFactory.eINSTANCE.createMatchResourceSet();
        for (Resource res : new ArrayList<Resource>(remainingLeftResources)) {
            matchedRight = MatchService.findMatchingResource(res, remainingRightResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedRight == null || MatchService.findMatchingResource(matchedRight, remainingLeftResources) != res || matchedAncestor == null || MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) != res) continue;
            remainingLeftResources.remove(res);
            remainingRightResources.remove(matchedRight);
            remainingAncestorResources.remove(matchedAncestor);
            comparisonResult = MatchService.doResourceMatch(res, matchedRight, matchedAncestor, options);
            if (comparisonResult == null) continue;
            match.getMatchModels().add((Object)comparisonResult);
        }
        for (Resource res : new ArrayList<Resource>(remainingLeftResources)) {
            matchedRight = MatchService.findMatchingResource(res, remainingRightResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedRight != null && MatchService.findMatchingResource(matchedRight, remainingLeftResources) == res) {
                remainingLeftResources.remove(res);
                remainingRightResources.remove(matchedRight);
                if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                    remainingAncestorResources.remove(matchedAncestor);
                    comparisonResult = MatchService.doResourceMatch(res, matchedRight, matchedAncestor, options);
                    if (comparisonResult == null) continue;
                    match.getMatchModels().add((Object)comparisonResult);
                    continue;
                }
                comparisonResult = MatchService.doResourceMatch(res, matchedRight, options);
                if (comparisonResult == null) continue;
                match.getMatchModels().add((Object)comparisonResult);
                continue;
            }
            remainingLeftResources.remove(res);
            if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
                unmatched.setSide(Side.LEFT);
                unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
                unmatched.setRemote(true);
                remainingAncestorResources.remove(matchedAncestor);
                match.getUnmatchedModels().add((Object)unmatched);
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.LEFT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            match.getUnmatchedModels().add((Object)unmatched);
        }
        for (Resource res : new ArrayList<Resource>(remainingRightResources)) {
            Resource matchedLeft = MatchService.findMatchingResource(res, remainingLeftResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedLeft != null && MatchService.findMatchingResource(matchedLeft, remainingRightResources) == res) {
                remainingLeftResources.remove(matchedLeft);
                remainingRightResources.remove(res);
                if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                    remainingAncestorResources.remove(matchedAncestor);
                    comparisonResult = MatchService.doResourceMatch(matchedLeft, res, matchedAncestor, options);
                    if (comparisonResult == null) continue;
                    match.getMatchModels().add((Object)comparisonResult);
                    continue;
                }
                comparisonResult = MatchService.doResourceMatch(matchedLeft, res, options);
                if (comparisonResult == null) continue;
                match.getMatchModels().add((Object)comparisonResult);
                continue;
            }
            remainingRightResources.remove(res);
            if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
                unmatched.setSide(Side.RIGHT);
                unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
                unmatched.setRemote(true);
                remainingAncestorResources.remove(matchedAncestor);
                match.getUnmatchedModels().add((Object)unmatched);
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.RIGHT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            match.getUnmatchedModels().add((Object)unmatched);
        }
        return match;
    }

    public static Resource findMatchingResource(Resource resource, List<Resource> candidates) {
        return ResourceSimilarity.findMatchingResource(resource, candidates);
    }

    public static IMatchEngine getBestMatchEngine(Resource ... resources) {
        List<MatchEngineDescriptor> engines;
        IMatchEngine engine = null;
        ModelIdentifier identifier = new ModelIdentifier(resources);
        engine = EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault().getBoolean("emfcompare.engine.selection") ? ((engines = MatchEngineRegistry.INSTANCE.getDescriptors(identifier)).size() == 1 ? engines.iterator().next().getEngineInstance() : matchEngineSelector.selectMatchEngine(engines).getEngineInstance()) : MatchEngineRegistry.INSTANCE.getHighestEngine(identifier);
        return engine;
    }

    @Deprecated
    public static IMatchEngine getBestMatchEngine(String engineIdentifier) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault().getBoolean("emfcompare.engine.selection")) {
            MatchEngineDescriptor desc = MatchService.getBestDescriptor(engineIdentifier);
            return desc.getEngineInstance();
        }
        return MatchEngineRegistry.INSTANCE.getHighestEngine(engineIdentifier);
    }

    public static void setMatchEngineSelector(IMatchEngineSelector selector) {
        matchEngineSelector = selector;
    }

    private static void applyExternalFilter(IMatchScopeProvider scopeProvider) {
        for (IResourceFilter filter : ResourceFilterRegistry.INSTANCE.getRegisteredResourceFilters()) {
            scopeProvider.applyResourceFilter(filter);
        }
    }

    private static void applyScopeFilter(IMatchScope scope, List<Resource> resources) {
        Iterator<Resource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            if (scope.isInScope(iterator.next())) continue;
            iterator.remove();
        }
    }

    private static void removeUnexistingResources(List<Resource> resources) {
        Iterator<Resource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getErrors().isEmpty()) continue;
            iterator.remove();
        }
    }

    @Deprecated
    private static MatchEngineDescriptor getBestDescriptor(String engineIdentifier) {
        List<MatchEngineDescriptor> engines = MatchEngineRegistry.INSTANCE.getDescriptors(engineIdentifier);
        MatchEngineDescriptor engine = null;
        if (engines.size() == 1) {
            engine = engines.iterator().next();
        } else if (engines.size() > 1) {
            engine = matchEngineSelector.selectMatchEngine(engines);
        }
        return engine;
    }

    private static List<EObject> getResourceRoots(Resource res) {
        ArrayList<EObject> roots = new ArrayList<EObject>((Collection<EObject>)res.getContents());
        if (res.getContents().isEmpty()) {
            EObject proxy = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)proxy).eSetProxyURI(res.getURI().appendFragment("/"));
            roots.add(proxy);
        }
        return roots;
    }
}

