/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.ModelDescriptorReference;
import org.eclipse.emf.compare.mpatch.apply.generic.GenericApplyActivator;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.AutoMPatchResolver;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.ElementSelectionDialogCellEditor;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.ReferenceResolutionContentProvider;
import org.eclipse.emf.compare.mpatch.apply.generic.impl.ReferenceResolutionLabelProvider;
import org.eclipse.emf.compare.mpatch.apply.util.MPatchValidator;
import org.eclipse.emf.compare.mpatch.extension.IMPatchResolution;
import org.eclipse.emf.compare.mpatch.extension.IMPatchResolutionHost;
import org.eclipse.emf.compare.mpatch.extension.ResolvedSymbolicReferences;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMPatchResolver
implements IMPatchResolution,
ISelectionChangedListener,
ICheckStateListener {
    private static final String[] COLUMNS = new String[]{"OBJECT", "COUNT", "ELEMENTS"};
    private ResolvedSymbolicReferences mapping;
    private Map<IndepChange, Map<IElementReference, List<EObject>>> deactivatedChanges;
    private IMPatchResolutionHost host;
    private EObject currentlySelectedElement;
    private CheckboxTreeViewer viewer;
    private AdapterFactory adapterFactory;
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private ElementSelectionDialogCellEditor elementSelectionDialogCellEditor;
    private boolean respectApplied;

    public String getLabel() {
        return "User-interactive Symbolic References resolution";
    }

    public void refineResolution(ResolvedSymbolicReferences mapping, boolean respectApplied) {
        AutoMPatchResolver.resolve(mapping, respectApplied);
    }

    public void refineResolution(ResolvedSymbolicReferences mapping, boolean respectApplied, IMPatchResolutionHost host) {
        this.mapping = mapping;
        this.host = host;
        this.respectApplied = respectApplied;
        MPatchValidator.validateResolutions((ResolvedSymbolicReferences)mapping, (boolean)respectApplied);
        this.deactivatedChanges = new HashMap<IndepChange, Map<IElementReference, List<EObject>>>();
        this.elementSelectionDialogCellEditor.reset(mapping);
        this.viewer.setContentProvider((IContentProvider)new ReferenceResolutionContentProvider(mapping, this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReferenceResolutionLabelProvider(mapping, this.adapterFactory, respectApplied));
        this.viewer.setInput((Object)mapping.getMPatchModel());
        if (this.onlyGroups((EList<IndepChange>)mapping.getMPatchModel().getChanges())) {
            this.viewer.expandToLevel(2);
        }
        HashSet<EClass> eClasses = new HashSet<EClass>();
        eClasses.add(MPatchPackage.eINSTANCE.getChangeGroup());
        eClasses.add(MPatchPackage.eINSTANCE.getIElementReference());
        List groupsAndSymrefs = ExtEcoreUtils.collectTypedElements((List)mapping.getMPatchModel().getChanges(), eClasses, (boolean)true);
        this.viewer.setGrayedElements(groupsAndSymrefs.toArray());
        this.viewer.setCheckedElements(mapping.getResolutionByChange().keySet().toArray());
    }

    private boolean onlyGroups(EList<IndepChange> changes) {
        for (IndepChange indepChange : changes) {
            if (indepChange instanceof ChangeGroup) continue;
            return false;
        }
        return true;
    }

    public void buildResolutionGUI(Composite parent, AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new CheckboxTreeViewer(container, 68352);
        GridData gd2 = new GridData(272);
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        gd2.horizontalSpan = 2;
        this.viewer.getTree().setLayoutData((Object)gd2);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn objectColumn = new TreeColumn(tree, 0);
        objectColumn.setText("Change / Symbolic Reference");
        objectColumn.setResizable(true);
        objectColumn.setWidth(450);
        TreeColumn countColumn = new TreeColumn(tree, 0);
        countColumn.setText("#");
        countColumn.setResizable(true);
        countColumn.setWidth(40);
        TreeColumn elementsColumn = new TreeColumn(tree, 0);
        elementsColumn.setText("Resolution details and refinement");
        elementsColumn.setResizable(true);
        elementsColumn.setWidth(200);
        CellEditor[] editors = new CellEditor[3];
        this.elementSelectionDialogCellEditor = new ElementSelectionDialogCellEditor(this, (Composite)this.viewer.getTree(), adapterFactory, this.adapterFactoryLabelProvider, this.mapping);
        editors[0] = this.elementSelectionDialogCellEditor;
        editors[1] = editors[0];
        editors[2] = editors[0];
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setCellEditors(editors);
        Button button = new Button(container, 8);
        button.setText("Resolve all conflicts");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenericMPatchResolver.this.host != null && GenericMPatchResolver.this.mapping != null) {
                    GenericMPatchResolver.this.resolveConflicts();
                }
            }
        });
        Label infoLabel = new Label(container, 0);
        infoLabel.setText("Automatically ignore all invalid changes -- manual review recommended afterwards!");
        infoLabel.setToolTipText("All changes that are not valid will be ignored.");
        this.viewer.setCellModifier((ICellModifier)new SymbolicReferenceCellModifier());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean newState = event.getChecked();
        if (event.getElement() instanceof IndepChange && !(event.getElement() instanceof ChangeGroup)) {
            IndepChange change = (IndepChange)event.getElement();
            this.updateMapping(change, newState);
            this.host.resolved(this.mapping);
            this.viewer.refresh();
        } else {
            event.getCheckable().setChecked(event.getElement(), false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.currentlySelectedElement = null;
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1 && selection.getFirstElement() instanceof IElementReference) {
                this.currentlySelectedElement = (IElementReference)selection.getFirstElement();
            } else if (selection.size() == 1 && selection.getFirstElement() instanceof IndepAddRemElementChange) {
                this.currentlySelectedElement = (IndepAddRemElementChange)selection.getFirstElement();
            }
        }
    }

    EObject getCurrentlySelectedElement() {
        return this.currentlySelectedElement;
    }

    private void updateMapping(IndepChange change, boolean addition) {
        if (addition && this.mapping.getResolutionByChange().containsKey(change) || !addition && this.deactivatedChanges.containsKey(change)) {
            throw new IllegalStateException("The checkbox state and the mapping is inconsistent for: " + change);
        }
        ArrayList<IndepChange> collector = new ArrayList<IndepChange>();
        LinkedList<IndepChange> queue = new LinkedList<IndepChange>();
        queue.add(change);
        while (!queue.isEmpty()) {
            IndepChange change2 = (IndepChange)queue.poll();
            if (collector.contains(change2)) continue;
            collector.add(change2);
            if (addition) {
                queue.addAll((Collection<IndepChange>)change2.getDependsOn());
                continue;
            }
            queue.addAll((Collection<IndepChange>)change2.getDependants());
        }
        ArrayList<IndepChange> checkedElements = new ArrayList<IndepChange>();
        Collections.addAll(checkedElements, this.viewer.getCheckedElements());
        if (addition) {
            for (IndepChange add : collector) {
                if (!this.deactivatedChanges.keySet().contains(add)) continue;
                this.mapping.getResolutionByChange().put(add, this.deactivatedChanges.remove(add));
            }
            if (checkedElements.addAll(collector)) {
                this.viewer.setCheckedElements(checkedElements.toArray());
            }
        } else {
            for (IndepChange del : collector) {
                if (!this.mapping.getResolutionByChange().keySet().contains(del)) continue;
                this.deactivatedChanges.put(del, (Map)this.mapping.getResolutionByChange().remove(del));
            }
            if (checkedElements.removeAll(collector)) {
                this.viewer.setCheckedElements(checkedElements.toArray());
            }
        }
    }

    private void updateElements(SymrefRefinement refinement) {
        for (IElementReference ref : refinement.references) {
            IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
            ((Map)this.mapping.getResolutionByChange().get(change)).put(ref, refinement.elements);
        }
        this.host.resolved(this.mapping);
        this.viewer.refresh();
    }

    private void updateElements(IndepAddRemElementChange change, List<?> value) {
        List<?> boundElements = value;
        IElementReference selfReference = change.getSubModelReference();
        ((Map)this.mapping.getResolutionByChange().get(change)).put(selfReference, boundElements);
        this.host.resolved(this.mapping);
        this.viewer.refresh();
    }

    static String getCount(int lowerBound, int upperBound) {
        if (lowerBound < 0) {
            throw new IllegalArgumentException("lower bound must not be less than 0!");
        }
        if (upperBound == lowerBound) {
            return "exactly " + String.valueOf(upperBound) + " element" + (upperBound == 1 ? "" : "s");
        }
        if (upperBound < 0) {
            return "at least " + lowerBound + " elements";
        }
        if (upperBound > lowerBound) {
            return "between " + lowerBound + " and " + upperBound + " elements";
        }
        throw new IllegalArgumentException("lower bound must not be higher than upper bound!");
    }

    private void resolveConflicts() {
        for (IndepChange change : this.mapping.getResolutionByChange().keySet()) {
            if (this.deactivatedChanges.containsKey(change)) {
                GenericApplyActivator.getDefault().logWarning("A change was active and inactive at the same time: " + change);
            }
            this.deactivatedChanges.put(change, (Map)this.mapping.getResolutionByChange().get(change));
        }
        this.refineResolution(this.mapping, this.respectApplied);
        for (IndepChange change : this.mapping.getResolutionByChange().keySet()) {
            this.deactivatedChanges.remove(change);
        }
        this.viewer.setCheckedElements(this.mapping.getResolutionByChange().keySet().toArray());
        this.host.resolved(this.mapping);
        this.viewer.refresh();
    }

    private class SymbolicReferenceCellModifier
    implements ICellModifier {
        private SymbolicReferenceCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof IndepAddElementChange && COLUMNS[2].equals(property)) {
                return true;
            }
            if (!(element instanceof IElementReference) || element instanceof ModelDescriptorReference) {
                return false;
            }
            if (!COLUMNS[2].equals(property)) {
                return false;
            }
            if (GenericMPatchResolver.this.currentlySelectedElement == null) {
                return false;
            }
            IElementReference ref = (IElementReference)element;
            IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
            return change == null || GenericMPatchResolver.this.mapping.getResolutionByChange().containsKey(change);
        }

        public Object getValue(Object element, String property) {
            if (element instanceof IElementReference && COLUMNS[2].equals(property)) {
                IElementReference ref = (IElementReference)element;
                IndepChange change = MPatchUtil.getChangeFor((IElementReference)ref);
                if (change != null && GenericMPatchResolver.this.mapping.getResolutionByChange().containsKey(change)) {
                    int size = ((List)((Map)GenericMPatchResolver.this.mapping.getResolutionByChange().get(change)).get(ref)).size();
                    return String.valueOf(size) + " resolved; " + GenericMPatchResolver.getCount(ref.getLowerBound(), ref.getUpperBound()) + " required";
                }
            } else if (element instanceof IndepAddElementChange && COLUMNS[2].equals(property)) {
                IndepAddElementChange change = (IndepAddElementChange)element;
                IElementReference selfRef = change.getSubModelReference();
                List elements = (List)((Map)GenericMPatchResolver.this.mapping.getResolutionByChange().get(change)).get(selfRef);
                if (elements != null && elements.size() == 1) {
                    return "Bound to: " + GenericMPatchResolver.this.adapterFactoryLabelProvider.getText(elements.get(0));
                }
                if (elements != null && elements.size() > 1) {
                    return "Bound to " + elements.size() + " elements.";
                }
                return "Create new.";
            }
            return "click to edit";
        }

        public void modify(Object element, String property, Object value) {
            TreeItem item;
            if (COLUMNS[2].equals(property) && element instanceof TreeItem && value != null && value instanceof SymrefRefinement) {
                TreeItem item2 = (TreeItem)element;
                if (item2.getData() instanceof IElementReference) {
                    IElementReference ref = (IElementReference)item2.getData();
                    SymrefRefinement symrefRefinement = (SymrefRefinement)value;
                    symrefRefinement.references.add(ref);
                    GenericMPatchResolver.this.updateElements(symrefRefinement);
                }
            } else if (COLUMNS[2].equals(property) && element instanceof TreeItem && value != null && value instanceof List && (item = (TreeItem)element).getData() instanceof IndepAddElementChange) {
                IndepAddElementChange change = (IndepAddElementChange)item.getData();
                GenericMPatchResolver.this.updateElements((IndepAddRemElementChange)change, (List)value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SymrefRefinement {
        final List<EObject> elements;
        final List<IElementReference> references;

        public SymrefRefinement(List<EObject> refinement, List<IElementReference> references) {
            this.references = references;
            this.elements = refinement;
        }
    }
}

