/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.generic.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPatchDependencies
implements IMPatchTransformation {
    public static final String LABEL = "Dependency Graph";
    private static final String DESCRIPTION = "This transformation builds a dependency graph between all changes in the MPatch. This is required for the default MPatch application engine to work properly!\n\nA dependency is defined by the following two rules:\n1. a change A depends on a change B, if B describes the addition of a sub-model and A contains a reference to any element in that sub-model;\n2. a change A depends further on a change B, if A describes the deletion of a sub-model and B contains references to any element in that sub-model.";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 20;
    }

    public boolean isOptional() {
        return false;
    }

    public int transform(MPatchModel mpatch) {
        return MPatchDependencies.calculateDependencies(mpatch);
    }

    public static int calculateDependencies(MPatchModel mpatch) {
        List changes = ExtEcoreUtils.collectTypedElements((List)mpatch.getChanges(), Collections.singleton(MPatchPackage.Literals.INDEP_CHANGE), (boolean)true);
        Map<IndepChange, Set<IndepChange>> dependencyMap = MPatchDependencies.analyzeChanges(changes);
        return MPatchDependencies.addDependencies(dependencyMap);
    }

    protected static Map<IndepChange, Set<IndepChange>> analyzeChanges(List<IndepChange> changes) {
        T3<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>, Map<String, IndepChange>> maps = MPatchDependencies.fillMaps(changes);
        LinkedList<IndepChange> queue = new LinkedList<IndepChange>();
        HashSet processed = new HashSet();
        HashMap<IndepChange, Set<IndepChange>> dependencyMap = new HashMap<IndepChange, Set<IndepChange>>();
        for (IndepChange change : ((Map)maps.s).keySet()) {
            if (processed.contains(change)) continue;
            HashSet<IndepChange> group = new HashSet<IndepChange>();
            queue.add(change);
            while (!queue.isEmpty()) {
                IndepChange current = (IndepChange)queue.remove();
                group.add(current);
                for (String ref : (Set)((Map)maps.s).get(current)) {
                    for (IndepChange refChange : (Set)((Map)maps.t).get(ref)) {
                        if (group.contains(refChange) || queue.contains(refChange)) continue;
                        queue.add(refChange);
                    }
                    if (((Map)maps.u).get(ref) == null || ((IndepChange)((Map)maps.u).get(ref)).equals(current)) continue;
                    MPatchUtil.addElementToSetMap((Object)current, (Object)((IndepChange)((Map)maps.u).get(ref)), dependencyMap);
                }
            }
            processed.addAll(group);
        }
        return dependencyMap;
    }

    protected static T3<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>, Map<String, IndepChange>> fillMaps(List<IndepChange> changes) {
        HashMap changeToRefMap = new HashMap();
        HashMap refToChangeMap = new HashMap();
        HashMap<String, IndepChange> dependencyMap = new HashMap<String, IndepChange>();
        for (IndepChange change : changes) {
            HashSet<String> references = new HashSet<String>();
            for (EReference containment : change.eClass().getEAllContainments()) {
                ArrayList<EObject> children = new ArrayList<EObject>();
                if (containment.isMany()) {
                    children.addAll((List)change.eGet((EStructuralFeature)containment));
                } else {
                    children.add((EObject)change.eGet((EStructuralFeature)containment));
                }
                for (EObject eObject : children) {
                    if (eObject instanceof IModelDescriptor) {
                        IModelDescriptor descriptor = (IModelDescriptor)eObject;
                        ArrayList descriptorReferences = new ArrayList();
                        descriptorReferences.addAll(descriptor.getAllCrossReferences());
                        descriptorReferences.addAll(descriptor.getAllSelfReferences());
                        for (IElementReference ref : descriptorReferences) {
                            references.add(MPatchDependencies.getSymbolicReferenceRepresentative(ref));
                            MPatchUtil.addElementToSetMap((Object)MPatchDependencies.getSymbolicReferenceRepresentative(ref), (Object)change, refToChangeMap);
                            for (IElementReference descriptorSelfReference : descriptor.getAllSelfReferences()) {
                                dependencyMap.put(MPatchDependencies.getSymbolicReferenceRepresentative(descriptorSelfReference), change);
                            }
                        }
                        continue;
                    }
                    if (!(eObject instanceof IElementReference)) continue;
                    references.add(MPatchDependencies.getSymbolicReferenceRepresentative((IElementReference)eObject));
                    MPatchUtil.addElementToSetMap((Object)MPatchDependencies.getSymbolicReferenceRepresentative((IElementReference)eObject), (Object)change, refToChangeMap);
                }
            }
            changeToRefMap.put(change, references);
        }
        return new T3<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>, Map<String, IndepChange>>(changeToRefMap, refToChangeMap, dependencyMap);
    }

    protected static String getSymbolicReferenceRepresentative(IElementReference reference) {
        String uriReference = reference.getUriReference();
        if (uriReference.indexOf("#") > 0) {
            return uriReference.substring(uriReference.indexOf("#"));
        }
        return uriReference;
    }

    protected static int addDependencies(Map<IndepChange, Set<IndepChange>> dependencyMap) {
        int count = 0;
        for (IndepChange change : dependencyMap.keySet()) {
            for (IndepChange dep : dependencyMap.get(change)) {
                switch (dep.getChangeKind()) {
                    case ADDITION: {
                        change.getDependsOn().add((Object)dep);
                        ++count;
                        break;
                    }
                    case DELETION: {
                        change.getDependants().add((Object)dep);
                        ++count;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("DependencyMap contains a change as value which neither is an addition nor a deletion!");
                    }
                }
            }
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class T3<S, T, U> {
        public final S s;
        public final T t;
        public final U u;

        public T3(S s, T t, U u) {
            this.s = s;
            this.t = t;
            this.u = u;
        }
    }
}

