/*******************************************************************************
 * Copyright (c) 2010, 2011 Technical University of Denmark.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *    Patrick Koenemann, DTU Informatics - initial API and implementation
 *
 * $Id: BindingItemProviderAdapterFactory.java,v 1.1 2010/09/10 15:27:17 cbrun Exp $
 *******************************************************************************/
package org.eclipse.emf.compare.mpatch.binding.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.mpatch.binding.util.BindingAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;


/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BindingItemProviderAdapterFactory extends BindingAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BindingItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.MPatchModelBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPatchModelBindingItemProvider mPatchModelBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.MPatchModelBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPatchModelBindingAdapter() {
		if (mPatchModelBindingItemProvider == null) {
			mPatchModelBindingItemProvider = new MPatchModelBindingItemProvider(this);
		}

		return mPatchModelBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.ElementChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementChangeBindingItemProvider elementChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.ElementChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementChangeBindingAdapter() {
		if (elementChangeBindingItemProvider == null) {
			elementChangeBindingItemProvider = new ElementChangeBindingItemProvider(this);
		}

		return elementChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.SubModelBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubModelBindingItemProvider subModelBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.SubModelBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubModelBindingAdapter() {
		if (subModelBindingItemProvider == null) {
			subModelBindingItemProvider = new SubModelBindingItemProvider(this);
		}

		return subModelBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.AttributeChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeChangeBindingItemProvider attributeChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.AttributeChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeChangeBindingAdapter() {
		if (attributeChangeBindingItemProvider == null) {
			attributeChangeBindingItemProvider = new AttributeChangeBindingItemProvider(this);
		}

		return attributeChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.AddElementChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AddElementChangeBindingItemProvider addElementChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.AddElementChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAddElementChangeBindingAdapter() {
		if (addElementChangeBindingItemProvider == null) {
			addElementChangeBindingItemProvider = new AddElementChangeBindingItemProvider(this);
		}

		return addElementChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.MoveElementChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MoveElementChangeBindingItemProvider moveElementChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.MoveElementChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMoveElementChangeBindingAdapter() {
		if (moveElementChangeBindingItemProvider == null) {
			moveElementChangeBindingItemProvider = new MoveElementChangeBindingItemProvider(this);
		}

		return moveElementChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.AddReferenceChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AddReferenceChangeBindingItemProvider addReferenceChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.AddReferenceChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAddReferenceChangeBindingAdapter() {
		if (addReferenceChangeBindingItemProvider == null) {
			addReferenceChangeBindingItemProvider = new AddReferenceChangeBindingItemProvider(this);
		}

		return addReferenceChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.UpdateReferenceChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UpdateReferenceChangeBindingItemProvider updateReferenceChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.UpdateReferenceChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUpdateReferenceChangeBindingAdapter() {
		if (updateReferenceChangeBindingItemProvider == null) {
			updateReferenceChangeBindingItemProvider = new UpdateReferenceChangeBindingItemProvider(this);
		}

		return updateReferenceChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.RemoveElementChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RemoveElementChangeBindingItemProvider removeElementChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.RemoveElementChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRemoveElementChangeBindingAdapter() {
		if (removeElementChangeBindingItemProvider == null) {
			removeElementChangeBindingItemProvider = new RemoveElementChangeBindingItemProvider(this);
		}

		return removeElementChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.RemoveReferenceChangeBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RemoveReferenceChangeBindingItemProvider removeReferenceChangeBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.RemoveReferenceChangeBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRemoveReferenceChangeBindingAdapter() {
		if (removeReferenceChangeBindingItemProvider == null) {
			removeReferenceChangeBindingItemProvider = new RemoveReferenceChangeBindingItemProvider(this);
		}

		return removeReferenceChangeBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.mpatch.binding.Note} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NoteItemProvider noteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.mpatch.binding.Note}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNoteAdapter() {
		if (noteItemProvider == null) {
			noteItemProvider = new NoteItemProvider(this);
		}

		return noteItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (mPatchModelBindingItemProvider != null) mPatchModelBindingItemProvider.dispose();
		if (elementChangeBindingItemProvider != null) elementChangeBindingItemProvider.dispose();
		if (subModelBindingItemProvider != null) subModelBindingItemProvider.dispose();
		if (attributeChangeBindingItemProvider != null) attributeChangeBindingItemProvider.dispose();
		if (addElementChangeBindingItemProvider != null) addElementChangeBindingItemProvider.dispose();
		if (moveElementChangeBindingItemProvider != null) moveElementChangeBindingItemProvider.dispose();
		if (addReferenceChangeBindingItemProvider != null) addReferenceChangeBindingItemProvider.dispose();
		if (updateReferenceChangeBindingItemProvider != null) updateReferenceChangeBindingItemProvider.dispose();
		if (removeElementChangeBindingItemProvider != null) removeElementChangeBindingItemProvider.dispose();
		if (removeReferenceChangeBindingItemProvider != null) removeReferenceChangeBindingItemProvider.dispose();
		if (noteItemProvider != null) noteItemProvider.dispose();
	}

}
