/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.compare.logical.EMFLogicalModelMessages;
import org.eclipse.emf.compare.logical.model.EMFModelProvider;
import org.eclipse.emf.compare.logical.model.EMFResourceMapping;
import org.eclipse.emf.compare.logical.synchronization.EMFDelta;
import org.eclipse.emf.compare.logical.synchronization.EMFModelDelta;
import org.eclipse.emf.compare.logical.ui.synchronize.EMFCompareSynchronizationAdapter;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;

public class EMFSynchronizationContentProvider
extends SynchronizationContentProvider {
    private final AdapterFactoryContentProvider delegateContentProvider = new AdapterFactoryContentProvider(AdapterUtils.getAdapterFactory());
    private boolean isInitializing;

    public void dispose() {
        this.delegateContentProvider.dispose();
        super.dispose();
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        return this.delegateContentProvider;
    }

    protected boolean isInitialized(ISynchronizationContext context) {
        return !this.isInitializing && context.getCache().get("org.eclipse.emf.compare.model.provider.sync.cache") != null;
    }

    protected void requestInitialization(final ISynchronizationContext context) {
        if (!this.isInitializing) {
            this.isInitializing = true;
            Job emfSynchronizationJob = new Job(EMFLogicalModelMessages.getString((String)"synchronize.job.label")){

                protected IStatus run(IProgressMonitor monitor) {
                    Object adapter;
                    EMFCompareSynchronizationAdapter emfCompareAdapter = null;
                    ModelProvider modelProvider = EMFSynchronizationContentProvider.this.getModelProvider();
                    if (modelProvider instanceof EMFModelProvider && (adapter = modelProvider.getAdapter(ISynchronizationCompareAdapter.class)) instanceof EMFCompareSynchronizationAdapter) {
                        emfCompareAdapter = (EMFCompareSynchronizationAdapter)((Object)adapter);
                    }
                    if (emfCompareAdapter != null) {
                        try {
                            emfCompareAdapter.initialize(context, monitor);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EMFSynchronizationContentProvider.this.refresh();
                        }
                    });
                    EMFSynchronizationContentProvider.this.isInitializing = false;
                    return Status.OK_STATUS;
                }
            };
            emfSynchronizationJob.schedule();
        }
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        Object cachedDelta = context.getCache().get("org.eclipse.emf.compare.model.provider.sync.cache");
        if (cachedDelta instanceof EMFModelDelta) {
            EMFModelDelta delta = (EMFModelDelta)cachedDelta;
            ArrayList<Object> childrenInScope = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                EMFDelta childDelta = delta.getChildDeltaFor(child);
                if (childDelta != null && (childDelta.getKind() == 0 || this.includeDirection(childDelta.getDirection()))) {
                    childrenInScope.add(child);
                }
                ++n2;
            }
            return childrenInScope.toArray(new Object[childrenInScope.size()]);
        }
        return super.getChildrenInContext(context, parent, children);
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        return null;
    }

    protected String getModelProviderId() {
        return "org.eclipse.emf.compare.model.provider";
    }

    protected Object getModelRoot() {
        ResourceMapping[] mappings;
        ResourceSet modelRoot = null;
        ResourceMapping[] resourceMappingArray = mappings = this.getScope().getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if ("org.eclipse.emf.compare.model.provider".equals(mapping.getModelProviderId()) && mapping instanceof EMFResourceMapping) {
                EMFResourceMapping emfMapping = (EMFResourceMapping)mapping;
                ResourceSet local = emfMapping.getLocalResourceSet();
                if (modelRoot == null || modelRoot.getResources().size() < local.getResources().size()) {
                    modelRoot = local;
                }
            }
            ++n2;
        }
        return modelRoot;
    }
}

