/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.logical.EMFLogicalModelMessages;
import org.eclipse.emf.compare.util.DelegatingURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionedURIConverter
extends DelegatingURIConverter {
    private IFileRevision baseRevision;

    public RevisionedURIConverter(URIConverter delegate, IStorage storage) throws CoreException {
        super(delegate);
        this.setStorage(storage);
    }

    public void setStorage(IStorage storage) throws CoreException {
        Object revision = storage.getAdapter(IFileRevision.class);
        if (!(revision instanceof IFileRevision)) {
            revision = Platform.getAdapterManager().getAdapter((Object)storage, IFileRevision.class);
        }
        if (!(revision instanceof IFileRevision)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.compare.logical", EMFLogicalModelMessages.getString("storage.adapt.failure", storage.getFullPath())));
        }
        this.baseRevision = (IFileRevision)revision;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = null;
        URI normalizedUri = this.normalize(uri);
        if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
            stream = super.createInputStream(normalizedUri, options);
        } else {
            IFile targetFile = normalizedUri.isPlatform() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toPlatformString(true))) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toString()));
            if (targetFile != null) {
                stream = this.openRevisionStream((IResource)targetFile);
            }
            if (stream == null) {
                return super.createInputStream(uri, options);
            }
        }
        return stream;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        IFileHistoryProvider historyProvider;
        IFileHistory history;
        InputStream stream = null;
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)targetFile.getProject());
        if (repositoryProvider != null && (history = (historyProvider = repositoryProvider.getFileHistoryProvider()).getFileHistoryFor(targetFile, 0, (IProgressMonitor)new NullProgressMonitor())) != null) {
            IFileRevision soughtRevision = null;
            IFileRevision[] iFileRevisionArray = history.getFileRevisions();
            int n = iFileRevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileRevision revision = iFileRevisionArray[n2];
                if (revision.getTimestamp() <= this.baseRevision.getTimestamp()) {
                    soughtRevision = revision;
                    break;
                }
                if (soughtRevision == null || soughtRevision.getTimestamp() >= revision.getTimestamp()) {
                    soughtRevision = revision;
                }
                ++n2;
            }
            if (soughtRevision != null) {
                try {
                    stream = soughtRevision.getStorage((IProgressMonitor)new NullProgressMonitor()).getContents();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        if (stream != null && targetFile.exists()) {
            try {
                IFileState soughtState = null;
                IFileState[] iFileStateArray = ((IFile)targetFile).getHistory((IProgressMonitor)new NullProgressMonitor());
                int n = iFileStateArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IFileState state = iFileStateArray[n3];
                    if (state.getModificationTime() <= this.baseRevision.getTimestamp()) {
                        soughtState = state;
                        break;
                    }
                    ++n3;
                }
                stream = soughtState != null ? soughtState.getContents() : ((IFile)targetFile).getContents();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return stream;
    }
}

