/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.check.AbstractCheck;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.match.internal.statistic.ResourceSimilarity;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesCheck
extends AbstractCheck {
    private static final String PROXY_PREFIX = "emfCompareProxy:/";

    @Deprecated
    public ReferencesCheck(EcoreUtil.CrossReferencer referencer) {
        super(referencer);
    }

    public ReferencesCheck(IMatchManager manager) {
        super(manager);
    }

    public void checkReferencesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, mapping, next);
        }
    }

    public void checkReferencesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassReferences = eClass.getEAllReferences();
        for (EReference next : eclassReferences) {
            if (!this.shouldBeIgnored(next)) {
                this.checkReferenceUpdates(root, mapping, next);
                continue;
            }
            if (!next.isContainment() || !next.isOrdered()) continue;
            this.checkContainmentReferenceOrderChange(root, (Match2Elements)mapping, next);
        }
    }

    protected void checkContainmentReferenceOrderChange(DiffGroup root, Match2Elements mapping, EReference reference) throws FactoryException {
        ArrayList leftElementReferences = new ArrayList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)reference.getName()));
        ArrayList rightElementReferences = new ArrayList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)reference.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>();
        for (EObject leftValue : new ArrayList(leftElementReferences)) {
            if (this.getMatchManager().isInScope(leftValue) && !this.getMatchManager().isUnmatched(leftValue) && this.getMatchManager().getMatchedEObject(leftValue.eContainer()) == this.getMatchManager().getMatchedEObject(leftValue).eContainer()) continue;
            leftElementReferences.remove(leftValue);
        }
        for (EObject rightValue : new ArrayList(rightElementReferences)) {
            if (this.getMatchManager().isInScope(rightValue) && !this.getMatchManager().isUnmatched(rightValue) && this.getMatchManager().getMatchedEObject(rightValue.eContainer()) == this.getMatchManager().getMatchedEObject(rightValue).eContainer()) continue;
            removedIndices.add(rightElementReferences.indexOf(rightValue));
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < leftElementReferences.size()) {
            EObject matched = this.getMatchManager().getMatchedEObject((EObject)leftElementReferences.get(i));
            for (Integer removedIndex : new ArrayList(removedIndices)) {
                if (expectedIndex != removedIndex) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndex);
            }
            if (rightElementReferences.indexOf(matched) != expectedIndex++) {
                ReferenceOrderChange refChange = DiffFactory.eINSTANCE.createReferenceOrderChange();
                refChange.setReference(reference);
                refChange.setLeftElement(mapping.getLeftElement());
                refChange.setRightElement(mapping.getRightElement());
                ArrayList<EObject> leftTarget = new ArrayList<EObject>();
                int j = 0;
                while (j < rightElementReferences.size()) {
                    EObject right = (EObject)rightElementReferences.get(j);
                    EObject target = this.getMatchManager().getMatchedEObject(right);
                    if (target == null) {
                        target = this.createProxyFor(right);
                    }
                    leftTarget.add(target);
                    ++j;
                }
                ArrayList<EObject> rightTarget = new ArrayList<EObject>();
                int j2 = 0;
                while (j2 < leftElementReferences.size()) {
                    EObject left = (EObject)leftElementReferences.get(j2);
                    EObject target = this.getMatchManager().getMatchedEObject(left);
                    if (target == null) {
                        target = this.createProxyFor(left);
                    }
                    rightTarget.add(target);
                    ++j2;
                }
                refChange.getLeftTarget().addAll(leftTarget);
                refChange.getRightTarget().addAll(rightTarget);
                root.getSubDiffElements().add((Object)refChange);
                break;
            }
            ++i;
        }
    }

    private EObject createProxyFor(EObject original) {
        if (original.eIsProxy()) {
            return original;
        }
        EFactory factory = original.eClass().getEPackage().getEFactoryInstance();
        EObject proxy = factory.create(original.eClass());
        ((InternalEObject)proxy).eSetProxyURI(URI.createURI((String)(PROXY_PREFIX + EcoreUtil.getURI((EObject)original).toString())));
        return proxy;
    }

    protected void checkReferenceOrderChange(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement, List<ReferenceChangeLeftTarget> addedReferences, List<ReferenceChangeRightTarget> removedReferences) throws FactoryException {
        ArrayList leftElementReferences = new ArrayList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)leftElement, (String)reference.getName()));
        ArrayList rightElementReferences = new ArrayList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)rightElement, (String)reference.getName()));
        ArrayList<Integer> removedIndices = new ArrayList<Integer>(removedReferences.size());
        ArrayList filteredLeft = new ArrayList(leftElementReferences);
        for (ReferenceChangeLeftTarget added : addedReferences) {
            filteredLeft.remove(added.getLeftTarget());
        }
        for (ReferenceChangeRightTarget removed : removedReferences) {
            removedIndices.add(rightElementReferences.indexOf(removed.getRightTarget()));
        }
        int expectedIndex = 0;
        int i = 0;
        while (i < filteredLeft.size()) {
            EObject matched = this.getMatchManager().getMatchedEObject((EObject)filteredLeft.get(i));
            if (matched == null) {
                matched = (EObject)filteredLeft.get(i);
            }
            for (Integer removedIndex : new ArrayList(removedIndices)) {
                if (i != removedIndex) continue;
                ++expectedIndex;
                removedIndices.remove(removedIndex);
            }
            int actualIndex = rightElementReferences.indexOf(matched);
            if (actualIndex == -1) {
                int j = 0;
                while (j < rightElementReferences.size() && actualIndex == -1) {
                    if (!this.areDistinct(matched, (EObject)rightElementReferences.get(j))) {
                        actualIndex = j;
                    }
                    ++j;
                }
            }
            if (actualIndex != expectedIndex++) {
                ReferenceOrderChange refChange = DiffFactory.eINSTANCE.createReferenceOrderChange();
                refChange.setReference(reference);
                refChange.setLeftElement(leftElement);
                refChange.setRightElement(rightElement);
                ArrayList<EObject> leftTarget = new ArrayList<EObject>();
                int j = 0;
                while (j < rightElementReferences.size()) {
                    EObject right = (EObject)rightElementReferences.get(j);
                    EObject target = this.getMatchManager().getMatchedEObject(right);
                    if (target == null) {
                        target = this.createProxyFor(right);
                    }
                    leftTarget.add(target);
                    ++j;
                }
                ArrayList<EObject> rightTarget = new ArrayList<EObject>();
                int j2 = 0;
                while (j2 < leftElementReferences.size()) {
                    EObject left = (EObject)leftElementReferences.get(j2);
                    EObject target = this.getMatchManager().getMatchedEObject(left);
                    if (target == null) {
                        target = this.createProxyFor(left);
                    }
                    rightTarget.add(target);
                    ++j2;
                }
                refChange.getLeftTarget().addAll(leftTarget);
                refChange.getRightTarget().addAll(rightTarget);
                root.getSubDiffElements().add((Object)refChange);
                break;
            }
            ++i;
        }
    }

    protected void checkReferenceUpdates(DiffGroup root, Match2Elements mapping, EReference reference) throws FactoryException {
        this.createNonConflictingReferencesUpdate(root, reference, mapping.getLeftElement(), mapping.getRightElement());
    }

    protected void checkReferenceUpdates(DiffGroup root, Match3Elements mapping, EReference reference) throws FactoryException {
        List<Object> ancestorReferences;
        List<Object> rightReferences;
        String referenceName = reference.getName();
        List<Object> leftReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName));
        if (this.isConflictual(reference, leftReferences, rightReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName)), ancestorReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName)))) {
            this.createConflictingReferenceUpdate(root, reference, mapping);
            return;
        }
        ArrayList<EObject> remoteDeletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> remoteAddedReferences = new ArrayList<EObject>();
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        this.populateThreeWayReferencesChanges(mapping, reference, addedReferences, deletedReferences, remoteAddedReferences, remoteDeletedReferences);
        this.createRemoteReferencesUpdate(root, reference, mapping, remoteAddedReferences, remoteDeletedReferences);
        if (!reference.isMany()) {
            EObject addedValue = null;
            EObject deletedValue = null;
            if (addedReferences.size() > 0) {
                addedValue = (EObject)addedReferences.get(0);
            }
            if (deletedReferences.size() > 0) {
                deletedValue = (EObject)deletedReferences.get(0);
            }
            if (this.areDistinct(addedValue, deletedValue)) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(mapping.getLeftElement(), mapping.getRightElement(), reference, addedValue, deletedValue));
            }
        } else {
            ArrayList<EObject> addedReferencesCopy = new ArrayList<EObject>(addedReferences);
            ArrayList<EObject> deletedReferencesCopy = new ArrayList<EObject>(deletedReferences);
            for (EObject addedReference : addedReferencesCopy) {
                deletedReferences.remove(addedReference);
            }
            for (EObject deletedReference : deletedReferencesCopy) {
                addedReferences.remove(deletedReference);
            }
            ArrayList<ReferenceChangeLeftTarget> addedReferencesDiffs = new ArrayList<ReferenceChangeLeftTarget>(addedReferences.size());
            ArrayList<ReferenceChangeRightTarget> removedReferencesDiffs = new ArrayList<ReferenceChangeRightTarget>(deletedReferences.size());
            if (addedReferences.size() > 0) {
                addedReferencesDiffs.addAll(this.createNewReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), reference, addedReferences));
            }
            if (deletedReferences.size() > 0) {
                removedReferencesDiffs.addAll(this.createRemovedReferencesOperation(root, mapping.getLeftElement(), mapping.getRightElement(), reference, deletedReferences));
            }
            if (reference.isOrdered()) {
                this.checkReferenceOrderChange(root, reference, mapping.getLeftElement(), mapping.getRightElement(), addedReferencesDiffs, removedReferencesDiffs);
            }
        }
    }

    private boolean areDistinct(EObject addedValue, EObject deletedValue) {
        double similarReferenceURIThreshold = 0.8;
        boolean createDiff = false;
        if (addedValue == deletedValue) {
            createDiff = false;
        } else if ((addedValue == null || deletedValue == null) && addedValue != deletedValue) {
            createDiff = true;
        } else if (this.getMatchManager().isUnmatched(addedValue) && this.getMatchManager().isUnmatched(deletedValue)) {
            createDiff = true;
        } else if (addedValue != null && deletedValue != null) {
            EObject matchAdded = this.getMatchManager().getMatchedEObject(addedValue);
            if (matchAdded != null && matchAdded != deletedValue) {
                createDiff = true;
            } else if (this.getMatchManager().getMatchedEObject(deletedValue) != null) {
                createDiff = true;
            } else {
                URI addedURI = EcoreUtil.getURI((EObject)addedValue);
                URI deletedURI = EcoreUtil.getURI((EObject)deletedValue);
                if (addedValue.eIsProxy() && deletedValue.eIsProxy()) {
                    createDiff = !addedURI.equals((Object)deletedURI);
                } else if (addedValue.eIsProxy() || deletedValue.eIsProxy()) {
                    createDiff = true;
                } else if (ResourceSimilarity.computeURISimilarity((URI)addedURI, (URI)deletedURI) < 0.8) {
                    createDiff = true;
                }
            }
        }
        return createDiff;
    }

    protected boolean shouldBeIgnored(EReference reference) {
        boolean ignore = reference.isContainment();
        ignore = ignore || reference.isDerived();
        ignore = ignore || reference.isTransient();
        ignore = ignore || reference.isContainer();
        ignore = ignore || reference.eContainer() == EcorePackage.eINSTANCE.getEGenericType();
        return ignore;
    }

    private List<EObject> computeAddedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        ArrayList<EObject> deletedProxies = new ArrayList<EObject>();
        if (leftReferences != null) {
            addedReferences.addAll(leftReferences);
        }
        if (rightReferences != null) {
            for (EObject obj : rightReferences) {
                if (obj.eIsProxy()) {
                    deletedProxies.add(obj);
                    continue;
                }
                deletedReferences.add(obj);
            }
        }
        List<EObject> matchedOldReferences = this.getMatchedReferences(deletedReferences);
        addedReferences.removeAll(deletedReferences);
        addedReferences.removeAll(matchedOldReferences);
        Iterator addedCandidates = addedReferences.iterator();
        while (addedCandidates.hasNext() && !deletedProxies.isEmpty()) {
            EObject added = (EObject)addedCandidates.next();
            if (!added.eIsProxy()) continue;
            URI addedURI = ((InternalEObject)added).eProxyURI();
            boolean hasMatch = false;
            Iterator candidateMatches = deletedProxies.iterator();
            while (!hasMatch && candidateMatches.hasNext()) {
                EObject candidate = (EObject)candidateMatches.next();
                if (!addedURI.equals((Object)((InternalEObject)candidate).eProxyURI())) continue;
                hasMatch = true;
                candidateMatches.remove();
            }
            if (!hasMatch) continue;
            addedCandidates.remove();
        }
        return addedReferences;
    }

    private List<EObject> computeDeletedReferences(List<EObject> leftReferences, List<EObject> rightReferences) {
        ArrayList<EObject> deletedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedReferences = new ArrayList<EObject>();
        ArrayList<EObject> addedProxies = new ArrayList<EObject>();
        if (leftReferences != null) {
            for (EObject obj : leftReferences) {
                if (obj.eIsProxy()) {
                    addedProxies.add(obj);
                    continue;
                }
                addedReferences.add(obj);
            }
        }
        if (rightReferences != null) {
            deletedReferences.addAll(rightReferences);
        }
        List<EObject> matchedNewReferences = this.getMatchedReferences(addedReferences);
        deletedReferences.removeAll(addedReferences);
        deletedReferences.removeAll(matchedNewReferences);
        Iterator deletedCandidates = deletedReferences.iterator();
        while (deletedCandidates.hasNext() && !addedProxies.isEmpty()) {
            EObject deleted = (EObject)deletedCandidates.next();
            if (!deleted.eIsProxy()) continue;
            URI deletedURI = ((InternalEObject)deleted).eProxyURI();
            boolean hasMatch = false;
            Iterator candidateMatches = addedProxies.iterator();
            while (!hasMatch && candidateMatches.hasNext()) {
                EObject candidate = (EObject)candidateMatches.next();
                if (!deletedURI.equals((Object)((InternalEObject)candidate).eProxyURI())) continue;
                hasMatch = true;
                candidateMatches.remove();
            }
            if (!hasMatch) continue;
            deletedCandidates.remove();
        }
        return deletedReferences;
    }

    private void createConflictingReferenceUpdate(DiffGroup root, EReference reference, Match3Elements mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingReferencesUpdate(dummyGroup, reference, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            for (DiffElement subDiff : new ArrayList<DiffElement>((Collection<DiffElement>)dummyGroup.getSubDiffElements())) {
                conflictingDiff.getSubDiffElements().add((Object)subDiff);
            }
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private List<ReferenceChangeLeftTarget> createNewReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> addedReferences) {
        ArrayList<ReferenceChangeLeftTarget> result = new ArrayList<ReferenceChangeLeftTarget>();
        for (EObject eobj : addedReferences) {
            ReferenceChangeLeftTarget addOperation = DiffFactory.eINSTANCE.createReferenceChangeLeftTarget();
            addOperation.setRightElement(right);
            addOperation.setLeftElement(left);
            addOperation.setReference(reference);
            addOperation.setLeftTarget(eobj);
            if (this.getMatchManager().getMatchedEObject(eobj) != null) {
                addOperation.setRightTarget(this.getMatchManager().getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)addOperation);
            result.add(addOperation);
        }
        return result;
    }

    private void createNonConflictingReferencesUpdate(DiffGroup root, EReference reference, EObject leftElement, EObject rightElement) throws FactoryException {
        List<Object> leftElementObjReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)leftElement, (String)reference.getName()));
        List<Object> rightElementObjReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)rightElement, (String)reference.getName()));
        ArrayList<EObject> leftElementReferences = new ArrayList<EObject>();
        ArrayList<EObject> rightElementReferences = new ArrayList<EObject>();
        for (Object left : leftElementObjReferences) {
            leftElementReferences.add((EObject)left);
        }
        for (Object right : rightElementObjReferences) {
            rightElementReferences.add((EObject)right);
        }
        List<EObject> deletedReferences = this.computeDeletedReferences(leftElementReferences, rightElementReferences);
        List<EObject> addedReferences = this.computeAddedReferences(leftElementReferences, rightElementReferences);
        if (!reference.isMany()) {
            EObject addedValue = null;
            EObject deletedValue = null;
            if (addedReferences.size() > 0) {
                addedValue = addedReferences.get(0);
            }
            if (deletedReferences.size() > 0) {
                deletedValue = deletedReferences.get(0);
            }
            if (this.getMatchManager().isUnmatched(addedValue) || this.getMatchManager().isUnmatched(deletedValue) || this.areDistinct(addedValue, deletedValue)) {
                root.getSubDiffElements().add((Object)this.createUpdatedReferenceOperation(leftElement, rightElement, reference, addedValue, deletedValue));
            }
        } else {
            Iterator<EObject> addedIterator = addedReferences.iterator();
            while (addedIterator.hasNext()) {
                EObject added = addedIterator.next();
                Iterator<EObject> deletedIterator = deletedReferences.iterator();
                while (deletedIterator.hasNext()) {
                    EObject deleted = deletedIterator.next();
                    if (this.areDistinct(added, deleted)) continue;
                    addedIterator.remove();
                    deletedIterator.remove();
                }
            }
            ArrayList<ReferenceChangeLeftTarget> addedReferencesDiffs = new ArrayList<ReferenceChangeLeftTarget>(addedReferences.size());
            ArrayList<ReferenceChangeRightTarget> removedReferencesDiffs = new ArrayList<ReferenceChangeRightTarget>(deletedReferences.size());
            if (addedReferences.size() > 0) {
                addedReferencesDiffs.addAll(this.createNewReferencesOperation(root, leftElement, rightElement, reference, addedReferences));
            }
            if (deletedReferences.size() > 0) {
                removedReferencesDiffs.addAll(this.createRemovedReferencesOperation(root, leftElement, rightElement, reference, deletedReferences));
            }
            if (reference.isOrdered()) {
                this.checkReferenceOrderChange(root, reference, leftElement, rightElement, addedReferencesDiffs, removedReferencesDiffs);
            }
        }
    }

    private void createRemoteReferencesUpdate(DiffGroup root, EReference reference, Match3Elements mapping, List<EObject> remotelyAdded, List<EObject> remotelyDeleted) {
        if (!(reference.isMany() || remotelyAdded.size() <= 0 && remotelyDeleted.size() <= 0)) {
            EObject remoteAdded = null;
            if (remotelyAdded.size() > 0) {
                remoteAdded = remotelyAdded.get(0);
            }
            EObject remoteDeleted = null;
            if (remotelyDeleted.size() > 0) {
                remoteDeleted = remotelyDeleted.get(0);
            }
            UpdateReference operation = DiffFactory.eINSTANCE.createUpdateReference();
            operation.setRemote(true);
            operation.setLeftElement(mapping.getLeftElement());
            operation.setRightElement(mapping.getRightElement());
            operation.setReference(reference);
            EObject leftTarget = this.getMatchManager().getMatchedEObject(remoteAdded);
            EObject rightTarget = this.getMatchManager().getMatchedEObject(remoteDeleted);
            if (leftTarget == null && remoteAdded != null) {
                leftTarget = remoteAdded;
            }
            if (rightTarget == null && remoteDeleted != null) {
                rightTarget = remoteDeleted;
            }
            operation.setLeftTarget(leftTarget);
            operation.setRightTarget(rightTarget);
            root.getSubDiffElements().add((Object)operation);
        } else if (reference.isMany()) {
            for (EObject eobj : remotelyAdded) {
                ReferenceChangeRightTarget addOperation = DiffFactory.eINSTANCE.createReferenceChangeRightTarget();
                addOperation.setRemote(true);
                addOperation.setRightElement(mapping.getRightElement());
                addOperation.setLeftElement(mapping.getLeftElement());
                addOperation.setReference(reference);
                addOperation.setRightTarget(eobj);
                if (this.getMatchManager().getMatchedEObject(eobj) != null) {
                    addOperation.setLeftTarget(this.getMatchManager().getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)addOperation);
            }
            for (EObject eobj : remotelyDeleted) {
                ReferenceChangeLeftTarget delOperation = DiffFactory.eINSTANCE.createReferenceChangeLeftTarget();
                delOperation.setRemote(true);
                delOperation.setRightElement(mapping.getRightElement());
                delOperation.setLeftElement(mapping.getLeftElement());
                delOperation.setReference(reference);
                delOperation.setLeftTarget(eobj);
                if (this.getMatchManager().getMatchedEObject(eobj) != null) {
                    delOperation.setRightTarget(this.getMatchManager().getMatchedEObject(eobj));
                }
                root.getSubDiffElements().add((Object)delOperation);
            }
        }
    }

    private List<ReferenceChangeRightTarget> createRemovedReferencesOperation(DiffGroup root, EObject left, EObject right, EReference reference, List<EObject> deletedReferences) {
        ArrayList<ReferenceChangeRightTarget> result = new ArrayList<ReferenceChangeRightTarget>();
        for (EObject eobj : deletedReferences) {
            ReferenceChangeRightTarget delOperation = DiffFactory.eINSTANCE.createReferenceChangeRightTarget();
            delOperation.setRightElement(right);
            delOperation.setLeftElement(left);
            delOperation.setReference(reference);
            delOperation.setRightTarget(eobj);
            if (this.getMatchManager().getMatchedEObject(eobj) != null) {
                delOperation.setLeftTarget(this.getMatchManager().getMatchedEObject(eobj));
            }
            root.getSubDiffElements().add((Object)delOperation);
            result.add(delOperation);
        }
        return result;
    }

    private UpdateReference createUpdatedReferenceOperation(EObject left, EObject right, EReference reference, EObject addedValue, EObject deletedValue) {
        UpdateReference operation = DiffFactory.eINSTANCE.createUpdateReference();
        operation.setLeftElement(left);
        operation.setRightElement(right);
        operation.setReference(reference);
        EObject leftTarget = this.getMatchManager().getMatchedEObject(deletedValue);
        EObject rightTarget = this.getMatchManager().getMatchedEObject(addedValue);
        if (leftTarget == null && deletedValue != null) {
            leftTarget = deletedValue;
        }
        if (rightTarget == null && addedValue != null) {
            rightTarget = addedValue;
        }
        operation.setLeftTarget(leftTarget);
        operation.setRightTarget(rightTarget);
        return operation;
    }

    private List<EObject> getMatchedReferences(List<EObject> references) {
        ArrayList<EObject> matchedReferences = new ArrayList<EObject>();
        for (EObject currentReference : references) {
            EObject currentMapped;
            if (currentReference == null || (currentMapped = this.getMatchManager().getMatchedEObject(currentReference)) == null) continue;
            matchedReferences.add(currentMapped);
        }
        return matchedReferences;
    }

    private boolean isConflictual(EReference reference, List<?> leftReferences, List<?> rightReferences, List<?> ancestorReferences) {
        boolean isConflictual = false;
        if (!reference.isMany()) {
            if (leftReferences.size() != ancestorReferences.size() && rightReferences.size() != ancestorReferences.size()) {
                if (leftReferences.size() > 0 && !leftReferences.get(0).equals(this.getMatchManager().getMatchedEObject((EObject)rightReferences.get(0)))) {
                    isConflictual = true;
                }
            } else if (!(leftReferences.size() <= 0 || rightReferences.size() <= 0 || leftReferences.get(0).equals(this.getMatchManager().getMatchedEObject((EObject)ancestorReferences.get(0), IMatchManager.MatchSide.LEFT)) || rightReferences.get(0).equals(this.getMatchManager().getMatchedEObject((EObject)ancestorReferences.get(0), IMatchManager.MatchSide.RIGHT)) || rightReferences.get(0).equals(this.getMatchManager().getMatchedEObject((EObject)leftReferences.get(0))))) {
                isConflictual = true;
            }
        }
        return isConflictual;
    }

    private void populateThreeWayReferencesChanges(Match3Elements mapping, EReference reference, List<EObject> addedReferences, List<EObject> deletedReferences, List<EObject> remoteAddedReferences, List<EObject> remoteDeletedReferences) throws FactoryException {
        String referenceName = reference.getName();
        List<Object> leftReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)referenceName));
        List<Object> rightReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)referenceName));
        List<Object> ancestorReferences = this.convertFeatureMapList(org.eclipse.emf.compare.util.EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)referenceName));
        ArrayList<Object> leftCopy = new ArrayList<Object>(leftReferences);
        ArrayList<Object> ancestorCopy = new ArrayList<Object>(ancestorReferences);
        for (Object right : rightReferences) {
            EObject leftMatched = null;
            EObject ancestorMatched = null;
            boolean hasLeftMatch = false;
            boolean hasAncestorMatch = false;
            if (right instanceof EObject && !((EObject)right).eIsProxy()) {
                ancestorMatched = this.getMatchManager().getMatchedEObject((EObject)right, IMatchManager.MatchSide.ANCESTOR);
                leftMatched = this.getMatchManager().getMatchedEObject((EObject)right);
                hasLeftMatch = leftMatched != null && leftCopy.contains(leftMatched);
                hasAncestorMatch = ancestorMatched != null && ancestorCopy.contains(ancestorMatched);
            } else if (right instanceof EObject && ((EObject)right).eIsProxy()) {
                Iterator ancestorIterator = ancestorCopy.iterator();
                while (ancestorMatched == null && ancestorIterator.hasNext()) {
                    Object ancestor = ancestorIterator.next();
                    if (this.areDistinct((EObject)right, (EObject)ancestor)) continue;
                    ancestorMatched = (EObject)ancestor;
                }
                Iterator leftIterator = leftCopy.iterator();
                while (leftMatched == null && leftIterator.hasNext()) {
                    Object left = leftIterator.next();
                    if (this.areDistinct((EObject)right, (EObject)left)) continue;
                    leftMatched = (EObject)left;
                }
                hasLeftMatch = leftMatched != null;
                boolean bl = hasAncestorMatch = ancestorMatched != null;
            }
            if (!hasLeftMatch && !hasAncestorMatch) {
                remoteAddedReferences.add((EObject)right);
            } else if (!hasLeftMatch) {
                deletedReferences.add((EObject)right);
            }
            if (leftMatched != null) {
                leftCopy.remove(leftMatched);
            }
            if (ancestorMatched == null) continue;
            ancestorCopy.remove(ancestorMatched);
        }
        ArrayList<Object> rightCopy = new ArrayList<Object>(rightReferences);
        ancestorCopy = new ArrayList<Object>(ancestorReferences);
        for (Object left : leftReferences) {
            EObject rightMatched = null;
            EObject ancestorMatched = null;
            boolean hasRightMatch = false;
            boolean hasAncestorMatch = false;
            if (left instanceof EObject && !((EObject)left).eIsProxy()) {
                ancestorMatched = this.getMatchManager().getMatchedEObject((EObject)left, IMatchManager.MatchSide.ANCESTOR);
                rightMatched = this.getMatchManager().getMatchedEObject((EObject)left);
                hasRightMatch = rightMatched != null && rightCopy.contains(rightMatched);
                hasAncestorMatch = ancestorMatched != null && ancestorCopy.contains(ancestorMatched);
            } else if (left instanceof EObject && ((EObject)left).eIsProxy()) {
                Iterator ancestorIterator = ancestorCopy.iterator();
                while (ancestorMatched == null && ancestorIterator.hasNext()) {
                    Object ancestor = ancestorIterator.next();
                    if (this.areDistinct((EObject)left, (EObject)ancestor)) continue;
                    ancestorMatched = (EObject)ancestor;
                }
                Iterator rightIterator = rightCopy.iterator();
                while (rightMatched == null && rightIterator.hasNext()) {
                    Object right = rightIterator.next();
                    if (this.areDistinct((EObject)left, (EObject)right)) continue;
                    rightMatched = (EObject)right;
                }
                hasRightMatch = rightMatched != null;
                boolean bl = hasAncestorMatch = ancestorMatched != null;
            }
            if (!hasRightMatch && !hasAncestorMatch) {
                addedReferences.add((EObject)left);
            } else if (!hasRightMatch) {
                remoteDeletedReferences.add((EObject)left);
            }
            if (rightMatched != null) {
                leftCopy.remove(rightMatched);
            }
            if (ancestorMatched == null) continue;
            ancestorCopy.remove(ancestorMatched);
        }
    }
}

