/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffReferenceUtil {
    private DiffReferenceUtil() {
    }

    public static List<EStructuralFeature> getCopiableReferences(EObject eObject) {
        EClass eClass = eObject.eClass();
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        int j = 0;
        while (j < eClass.getFeatureCount()) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && (DiffReferenceUtil.isSimpleReference(eStructuralFeature) || DiffReferenceUtil.isFeatureMap(eStructuralFeature))) {
                result.add(eStructuralFeature);
            }
            ++j;
        }
        return result;
    }

    public static boolean isSimpleReference(EStructuralFeature feature) {
        return feature instanceof EReference && !((EReference)feature).isContainment() && !((EReference)feature).isContainer();
    }

    public static boolean isFeatureMap(EStructuralFeature feature) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
    }

    private static Set<EObject> getReferencedEObject(EObject eObject, EStructuralFeature feature, boolean resolveProxies) {
        LinkedHashSet<EObject> result;
        block8: {
            block6: {
                Object obj;
                block7: {
                    result = new LinkedHashSet<EObject>();
                    if (!DiffReferenceUtil.isSimpleReference(feature)) break block6;
                    obj = eObject.eGet(feature, resolveProxies);
                    if (!(obj instanceof EObject)) break block7;
                    result.add((EObject)obj);
                    break block8;
                }
                if (!(obj instanceof Collection)) break block8;
                result.addAll((Collection)obj);
                break block8;
            }
            if (DiffReferenceUtil.isFeatureMap(feature)) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet(feature);
                int k = 0;
                while (k < featureMap.size()) {
                    EStructuralFeature f = featureMap.getEStructuralFeature(k);
                    if (f instanceof EReference) {
                        Object referencedEObject = featureMap.getValue(k);
                        if (referencedEObject instanceof EObject) {
                            result.add((EObject)referencedEObject);
                        } else if (referencedEObject instanceof Collection) {
                            result.addAll((Collection)referencedEObject);
                        }
                    }
                    ++k;
                }
            }
        }
        return result;
    }

    public static Set<EObject> getReferencedEObjects(EObject eObject, boolean resolveProxies) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        for (EStructuralFeature feature : DiffReferenceUtil.getCopiableReferences(eObject)) {
            result.addAll(DiffReferenceUtil.getReferencedEObject(eObject, feature, resolveProxies));
        }
        TreeIterator children = eObject.eAllContents();
        while (children.hasNext()) {
            EObject child = (EObject)children.next();
            result.addAll(DiffReferenceUtil.getReferencedEObjects(child, resolveProxies));
        }
        return result;
    }
}

