/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.compare.logical.extension.IModelResolver;
import org.eclipse.emf.compare.util.ModelIdentifier;

public class ModelResolverDescriptor {
    public static final String MODEL_RESOLVER_CLASS_ATTRIBUTE = "class";
    public static final String MODEL_RESOLVER_FILE_EXTENSION_TAG = "fileExtension";
    public static final String MODEL_RESOLVER_CONTENT_TYPE_TAG = "contentType";
    public static final String MODEL_RESOLVER_NAMESPACE_TAG = "namespace";
    public static final String ENABLEMENT_TAG_VALUE = "value";
    public static final String EXTENSIONS_WILDCARD = "*";
    public static final String VALUE_SEPARATOR = ",";
    private final IConfigurationElement element;
    private final String extensionClassName;
    private final String contentType;
    private final String fileExtension;
    private final String namespace;
    private IModelResolver modelResolver;

    public ModelResolverDescriptor(IConfigurationElement element) {
        this.element = element;
        this.extensionClassName = element.getAttribute(MODEL_RESOLVER_CLASS_ATTRIBUTE);
        IConfigurationElement[] contentTypeConfig = element.getChildren(MODEL_RESOLVER_CONTENT_TYPE_TAG);
        this.contentType = contentTypeConfig.length > 0 ? contentTypeConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
        IConfigurationElement[] fileExtensionConfig = element.getChildren(MODEL_RESOLVER_FILE_EXTENSION_TAG);
        this.fileExtension = fileExtensionConfig.length > 0 ? fileExtensionConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
        IConfigurationElement[] namespaceConfig = element.getChildren(MODEL_RESOLVER_NAMESPACE_TAG);
        this.namespace = namespaceConfig.length > 0 ? namespaceConfig[0].getAttribute(ENABLEMENT_TAG_VALUE) : null;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public IModelResolver getModelResolver() {
        if (this.modelResolver == null) {
            try {
                this.modelResolver = (IModelResolver)this.element.createExecutableExtension(MODEL_RESOLVER_CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.modelResolver;
    }

    public boolean canResolve(ModelIdentifier identifier) {
        boolean canResolve;
        block5: {
            String[] validNamespaces;
            block6: {
                block4: {
                    String[] validExtensions;
                    canResolve = false;
                    if (this.fileExtension == null) break block4;
                    String[] stringArray = validExtensions = this.fileExtension.split(VALUE_SEPARATOR);
                    int n = validExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String validExtension = stringArray[n2];
                        canResolve = identifier.getExtension().equals(validExtension.trim()) || EXTENSIONS_WILDCARD.equals(validExtension.trim());
                        ++n2;
                    }
                    break block5;
                }
                if (this.contentType == null) break block6;
                String[] validContentTypes = this.contentType.split(VALUE_SEPARATOR);
                IContentTypeManager ctManager = Platform.getContentTypeManager();
                int i = 0;
                while (i < validContentTypes.length && !canResolve) {
                    IContentType expected = ctManager.getContentType(validContentTypes[i].trim());
                    IContentType actual = ctManager.getContentType(identifier.getContentType());
                    if (expected != null && actual != null) {
                        canResolve = actual.isKindOf(expected);
                    }
                    ++i;
                }
                break block5;
            }
            if (this.namespace == null) break block5;
            String[] stringArray = validNamespaces = this.namespace.split(VALUE_SEPARATOR);
            int n = validNamespaces.length;
            int n3 = 0;
            while (n3 < n) {
                String validNamespace = stringArray[n3];
                canResolve = identifier.getNamespace().matches(validNamespace.trim());
                ++n3;
            }
        }
        return canResolve;
    }
}

