/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.logical.extension;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ModelResourceVisitor
implements IResourceVisitor {
    private static final String[] MODEL_CONTENT_TYPES = new String[]{"org.eclipse.emf.compare.ui.contenttype.ModelContentType", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi"};
    private final ResourceSet resourceSet;

    public ModelResourceVisitor(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            boolean isModel = false;
            String[] stringArray = MODEL_CONTENT_TYPES;
            int n = MODEL_CONTENT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                if (this.hasContentType(file, contentType)) {
                    isModel = true;
                }
                ++n2;
            }
            if (isModel) {
                try {
                    EclipseModelUtils.getResource((IFile)file, (ResourceSet)this.resourceSet);
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasContentType(IFile resource, String contentTypeId) {
        IContentType[] contentTypes;
        IContentType expected;
        block21: {
            IContentTypeManager ctManager = Platform.getContentTypeManager();
            expected = ctManager.getContentType(contentTypeId);
            if (expected == null) {
                return false;
            }
            InputStream resourceContent = null;
            contentTypes = null;
            try {
                resourceContent = resource.getContents();
                contentTypes = ctManager.findContentTypesFor(resourceContent, resource.getName());
            }
            catch (CoreException e) {
                ctManager.findContentTypesFor(resource.getName());
                if (resourceContent != null) {
                    try {
                        resourceContent.close();
                    }
                    catch (IOException iOException) {}
                }
                break block21;
            }
            catch (IOException e) {
                try {
                    ctManager.findContentTypesFor(resource.getName());
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (resourceContent != null) {
                        try {
                            resourceContent.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (resourceContent == null) break block21;
            try {
                resourceContent.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean hasContentType = false;
        if (contentTypes != null) {
            int i = 0;
            while (i < contentTypes.length && !hasContentType) {
                if (contentTypes[i].isKindOf(expected)) {
                    hasContentType = true;
                }
                ++i;
            }
        }
        return hasContentType;
    }
}

