/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.transform.impl.MergeChangesCompare;
import org.eclipse.emf.compare.mpatch.transform.impl.MergeChangesGeneralizer;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.compare.mpatch.util.MPatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeChanges
implements IMPatchTransformation {
    public static final String LABEL = "Merge Similar Changes";
    private static final String DESCRIPTION = "This transformation looks for similar changes and merges them into generalized changes. This is an optional transformation and might change the result of MPatch application!\n\nIf the MPatch contains multiple changes of the same type describing the same change but for several model elements, this transformation will merge them into a single, generalized change. The cardinality of a generalized change will be set to [1..n], with n being the number of changes it was created from. If the result should be applicable to another number of element, perform 'Unbound Symbolic References' afterwards.\nCondition-based Symbolic References are required!";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 30;
    }

    public boolean isOptional() {
        return true;
    }

    public int transform(MPatchModel mpatch) {
        return MergeChanges.mergeChanges(mpatch);
    }

    public static int mergeChanges(MPatchModel mpatch) {
        Collection<List<IndepChange>> typedChanges = MergeChanges.getTypedChanges(mpatch);
        List<List<IndepChange>> filteredChanges = MergeChanges.filterTypedChanges(typedChanges);
        Map<IndepChange, List<IndepChange>> generalizedChanges = MergeChanges.generalizeChanges(filteredChanges);
        int successfulReplacements = MergeChanges.replaceChanges(mpatch, generalizedChanges);
        return successfulReplacements;
    }

    private static int replaceChanges(MPatchModel mpatch, Map<IndepChange, List<IndepChange>> generalizedChanges) {
        ChangeGroup group = MPatchFactory.eINSTANCE.createChangeGroup();
        HashSet<ChangeGroup> oldGroups = new HashSet<ChangeGroup>();
        int counter = 0;
        for (IndepChange generalizedChange : generalizedChanges.keySet()) {
            List<IndepChange> changes = generalizedChanges.get(generalizedChange);
            MergeChanges.addGeneralizedChange(mpatch, generalizedChange, changes, group);
            MergeChanges.updateDependencies(generalizedChange, changes, mpatch);
            MergeChanges.deleteElements(changes, oldGroups);
            ++counter;
        }
        if (!group.getSubChanges().isEmpty()) {
            mpatch.getChanges().add((Object)group);
        }
        for (ChangeGroup changeGroup : oldGroups) {
            if (!changeGroup.getSubChanges().isEmpty()) continue;
            EcoreUtil.delete((EObject)changeGroup);
        }
        return counter;
    }

    private static void updateDependencies(IndepChange generalizedChange, List<IndepChange> changes, MPatchModel mpatch) {
        for (IndepChange change : changes) {
            generalizedChange.getDependants().addAll((Collection)change.getDependants());
            generalizedChange.getDependsOn().addAll((Collection)change.getDependsOn());
            List flattenedChange = ExtEcoreUtils.flattenEObjects(Collections.singleton(change));
            Map crossReferences = EcoreUtil.UsageCrossReferencer.findAll((Collection)flattenedChange, (EObject)mpatch);
            Map match = null;
            for (EObject oldTarget : crossReferences.keySet()) {
                for (EStructuralFeature.Setting setting : (Collection)crossReferences.get(oldTarget)) {
                    EObject newTarget;
                    EStructuralFeature feature = setting.getEStructuralFeature();
                    EObject owner = setting.getEObject();
                    if (feature == null || feature.isDerived() || !feature.isChangeable() || MPatchPackage.Literals.INDEP_CHANGE__DEPENDANTS.equals(feature) || MPatchPackage.Literals.INDEP_CHANGE__DEPENDS_ON.equals(feature)) continue;
                    if (match == null) {
                        match = CommonUtils.getMatchingObjects((EObject)change, (EObject)generalizedChange);
                    }
                    if ((newTarget = (EObject)match.get(oldTarget)) == null) {
                        throw new IllegalStateException("We should ALWAYS get a match here since generalized is a COPY of change!!!");
                    }
                    MergeChanges.updateReference(owner, feature, oldTarget, newTarget);
                }
            }
        }
    }

    private static void updateReference(EObject owner, EStructuralFeature feature, EObject oldTarget, EObject newTarget) {
        EcoreUtil.remove((EObject)owner, (EStructuralFeature)feature, (Object)oldTarget);
        if (feature.isMany()) {
            List list = (List)owner.eGet(feature);
            list.add(newTarget);
            if (!list.contains(newTarget)) {
                throw new RuntimeException("Could not move reference to merged change! Feature: " + feature.getName() + ", owner: " + owner);
            }
        } else {
            owner.eSet(feature, (Object)newTarget);
        }
    }

    private static void deleteElements(List<? extends EObject> elements, Set<ChangeGroup> groups) {
        for (EObject eObject : elements) {
            if (eObject.eContainer() != null && eObject.eContainer() instanceof ChangeGroup) {
                groups.add((ChangeGroup)eObject.eContainer());
            }
            EcoreUtil.delete((EObject)eObject, (boolean)true);
        }
    }

    private static void addGeneralizedChange(MPatchModel mpatch, IndepChange generalizedChange, List<IndepChange> changes, ChangeGroup group) {
        EObject parent = null;
        for (IndepChange indepChange : changes) {
            if (indepChange.eContainer() == null) {
                throw new IllegalStateException("Change is not contained anywhere! " + indepChange);
            }
            if (parent == null) {
                parent = indepChange.eContainer();
                continue;
            }
            if (parent.equals(indepChange.eContainer())) continue;
            parent = null;
            break;
        }
        if (parent instanceof ChangeGroup) {
            ChangeGroup commonGroup = (ChangeGroup)parent;
            commonGroup.getSubChanges().add((Object)generalizedChange);
        } else if (mpatch.equals(parent)) {
            mpatch.getChanges().add((Object)generalizedChange);
        } else {
            group.getSubChanges().add((Object)generalizedChange);
        }
    }

    private static List<List<IndepChange>> filterTypedChanges(Collection<List<IndepChange>> typedChanges) {
        ArrayList<List<IndepChange>> filteredChanges = new ArrayList<List<IndepChange>>();
        for (List<IndepChange> list : typedChanges) {
            List<List<IndepChange>> filteredList = MergeChanges.filterChanges(list);
            if (filteredList == null) continue;
            int i = filteredList.size() - 1;
            while (i >= 0) {
                if (filteredList.get(i) == null || filteredList.get(i).size() <= 1) {
                    filteredList.remove(i);
                }
                --i;
            }
            if (filteredList.isEmpty()) continue;
            filteredChanges.addAll(filteredList);
        }
        return filteredChanges;
    }

    public static List<List<IndepChange>> filterChanges(List<IndepChange> list) {
        ArrayList<List<IndepChange>> result = new ArrayList<List<IndepChange>>();
        block0: for (IndepChange change : list) {
            for (List<IndepChange> filtered : result) {
                IndepChange otherChange = filtered.get(0);
                if (!MergeChangesCompare.generalizable(change, otherChange)) continue;
                filtered.add(change);
                continue block0;
            }
            ArrayList<IndepChange> group = new ArrayList<IndepChange>();
            group.add(change);
            result.add(group);
        }
        return result;
    }

    private static Collection<List<IndepChange>> getTypedChanges(MPatchModel mpatch) {
        LinkedHashMap<EClass, List<IndepChange>> typedChanges = new LinkedHashMap<EClass, List<IndepChange>>();
        MergeChanges.collectedTypedChanges((EList<IndepChange>)mpatch.getChanges(), typedChanges);
        return typedChanges.values();
    }

    private static void collectedTypedChanges(EList<IndepChange> changes, Map<EClass, List<IndepChange>> typedChanges) {
        for (IndepChange change : changes) {
            if (change instanceof ChangeGroup) {
                MergeChanges.collectedTypedChanges((EList<IndepChange>)((ChangeGroup)change).getSubChanges(), typedChanges);
                continue;
            }
            MPatchUtil.addElementToListMap((Object)change.eClass(), (Object)change, typedChanges);
        }
    }

    private static Map<IndepChange, List<IndepChange>> generalizeChanges(List<List<IndepChange>> filteredChanges) {
        LinkedHashMap<IndepChange, List<IndepChange>> generalizedChanges = new LinkedHashMap<IndepChange, List<IndepChange>>();
        for (List<IndepChange> changes : filteredChanges) {
            IndepChange generalizedChange = MergeChangesGeneralizer.generalizeChanges(changes);
            if (generalizedChange == null) continue;
            generalizedChanges.put(generalizedChange, changes);
        }
        return generalizedChanges;
    }
}

