/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.group.IDifferenceGroupingFacility;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureMergeViewer;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureViewer
extends ParameterizedStructureMergeViewer {
    protected List<IDifferenceFilter> differenceFilters;
    protected IDifferenceGroupingFacility differenceGroupingFacility;

    public StructureViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(parent, compareConfiguration);
    }

    public StructureViewer(Composite parent, CompareConfiguration compareConfiguration, List<IDifferenceFilter> filters, IDifferenceGroupingFacility groupingFacility) {
        super(parent, compareConfiguration);
        this.setDifferenceFilters(filters);
        this.setDifferenceGroupingFacility(groupingFacility);
    }

    @Override
    protected void createToolItems() {
    }

    @Override
    protected void updateToolItems() {
    }

    @Override
    protected ParameterizedStructureContentProvider buildContentProvider(CompareConfiguration compareConfiguration) {
        return new ParameterizedStructureContentProvider(compareConfiguration, this.differenceGroupingFacility, this.differenceFilters);
    }

    @Override
    protected ModelStructureContentProvider createContentProvider(CompareConfiguration compareConfiguration) {
        return this.buildContentProvider(compareConfiguration);
    }

    public void setDifferenceFilters(List<IDifferenceFilter> filters) {
        if (this.differenceFilters == null || !this.differenceFilters.equals(filters)) {
            this.differenceFilters = filters;
            ((ParameterizedStructureContentProvider)this.getContentProvider()).setSelectedFilters(filters);
            this.refresh();
        }
    }

    public void setDifferenceGroupingFacility(IDifferenceGroupingFacility groupingFacility) {
        if (this.differenceGroupingFacility == null || !this.differenceGroupingFacility.equals(groupingFacility)) {
            this.differenceGroupingFacility = groupingFacility;
            ((ParameterizedStructureContentProvider)this.getContentProvider()).setSelectedGroup(groupingFacility);
            this.refresh();
        }
    }

    public List<IDifferenceFilter> getDifferenceFilters() {
        return this.differenceFilters;
    }

    public IDifferenceGroupingFacility getDifferenceGroupingFacility() {
        return this.differenceGroupingFacility;
    }
}

