/*******************************************************************************
 * Copyright (c) 2006, 2011 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.compare.diff.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.diff.metamodel.util.DiffAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!-- end-user-doc -->
 * @generated
 */
public class DiffItemProviderAdapterFactory extends DiffAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.AttributeChange} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected AttributeChangeItemProvider attributeChangeItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeChangeLeftTargetItemProvider attributeChangeLeftTargetItemProvider;

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AttributeChangeRightTargetItemProvider attributeChangeRightTargetItemProvider;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ConflictingDiffElementItemProvider conflictingDiffElementItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.DiffGroup} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected DiffGroupItemProvider diffGroupItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.DiffModel} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected DiffModelItemProvider diffModelItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelElementChangeItemProvider modelElementChangeItemProvider;

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ModelElementChangeLeftTargetItemProvider modelElementChangeLeftTargetItemProvider;

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ModelElementChangeRightTargetItemProvider modelElementChangeRightTargetItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.MoveModelElement} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected MoveModelElementItemProvider moveModelElementItemProvider;

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChange} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected ReferenceChangeItemProvider referenceChangeItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceChangeLeftTargetItemProvider referenceChangeLeftTargetItemProvider;

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ReferenceChangeRightTargetItemProvider referenceChangeRightTargetItemProvider;

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.UpdateAttribute} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected UpdateAttributeItemProvider updateAttributeItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.UpdateModelElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UpdateModelElementItemProvider updateModelElementItemProvider;

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.UpdateReference} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected UpdateReferenceItemProvider updateReferenceItemProvider;

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DiffItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.AttributeChange}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAttributeChangeAdapter() {
		if (attributeChangeItemProvider == null) {
			attributeChangeItemProvider = new AttributeChangeItemProvider(this);
		}

		return attributeChangeItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeChangeLeftTargetAdapter() {
		if (attributeChangeLeftTargetItemProvider == null) {
			attributeChangeLeftTargetItemProvider = new AttributeChangeLeftTargetItemProvider(this);
		}

		return attributeChangeLeftTargetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeChangeRightTargetAdapter() {
		if (attributeChangeRightTargetItemProvider == null) {
			attributeChangeRightTargetItemProvider = new AttributeChangeRightTargetItemProvider(this);
		}

		return attributeChangeRightTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @since 1.3
	 */
	protected AttributeOrderChangeItemProvider attributeOrderChangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeOrderChangeAdapter() {
		if (attributeOrderChangeItemProvider == null) {
			attributeOrderChangeItemProvider = new AttributeOrderChangeItemProvider(this);
		}

		return attributeOrderChangeItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConflictingDiffElementAdapter() {
		if (conflictingDiffElementItemProvider == null) {
			conflictingDiffElementItemProvider = new ConflictingDiffElementItemProvider(this);
		}

		return conflictingDiffElementItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.DiffGroup}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDiffGroupAdapter() {
		if (diffGroupItemProvider == null) {
			diffGroupItemProvider = new DiffGroupItemProvider(this);
		}

		return diffGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComparisonResourceSnapshotItemProvider comparisonResourceSnapshotItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComparisonResourceSnapshotAdapter() {
		if (comparisonResourceSnapshotItemProvider == null) {
			comparisonResourceSnapshotItemProvider = new ComparisonResourceSnapshotItemProvider(this);
		}

		return comparisonResourceSnapshotItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComparisonResourceSetSnapshotItemProvider comparisonResourceSetSnapshotItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComparisonResourceSetSnapshotAdapter() {
		if (comparisonResourceSetSnapshotItemProvider == null) {
			comparisonResourceSetSnapshotItemProvider = new ComparisonResourceSetSnapshotItemProvider(this);
		}

		return comparisonResourceSetSnapshotItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.DiffModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDiffModelAdapter() {
		if (diffModelItemProvider == null) {
			diffModelItemProvider = new DiffModelItemProvider(this);
		}

		return diffModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.DiffResourceSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiffResourceSetItemProvider diffResourceSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.DiffResourceSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDiffResourceSetAdapter() {
		if (diffResourceSetItemProvider == null) {
			diffResourceSetItemProvider = new DiffResourceSetItemProvider(this);
		}

		return diffResourceSetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChange}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createModelElementChangeAdapter() {
		if (modelElementChangeItemProvider == null) {
			modelElementChangeItemProvider = new ModelElementChangeItemProvider(this);
		}

		return modelElementChangeItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelElementChangeLeftTargetAdapter() {
		if (modelElementChangeLeftTargetItemProvider == null) {
			modelElementChangeLeftTargetItemProvider = new ModelElementChangeLeftTargetItemProvider(this);
		}

		return modelElementChangeLeftTargetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelElementChangeRightTargetAdapter() {
		if (modelElementChangeRightTargetItemProvider == null) {
			modelElementChangeRightTargetItemProvider = new ModelElementChangeRightTargetItemProvider(this);
		}

		return modelElementChangeRightTargetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.MoveModelElement}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMoveModelElementAdapter() {
		if (moveModelElementItemProvider == null) {
			moveModelElementItemProvider = new MoveModelElementItemProvider(this);
		}

		return moveModelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.UpdateContainmentFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UpdateContainmentFeatureItemProvider updateContainmentFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.UpdateContainmentFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUpdateContainmentFeatureAdapter() {
		if (updateContainmentFeatureItemProvider == null) {
			updateContainmentFeatureItemProvider = new UpdateContainmentFeatureItemProvider(this);
		}

		return updateContainmentFeatureItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChange}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createReferenceChangeAdapter() {
		if (referenceChangeItemProvider == null) {
			referenceChangeItemProvider = new ReferenceChangeItemProvider(this);
		}

		return referenceChangeItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceChangeLeftTargetAdapter() {
		if (referenceChangeLeftTargetItemProvider == null) {
			referenceChangeLeftTargetItemProvider = new ReferenceChangeLeftTargetItemProvider(this);
		}

		return referenceChangeLeftTargetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceChangeRightTargetAdapter() {
		if (referenceChangeRightTargetItemProvider == null) {
			referenceChangeRightTargetItemProvider = new ReferenceChangeRightTargetItemProvider(this);
		}

		return referenceChangeRightTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ResourceDiff} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDiffItemProvider resourceDiffItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ResourceDiff}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDiffAdapter() {
		if (resourceDiffItemProvider == null) {
			resourceDiffItemProvider = new ResourceDiffItemProvider(this);
		}

		return resourceDiffItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDependencyChangeItemProvider resourceDependencyChangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDependencyChangeAdapter() {
		if (resourceDependencyChangeItemProvider == null) {
			resourceDependencyChangeItemProvider = new ResourceDependencyChangeItemProvider(this);
		}

		return resourceDependencyChangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChangeLeftTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDependencyChangeLeftTargetItemProvider resourceDependencyChangeLeftTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChangeLeftTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDependencyChangeLeftTargetAdapter() {
		if (resourceDependencyChangeLeftTargetItemProvider == null) {
			resourceDependencyChangeLeftTargetItemProvider = new ResourceDependencyChangeLeftTargetItemProvider(
					this);
		}

		return resourceDependencyChangeLeftTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChangeRightTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDependencyChangeRightTargetItemProvider resourceDependencyChangeRightTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChangeRightTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDependencyChangeRightTargetAdapter() {
		if (resourceDependencyChangeRightTargetItemProvider == null) {
			resourceDependencyChangeRightTargetItemProvider = new ResourceDependencyChangeRightTargetItemProvider(
					this);
		}

		return resourceDependencyChangeRightTargetItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.UpdateAttribute}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUpdateAttributeAdapter() {
		if (updateAttributeItemProvider == null) {
			updateAttributeItemProvider = new UpdateAttributeItemProvider(this);
		}

		return updateAttributeItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.UpdateModelElement}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUpdateModelElementAdapter() {
		if (updateModelElementItemProvider == null) {
			updateModelElementItemProvider = new UpdateModelElementItemProvider(this);
		}

		return updateModelElementItemProvider;
	}

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.UpdateReference}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUpdateReferenceAdapter() {
		if (updateReferenceItemProvider == null) {
			updateReferenceItemProvider = new UpdateReferenceItemProvider(this);
		}

		return updateReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceOrderChangeItemProvider referenceOrderChangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceOrderChangeAdapter() {
		if (referenceOrderChangeItemProvider == null) {
			referenceOrderChangeItemProvider = new ReferenceOrderChangeItemProvider(this);
		}

		return referenceOrderChangeItemProvider;
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (diffModelItemProvider != null)
			diffModelItemProvider.dispose();
		if (diffResourceSetItemProvider != null)
			diffResourceSetItemProvider.dispose();
		if (conflictingDiffElementItemProvider != null)
			conflictingDiffElementItemProvider.dispose();
		if (diffGroupItemProvider != null)
			diffGroupItemProvider.dispose();
		if (comparisonResourceSnapshotItemProvider != null)
			comparisonResourceSnapshotItemProvider.dispose();
		if (comparisonResourceSetSnapshotItemProvider != null)
			comparisonResourceSetSnapshotItemProvider.dispose();
		if (modelElementChangeItemProvider != null)
			modelElementChangeItemProvider.dispose();
		if (modelElementChangeLeftTargetItemProvider != null)
			modelElementChangeLeftTargetItemProvider.dispose();
		if (modelElementChangeRightTargetItemProvider != null)
			modelElementChangeRightTargetItemProvider.dispose();
		if (updateModelElementItemProvider != null)
			updateModelElementItemProvider.dispose();
		if (moveModelElementItemProvider != null)
			moveModelElementItemProvider.dispose();
		if (updateContainmentFeatureItemProvider != null)
			updateContainmentFeatureItemProvider.dispose();
		if (attributeChangeItemProvider != null)
			attributeChangeItemProvider.dispose();
		if (attributeChangeLeftTargetItemProvider != null)
			attributeChangeLeftTargetItemProvider.dispose();
		if (attributeChangeRightTargetItemProvider != null)
			attributeChangeRightTargetItemProvider.dispose();
		if (attributeOrderChangeItemProvider != null)
			attributeOrderChangeItemProvider.dispose();
		if (updateAttributeItemProvider != null)
			updateAttributeItemProvider.dispose();
		if (referenceChangeItemProvider != null)
			referenceChangeItemProvider.dispose();
		if (referenceChangeLeftTargetItemProvider != null)
			referenceChangeLeftTargetItemProvider.dispose();
		if (referenceChangeRightTargetItemProvider != null)
			referenceChangeRightTargetItemProvider.dispose();
		if (updateReferenceItemProvider != null)
			updateReferenceItemProvider.dispose();
		if (referenceOrderChangeItemProvider != null)
			referenceOrderChangeItemProvider.dispose();
		if (resourceDiffItemProvider != null)
			resourceDiffItemProvider.dispose();
		if (resourceDependencyChangeItemProvider != null)
			resourceDependencyChangeItemProvider.dispose();
		if (resourceDependencyChangeLeftTargetItemProvider != null)
			resourceDependencyChangeLeftTargetItemProvider.dispose();
		if (resourceDependencyChangeRightTargetItemProvider != null)
			resourceDependencyChangeRightTargetItemProvider.dispose();
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("hiding")
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

}
