/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.ui.viewer.content.part.property.ModelContentMergePropertyTab;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PropertyContentProvider
implements IStructuredContentProvider {
    private EObject inputEObject;
    private int partSide;

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = new Object[]{};
        if (inputElement instanceof Match2Elements) {
            Match2Elements match = (Match2Elements)inputElement;
            if (this.partSide == 1) {
                this.inputEObject = match.getLeftElement();
            } else if (this.partSide == 2) {
                this.inputEObject = match.getRightElement();
            } else if (inputElement instanceof Match3Elements) {
                this.inputEObject = ((Match3Elements)match).getOriginElement();
            }
        } else if (inputElement instanceof UnmatchElement) {
            this.inputEObject = ((UnmatchElement)inputElement).getElement();
        }
        if (this.inputEObject != null) {
            ArrayList inputElements = new ArrayList();
            AdapterFactory factory = AdapterUtils.getAdapterFactory();
            IItemPropertySource inputPropertySource = (IItemPropertySource)factory.adapt((Notifier)this.inputEObject, IItemPropertySource.class);
            for (IItemPropertyDescriptor descriptor : inputPropertySource.getPropertyDescriptors((Object)this.inputEObject)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature((Object)this.inputEObject);
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(feature);
                row.add(descriptor.getPropertyValue((Object)this.inputEObject));
                inputElements.add(row);
            }
            elements = inputElements.toArray();
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object first, Object second) {
                    String name1 = ((EStructuralFeature)((List)first).get(0)).getName();
                    String name2 = ((EStructuralFeature)((List)second).get(0)).getName();
                    return name1.compareTo(name2);
                }
            });
        }
        return elements;
    }

    public EObject getInputEObject() {
        return this.inputEObject;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && viewer instanceof ModelContentMergePropertyTab) {
            ModelContentMergePropertyTab properties = (ModelContentMergePropertyTab)viewer;
            properties.getTable().clearAll();
            this.partSide = properties.getSide();
        }
    }
}

