/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.menus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.menus.IContextualMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualMenuDescriptor {
    public static final String ID_PROPERTY = "id";
    public static final String CLASS_PROPERTY = "class";
    public static final String TARGET_CLASS_PROPERTY = "class";
    private final IConfigurationElement element;
    private final String id;
    private final String classname;
    private String targetClassName;
    private Class<?> targetClass;
    private IContextualMenu extension;

    public ContextualMenuDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.id = anElement.getAttribute(ID_PROPERTY);
        this.classname = anElement.getAttribute("class");
        IConfigurationElement[] children = anElement.getChildren();
        if (children.length > 0) {
            IConfigurationElement child = children[0];
            this.targetClassName = child.getAttribute("class");
        }
        ContextualMenuDescriptor.checks(this);
    }

    public String getID() {
        return this.id;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getTargetClassname() {
        return this.targetClassName;
    }

    public Class<?> getTargetClass() {
        if (this.targetClassName != null && this.targetClass == null) {
            try {
                this.targetClass = Platform.getBundle((String)this.element.getContributor().getName()).loadClass(this.targetClassName);
            }
            catch (ClassNotFoundException e) {
                EMFCompareUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ui", e.getMessage(), (Throwable)e));
            }
        }
        return this.targetClass;
    }

    private static void checks(ContextualMenuDescriptor descriptor) {
        if (descriptor.element == null) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ContextualMenuDescriptor.nullConfigurationElementException"));
        }
        if (ContextualMenuDescriptor.nullOrEmpty(descriptor.getID())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ContextualMenuDescriptor.missingMandatoryPropertyException", ID_PROPERTY));
        }
        if (ContextualMenuDescriptor.nullOrEmpty(descriptor.getClassname())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ContextualMenuDescriptor.missingMandatoryPropertyException", "class"));
        }
        if (ContextualMenuDescriptor.nullOrEmpty(descriptor.getTargetClassname())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("ContextualMenuDescriptor.missingMandatoryPropertyException", "class"));
        }
    }

    public IContextualMenu getExtension() {
        if (this.extension == null) {
            try {
                this.extension = (IContextualMenu)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                EMFCompareUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ui", e.getMessage(), (Throwable)e));
            }
        }
        return this.extension;
    }

    private static boolean nullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

