/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.wizards;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.Emfdiff2mpatchActivator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.AbstractEmfdiffExportWizard;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.wizards.EmfdiffExportWizardPage;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class EmfdiffExportWizard
extends AbstractEmfdiffExportWizard {
    private static final String MPATCH_ICON = "icons/mpatch.gif";
    private EmfdiffExportWizardPage page;
    private IFile file;

    protected void initializeDefaultPageImageDescriptor() {
        URL imageURL = Emfdiff2mpatchActivator.getDefault().getBundle().getEntry(MPATCH_ICON);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imageURL));
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        XMIResourceImpl output = new XMIResourceImpl(URI.createURI((String)this.page.createNewFile().getFullPath().toString()));
        output.getContents().add((Object)this.getMPatch());
        try {
            output.save(null);
        }
        catch (IOException e) {
            Emfdiff2mpatchActivator.getDefault().logError("Could not save MPatch file!", e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Failed to save file", (String)("The File could not be saved! Please see the error log for details.\nError message: " + e.getMessage()));
        }
        return true;
    }

    public void addPages() {
        String fileName = this.file == null ? "result.mpatch" : this.file.getName();
        this.page = new EmfdiffExportWizardPage("MPatch export", (IStructuredSelection)(this.file == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.file)));
        this.page.setTitle("MPatch");
        this.page.setDescription("Transforms emfdiff into MPatch.");
        this.page.setFileName(fileName);
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                if ("mpatch".equals(((IFile)obj).getFileExtension())) {
                    this.file = file;
                }
            }
            ++n2;
        }
    }
}

