/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EFactory {
    private EFactory() {
    }

    public static <T> void eAdd(EObject object, String name, T arg) throws FactoryException {
        EFactory.eAdd(object, name, arg, -1);
    }

    public static <T> void eAdd(EObject object, String name, T arg, int elementIndex) throws FactoryException {
        EFactory.eAdd(object, name, arg, elementIndex, false);
    }

    public static <T> void eAdd(EObject object, String name, T arg, int elementIndex, boolean reorder) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (feature.isMany() && arg != null) {
            Object manyValue = object.eGet(feature);
            if (manyValue instanceof InternalEList) {
                InternalEList internalEList = (InternalEList)manyValue;
                int listSize = internalEList.size();
                if (elementIndex > -1 && elementIndex < listSize) {
                    internalEList.addUnique(elementIndex, arg);
                } else {
                    internalEList.addUnique(arg);
                }
                if (reorder) {
                    EFactory.attachRealPositionEAdapter(arg, elementIndex);
                    EFactory.reorderList(internalEList);
                }
            } else if (manyValue instanceof List) {
                List list = (List)manyValue;
                int listSize = list.size();
                if (elementIndex > -1 && elementIndex < listSize) {
                    list.add(elementIndex, arg);
                } else {
                    list.add(arg);
                }
                if (reorder) {
                    EFactory.attachRealPositionEAdapter(arg, elementIndex);
                    EFactory.reorderList(list);
                }
            } else if (manyValue instanceof Collection) {
                ((Collection)manyValue).add(arg);
            }
        } else if (!feature.isMany()) {
            EFactory.eSet(object, name, arg);
        }
    }

    private static void attachRealPositionEAdapter(Object object, int expectedPosition) {
        if (object instanceof EObject) {
            ((EObject)object).eAdapters().add((Object)new PostionAdapter(expectedPosition));
        }
    }

    @Deprecated
    public static <T> void eInsertAt(EObject object, String name, T arg, int insertionIndex) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (feature.isMany()) {
            List target = (List)object.eGet(feature);
            int actualIndex = insertionIndex;
            if (insertionIndex < 0) {
                actualIndex = 0;
            } else if (insertionIndex > target.size()) {
                actualIndex = target.size();
            }
            if (arg != null) {
                target.add(actualIndex, arg);
            }
        } else {
            EFactory.eSet(object, name, arg);
        }
    }

    public static Object eGet(EObject object, String name) throws FactoryException {
        Object result = null;
        try {
            EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
            result = object.eGet(feature);
        }
        catch (FactoryException eGet) {
            try {
                result = EFactory.eCall(object, name, new Object[0]);
            }
            catch (FactoryException factoryException) {
                throw eGet;
            }
            catch (NullPointerException nullPointerException) {
                throw eGet;
            }
        }
        return result;
    }

    public static List<?> eGetAsList(EObject object, String name) throws FactoryException {
        BasicEList list = new ArrayList();
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            if (eGet instanceof List) {
                list = (List)eGet;
            } else {
                list = new BasicEList(1);
                list.add(eGet);
            }
        }
        return list;
    }

    public static String eGetAsString(EObject object, String name) throws FactoryException {
        Object eGet = EFactory.eGet(object, name);
        if (eGet != null) {
            return eGet.toString();
        }
        return null;
    }

    public static void eRemove(EObject object, String name, Object arg) throws FactoryException {
        Object list = object.eGet(EFactory.eStructuralFeature(object, name));
        if (list instanceof List) {
            if (arg != null) {
                ((List)list).remove(arg);
            }
        } else {
            EFactory.eSet(object, name, null);
        }
    }

    public static void eSet(EObject object, String name, Object arg) throws FactoryException {
        EStructuralFeature feature = EFactory.eStructuralFeature(object, name);
        if (!feature.isChangeable()) {
            throw new FactoryException(EMFCompareMessages.getString("EFactory.UnSettableFeature", name));
        }
        if (feature.getEType() instanceof EEnum && arg instanceof String) {
            EEnumLiteral literal = ((EEnum)feature.getEType()).getEEnumLiteral((String)arg);
            object.eSet(feature, (Object)literal);
        } else if (arg == null && feature.isMany()) {
            object.eSet(feature, (Object)Collections.EMPTY_LIST);
        } else if (arg == null) {
            object.eSet(feature, feature.getDefaultValue());
        } else {
            object.eSet(feature, arg);
        }
    }

    public static EStructuralFeature eStructuralFeature(EObject object, String name) throws FactoryException {
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(name);
        if (structuralFeature != null) {
            return structuralFeature;
        }
        throw new FactoryException(EMFCompareMessages.getString("EFactory.FeatureNotFound", name, object.eClass().getName()));
    }

    private static Object eCall(Object object, String name, Object ... arg) throws FactoryException {
        try {
            Class[] methodParams = new Class[arg.length];
            Object[] invocationParams = arg;
            int i = 0;
            while (i < arg.length) {
                methodParams[i] = arg[i].getClass();
                ++i;
            }
            Method method = object.getClass().getMethod(name, methodParams);
            return method.invoke(object, invocationParams);
        }
        catch (NoSuchMethodException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new FactoryException(e.getMessage());
        }
    }

    private static <T> void reorderList(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        List<T> copy = Collections.unmodifiableList(list);
        int i = 0;
        while (i < size) {
            T current = copy.get(i);
            if (current instanceof EObject) {
                int expectedIndex = -1;
                Iterator adapters = ((EObject)current).eAdapters().iterator();
                while (expectedIndex == -1 && adapters.hasNext()) {
                    Adapter adapter = (Adapter)adapters.next();
                    if (!(adapter instanceof PostionAdapter)) continue;
                    expectedIndex = ((PostionAdapter)adapter).getExpectedIndex();
                }
                if (expectedIndex != -1 && expectedIndex != i && expectedIndex <= size - 1) {
                    if (list instanceof InternalEList) {
                        ((InternalEList)list).move(expectedIndex, i);
                    } else {
                        list.add(expectedIndex, list.remove(i));
                    }
                }
            }
            ++i;
        }
    }

    private static class PostionAdapter
    extends AdapterImpl {
        private int expectedIndex;

        public PostionAdapter(int index) {
            this.expectedIndex = index;
        }

        public int getExpectedIndex() {
            return this.expectedIndex;
        }
    }
}

