/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.update;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.compare.match.update.Matcher;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierBasedMatcher
implements Matcher {
    private final Function<EObject, Object> idFunction;

    public IdentifierBasedMatcher(Function<EObject, Object> idFunction) {
        this.idFunction = (Function)Preconditions.checkNotNull(idFunction);
    }

    @Override
    public boolean areSameLogicalElement(EObject obj1, EObject obj2) {
        Object id1 = this.idFunction.apply((Object)((EObject)Preconditions.checkNotNull((Object)obj1)));
        Object id2 = this.idFunction.apply((Object)((EObject)Preconditions.checkNotNull((Object)obj2)));
        return Objects.equal((Object)id1, (Object)id2);
    }

    @Override
    public BiMap<EObject, EObject> computeMatches(Collection<EObject> values1, Collection<EObject> values2) {
        HashBiMap result = HashBiMap.create();
        Map<Object, EObject> matchingElements = this.computeIds(values2);
        for (EObject obj : values1) {
            Object id1 = this.idFunction.apply((Object)obj);
            EObject match = matchingElements.get(id1);
            if (match == null || !values2.contains(match)) continue;
            result.put((Object)obj, (Object)match);
        }
        return result;
    }

    private Map<Object, EObject> computeIds(Iterable<EObject> elements) {
        HashMap result = Maps.newHashMap();
        for (EObject obj : elements) {
            result.put(this.idFunction.apply((Object)obj), obj);
        }
        return result;
    }
}

