/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.mergeviewer;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.diagram.ui.mergeviewer.EditingDomainUtils;
import org.eclipse.emf.compare.diagram.ui.mergeviewer.GMFContentMergeTabFolder;
import org.eclipse.emf.compare.diagram.ui.viewmodel.NotationDiffCreator;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeContentProvider;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.ParameterizedContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFContentMergeViewer
extends ParameterizedContentMergeViewer {
    protected final NotationDiffCreator gmfModelCreator = new NotationDiffCreator();
    private TransactionalEditingDomain leftTED;
    private TransactionalEditingDomain rightTED;
    private TransactionalEditingDomain ancestorTED;

    protected GMFContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(parent, config);
    }

    public String getTitle() {
        return "Visualization of graphical differences";
    }

    protected ModelContentMergeTabFolder createModelContentMergeTabFolder(Composite composite, int side) {
        return new GMFContentMergeTabFolder((ModelContentMergeViewer)this, composite, side);
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        Object ancestorObject = ancestor;
        Object leftObject = left;
        Object rightObject = right;
        if (ancestorObject instanceof TypedElementWrapper) {
            ancestorObject = ((TypedElementWrapper)ancestorObject).getObject() == null ? null : this.getInputObject((TypedElementWrapper)ancestorObject);
        }
        if (leftObject instanceof TypedElementWrapper) {
            leftObject = this.getInputObject((TypedElementWrapper)leftObject);
        }
        if (rightObject instanceof TypedElementWrapper) {
            rightObject = this.getInputObject((TypedElementWrapper)rightObject);
        }
        if (ancestorObject != null) {
            this.ancestorTED = EditingDomainUtils.getOrCreateEditingDomain(ancestorObject);
        }
        if (leftObject != null) {
            this.leftTED = EditingDomainUtils.getOrCreateEditingDomain(leftObject);
            this.annotateSide(IMatchManager.MatchSide.LEFT);
        }
        if (rightObject != null) {
            this.rightTED = EditingDomainUtils.getOrCreateEditingDomain(rightObject);
            this.annotateSide(IMatchManager.MatchSide.RIGHT);
        }
        super.updateContent(ancestor, left, right);
    }

    private void annotateSide(final IMatchManager.MatchSide side) {
        TransactionalEditingDomain ted = null;
        ted = side == IMatchManager.MatchSide.LEFT ? this.leftTED : this.rightTED;
        RecordingCommand command = new RecordingCommand(ted){

            protected void doExecute() {
                if (GMFContentMergeViewer.this.gmfModelCreator != null) {
                    GMFContentMergeViewer.this.gmfModelCreator.setInput(GMFContentMergeViewer.this.getInput());
                    GMFContentMergeViewer.this.gmfModelCreator.addEAnnotations(side);
                }
            }
        };
        ted.getCommandStack().execute((Command)command);
    }

    protected void unnannotateSide(final IMatchManager.MatchSide side) {
        TransactionalEditingDomain ted = null;
        ted = side == IMatchManager.MatchSide.LEFT ? this.leftTED : this.rightTED;
        RecordingCommand command = new RecordingCommand(ted){

            protected void doExecute() {
                if (GMFContentMergeViewer.this.gmfModelCreator != null) {
                    GMFContentMergeViewer.this.gmfModelCreator.setInput(GMFContentMergeViewer.this.getInput());
                    GMFContentMergeViewer.this.gmfModelCreator.removeEAnnotations(side);
                }
            }
        };
        ted.getCommandStack().execute((Command)command);
    }

    public NotationDiffCreator getModelCreator() {
        return this.gmfModelCreator;
    }

    protected void copy(final List<DiffElement> diffs, final boolean leftToRight) {
        this.unnannotateSide(IMatchManager.MatchSide.LEFT);
        this.unnannotateSide(IMatchManager.MatchSide.RIGHT);
        TransactionalEditingDomain ted = leftToRight ? this.rightTED : this.leftTED;
        RecordingCommand command = new RecordingCommand(ted){

            protected void doExecute() {
                GMFContentMergeViewer.super.copy(diffs, leftToRight);
            }
        };
        ted.getCommandStack().execute((Command)command);
    }

    protected void copy(final boolean leftToRight) {
        this.unnannotateSide(IMatchManager.MatchSide.LEFT);
        this.unnannotateSide(IMatchManager.MatchSide.RIGHT);
        TransactionalEditingDomain ted = leftToRight ? this.rightTED : this.leftTED;
        RecordingCommand command = new RecordingCommand(ted){

            protected void doExecute() {
                GMFContentMergeViewer.super.copy(leftToRight);
            }
        };
        ted.getCommandStack().execute((Command)command);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.leftTED != null) {
            this.leftTED.dispose();
        }
        if (this.rightTED != null) {
            this.rightTED.dispose();
        }
        if (this.ancestorTED != null) {
            this.ancestorTED.dispose();
        }
        this.gmfModelCreator.dispose();
        super.handleDispose(event);
    }

    protected IMergeViewerContentProvider createMergeViewerContentProvider() {
        return new GMFModelContentMergeContentProvider(this.configuration);
    }

    private class GMFModelContentMergeContentProvider
    extends ModelContentMergeContentProvider {
        public GMFModelContentMergeContentProvider(CompareConfiguration config) {
            super(config);
        }

        public void saveLeftContent(Object element, byte[] bytes) {
            GMFContentMergeViewer.this.unnannotateSide(IMatchManager.MatchSide.LEFT);
            GMFContentMergeViewer.this.unnannotateSide(IMatchManager.MatchSide.RIGHT);
            super.saveLeftContent(element, bytes);
        }

        public void saveRightContent(Object element, byte[] bytes) {
            GMFContentMergeViewer.this.unnannotateSide(IMatchManager.MatchSide.LEFT);
            GMFContentMergeViewer.this.unnannotateSide(IMatchManager.MatchSide.RIGHT);
            super.saveRightContent(element, bytes);
        }
    }
}

