/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diagram.ui.mergeviewer.EditingDomainUtils;
import org.eclipse.emf.compare.diagram.ui.viewmodel.NotationDiffCreator;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GMFCompareService {
    private GMFCompareService() {
    }

    public static ComparedResourceSets layerDifferences(DiffResourceSet diffModel) throws IOException {
        ComparedResourceSets comparedResourceSets = new ComparedResourceSets();
        GMFCompareService.createEAnnotations(diffModel);
        for (DiffModel diff : diffModel.getDiffModels()) {
            GMFResource ancestor;
            GMFResource right;
            GMFResource left = GMFCompareService.getGMFResource(diff, IMatchManager.MatchSide.LEFT);
            if (left != null) {
                comparedResourceSets.left.add(left);
            }
            if ((right = GMFCompareService.getGMFResource(diff, IMatchManager.MatchSide.RIGHT)) != null) {
                comparedResourceSets.right.add(right);
            }
            if ((ancestor = GMFCompareService.getGMFResource(diff, IMatchManager.MatchSide.ANCESTOR)) == null) continue;
            comparedResourceSets.ancestor.add(left);
        }
        return comparedResourceSets;
    }

    private static GMFResource getGMFResource(DiffModel diff, IMatchManager.MatchSide side) {
        EObject root = GMFCompareService.getFirstRoot(diff, side);
        if (root != null && root.eResource() instanceof GMFResource) {
            return (GMFResource)root.eResource();
        }
        return null;
    }

    private static EObject getFirstRoot(DiffModel diff, IMatchManager.MatchSide side) {
        EList roots = null;
        switch (side) {
            case LEFT: {
                roots = diff.getLeftRoots();
                break;
            }
            case RIGHT: {
                roots = diff.getRightRoots();
                break;
            }
            case ANCESTOR: {
                roots = diff.getAncestorRoots();
            }
        }
        if (roots != null && !roots.isEmpty()) {
            return (EObject)roots.get(0);
        }
        return null;
    }

    public static ComparedResourceSets layerDifferences(ComparedResourceSets input, Map<String, Object> options) throws InterruptedException, IOException {
        List left = input.left;
        List right = input.right;
        List ancestor = input.ancestor;
        ComparedResourceSets result = new ComparedResourceSets();
        int i = 0;
        while (i < left.size()) {
            MatchResourceSet matchModel;
            DiffResourceSet diffModel = null;
            if (ancestor.size() == 0) {
                matchModel = MatchService.doResourceSetMatch((ResourceSet)((Resource)left.get(i)).getResourceSet(), (ResourceSet)((Resource)right.get(i)).getResourceSet(), options);
                diffModel = DiffService.doDiff((MatchResourceSet)matchModel, (boolean)false);
            } else {
                matchModel = MatchService.doResourceSetMatch((ResourceSet)((Resource)left.get(i)).getResourceSet(), (ResourceSet)((Resource)right.get(i)).getResourceSet(), (ResourceSet)((Resource)ancestor.get(i)).getResourceSet(), options);
                diffModel = DiffService.doDiff((MatchResourceSet)matchModel, (boolean)true);
            }
            result.append(GMFCompareService.layerDifferences(diffModel));
            ++i;
        }
        return result;
    }

    private static void createEAnnotations(DiffResourceSet diffModel) {
        NotationDiffCreator gmfModelCreator = new NotationDiffCreator();
        gmfModelCreator.setInput(new ModelCompareInput(null, diffModel));
        GMFCompareService.createEAnnotations(diffModel, IMatchManager.MatchSide.LEFT, gmfModelCreator);
        GMFCompareService.createEAnnotations(diffModel, IMatchManager.MatchSide.RIGHT, gmfModelCreator);
    }

    private static void createEAnnotations(DiffResourceSet diffResourceSet, final IMatchManager.MatchSide side, final NotationDiffCreator gmfModelCreator) {
        EObject root = GMFCompareService.getDiagramRoot(diffResourceSet, side);
        if (root != null) {
            TransactionalEditingDomain ted = EditingDomainUtils.getOrCreateEditingDomain(root);
            RecordingCommand command = new RecordingCommand(ted){

                protected void doExecute() {
                    gmfModelCreator.addEAnnotations(side);
                }
            };
            ted.getCommandStack().execute((Command)command);
            ted.dispose();
        }
    }

    private static EObject getDiagramRoot(DiffResourceSet diffResourceSet, IMatchManager.MatchSide side) {
        EObject ret = null;
        EList diffModels = diffResourceSet.getDiffModels();
        for (DiffModel diffModel : diffModels) {
            ret = GMFCompareService.getFirstRoot(diffModel, side);
            if (!(ret instanceof Diagram)) continue;
            return ret;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComparedResourceSets {
        private List<Resource> left = new ArrayList<Resource>();
        private List<Resource> right = new ArrayList<Resource>();
        private List<Resource> ancestor = new ArrayList<Resource>();

        public List<Resource> getLeft() {
            return this.left;
        }

        public void setLeft(List<Resource> pLeft) {
            this.left = pLeft;
        }

        public List<Resource> getRight() {
            return this.right;
        }

        public void setRight(List<Resource> pRight) {
            this.right = pRight;
        }

        public List<Resource> getAncestor() {
            return this.ancestor;
        }

        public void setAncestor(List<Resource> pAncestor) {
            this.ancestor = pAncestor;
        }

        public ComparedResourceSets append(ComparedResourceSets resources) {
            this.left.addAll(resources.left);
            this.right.addAll(resources.right);
            this.ancestor.addAll(resources.ancestor);
            return this;
        }
    }
}

