/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ApplyWizardSelectModelPage
extends WizardPage
implements ISelectionChangedListener {
    private URI uri;
    private Text uriText;
    private TreeViewer viewer;
    private final AdapterFactory adapterFactory;

    public ApplyWizardSelectModelPage(String pageName, URI modelURI, AdapterFactory adapterFactory) {
        super(pageName);
        this.uri = modelURI;
        this.setTitle(pageName);
        this.setDescription("Select a model to which the MPatch should be applied.");
        this.adapterFactory = adapterFactory;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Target model:");
        this.uriText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.uriText.setLayoutData((Object)gd);
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplyWizardSelectModelPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("B&rowse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplyWizardSelectModelPage.this.handleBrowse();
            }
        });
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 3;
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)gd1);
        infoLabel.setText("Contents of the selected resource:");
        GridData gd2 = new GridData(272);
        gd2.horizontalSpan = 3;
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        this.viewer = new TreeViewer(container, 2818);
        this.viewer.getTree().setLayoutData((Object)gd2);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 3;
        Label hintLabel = new Label(container, 64);
        hintLabel.setLayoutData((Object)gd3);
        hintLabel.setText("Hint: You may also select a sub-model that contains ALL RELEVANT ELEMENTS for MPatch application (improves performance).");
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.uri != null && this.uriText.getText().length() == 0) {
            this.uriText.setText(this.uri.toString());
        } else {
            URI diffURI = ((ApplyWizard)this.getWizard()).getMPatch().eResource().getURI();
            this.uriText.setText(diffURI.toString().substring(0, diffURI.toString().length() - diffURI.lastSegment().length()));
        }
    }

    private void handleBrowse() {
        ApplyToResourceDialog dialog = new ApplyToResourceDialog(this.getShell(), "Select model", 4100);
        if (dialog.open() == 0) {
            if (dialog.getURIs().size() >= 1) {
                this.uri = (URI)dialog.getURIs().get(0);
                this.uriText.setText(this.uri.toString());
            } else {
                this.uri = null;
                this.uriText.setText("");
            }
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void dialogChanged() {
        String fileUri = this.uriText.getText().trim();
        this.viewer.setInput(null);
        if (fileUri.length() > 0) {
            block9: {
                try {
                    this.uri = URI.createURI((String)fileUri);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource modelResource = resourceSet.getResource(this.uri, true);
                    if (modelResource.getContents().size() != 1) {
                        int counter = 0;
                        for (EObject obj : modelResource.getContents()) {
                            if (obj instanceof DynamicEObjectImpl) continue;
                            ++counter;
                        }
                        this.viewer.setInput((Object)modelResource);
                        if (counter > 1) {
                            this.updateStatus("At the moment, only one root object is allowed!");
                            this.uri = null;
                            return;
                        }
                        if (counter != 1 && counter == 0) {
                            this.updateStatus("Only dynamic objects found in model - please make sure that your model conforms to a registered meta model!");
                            this.uri = null;
                            return;
                        }
                    }
                    if (modelResource.getContents().get(0) instanceof EObject) {
                        ((ApplyWizard)this.getWizard()).setModelResource(modelResource);
                        this.viewer.setInput((Object)modelResource);
                        break block9;
                    }
                    this.updateStatus("The selected resource does not contain a valid model!");
                    this.uri = null;
                    return;
                }
                catch (RuntimeException e) {
                    this.updateStatus("Exception loading resource: " + e.getMessage() + " " + e.getStackTrace()[0] + "...");
                    return;
                }
            }
            this.updateStatus(null);
        } else {
            this.updateStatus("Please select an input file.");
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj;
        IStructuredSelection structuredSelection;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (obj = structuredSelection.getFirstElement()) instanceof EObject) {
            ((ApplyWizard)this.getWizard()).setModelTarget((EObject)obj);
        }
    }

    private final class ApplyToResourceDialog
    extends ResourceDialog {
        private ApplyToResourceDialog(Shell parent, String title, int style) {
            super(parent, title, style);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.uriField.setText(ApplyWizardSelectModelPage.this.uriText.getText());
            return composite;
        }

        protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
            browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IFile file;
                    Object[] iFiles = new IFile[]{};
                    try {
                        iFiles = new IFile[]{ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(ApplyToResourceDialog.this.uriField.getText()))};
                    }
                    catch (Exception exception) {}
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)ApplyToResourceDialog.this.getShell(), (String)"Apply differences to...", null, (boolean)false, (Object[])iFiles, null);
                    if (files.length != 0 && (file = files[0]) != null) {
                        ApplyToResourceDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                    }
                }
            });
        }
    }
}

