/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.common.actions.AbstractCompareAction;
import org.eclipse.emf.compare.mpatch.transform.impl.ReverseMPatch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ReverseAction
extends AbstractCompareAction {
    private static final String ACTION_NAME = "Reverse";
    private static final String INPUT_FILE_EXTENSION = "mpatch";
    private static final String OUTPUT_FILE_EXTENSION = "mpatch";
    private static final String JOB_TITLE = "Reverse MPatch...";

    public ReverseAction() {
        super("mpatch", "mpatch", JOB_TITLE);
    }

    protected Status runAction(Resource input, Resource output, IProgressMonitor monitor) {
        Exception exception;
        int code;
        String message;
        block7: {
            message = "";
            code = 0;
            exception = null;
            EObject content = (EObject)input.getContents().get(0);
            if (content instanceof MPatchModel) {
                MPatchModel mpatch = (MPatchModel)content;
                int reversed = 0;
                try {
                    reversed = ReverseMPatch.reverse(mpatch);
                    if (reversed > 0) {
                        output.getContents().add((Object)mpatch);
                        try {
                            output.save(null);
                            message = "MPatch successfully reversed: " + reversed + " changes affected.";
                        }
                        catch (IOException e) {
                            code = 4;
                            message = "Could not save reversed MPatch!";
                            exception = e;
                        }
                        break block7;
                    }
                    message = "Reverse finished: nothing was changed.";
                }
                catch (Exception e) {
                    message = "An exception occured during Reverse";
                    exception = e;
                    code = 4;
                }
            } else {
                code = 4;
                message = "Could not find MPatch in:\n\n" + content;
            }
        }
        return new Status(code, "org.eclipse.emf.compare.mpatch.transform", message, (Throwable)exception);
    }
}

