/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.compare.diagram.ui.decoration.provider.DiffDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDifferenceDecorator
implements IDecorator {
    protected NotificationListener notificationListener = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            AbstractDifferenceDecorator.this.refresh();
        }
    };
    private IDecoratorTarget decoratorTarget;
    private List<IDecoration> decorationsTarget;

    protected AbstractDifferenceDecorator(IDecoratorTarget target) {
        this.decoratorTarget = target;
    }

    private boolean addDecorations(List<IDecoration> decorations) {
        if (this.decorationsTarget == null) {
            this.decorationsTarget = new ArrayList<IDecoration>(decorations.size());
        }
        return this.decorationsTarget.addAll(decorations);
    }

    public IDecoratorTarget getTarget() {
        return this.decoratorTarget;
    }

    protected void removeDecorations() {
        if (this.decorationsTarget != null) {
            for (IDecoration decoration : this.decorationsTarget) {
                this.decoratorTarget.removeDecoration(decoration);
            }
            this.decorationsTarget.clear();
        }
    }

    protected IGraphicalEditPart getTargetEditPart() {
        return (IGraphicalEditPart)this.decoratorTarget.getAdapter(IGraphicalEditPart.class);
    }

    public final void refresh() {
        this.removeDecorations();
        if (DiffDecoratorProvider.shouldDecorate(this.getTarget())) {
            IGraphicalEditPart gep = this.getTargetEditPart();
            View view = gep.getNotationView();
            for (Map.Entry detail : view.getEAnnotation("diff-marker").getDetails()) {
                if (((String)detail.getKey()).equals("diff-moved")) {
                    this.addDecorations(this.getMovedDecorations());
                    continue;
                }
                if (((String)detail.getKey()).equals("diff-modified")) {
                    this.addDecorations(this.getModifiedDecorations());
                    continue;
                }
                if (((String)detail.getKey()).equals("diff-added")) {
                    this.addDecorations(this.getAddedDecorations());
                    continue;
                }
                if (((String)detail.getKey()).equals("diff-removed")) {
                    this.addDecorations(this.getRemovedDecorations());
                    continue;
                }
                if (((String)detail.getKey()).equals("diff-hided")) {
                    this.addDecorations(this.getHidedDecorations());
                    continue;
                }
                if (((String)detail.getKey()).equals("diff-showed")) {
                    this.addDecorations(this.getShowedDecorations());
                    continue;
                }
                if (!((String)detail.getKey()).equals("diff-label-modified")) continue;
                this.addDecorations(this.getLabelModifiedDecorations());
            }
        }
    }

    protected void highlightEdge(IFigure figure, Color color, int size) {
        if (figure instanceof PolylineConnection) {
            figure.setBackgroundColor(color);
            figure.setForegroundColor(color);
            ((PolylineConnection)figure).setLineWidth(size);
        }
    }

    protected void highlightNode(IFigure figure, Color color, int size) {
        figure.setBorder((Border)new LineBorder(color, size));
        figure.setOpaque(false);
    }

    protected abstract List<IDecoration> getModifiedDecorations();

    protected abstract List<IDecoration> getAddedDecorations();

    protected abstract List<IDecoration> getRemovedDecorations();

    protected abstract List<IDecoration> getMovedDecorations();

    protected abstract List<IDecoration> getHidedDecorations();

    protected abstract List<IDecoration> getShowedDecorations();

    protected abstract List<IDecoration> getLabelModifiedDecorations();
}

