/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ui.mergeviewer;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;

public final class EditingDomainUtils {
    private EditingDomainUtils() {
    }

    public static TransactionalEditingDomain getOrCreateEditingDomain(Object object) {
        EditingDomain editingDomain = EditingDomainUtils.getEditingDomainFor(object);
        if (editingDomain == null || !(editingDomain instanceof TransactionalEditingDomain)) {
            if (object instanceof EObject) {
                editingDomain = EditingDomainUtils.registerEditingDomain((EObject)object);
            } else if (object instanceof List) {
                List list = (List)object;
                for (Object object2 : list) {
                    editingDomain = EditingDomainUtils.getOrCreateEditingDomain(object2);
                    if (editingDomain == null) {
                        continue;
                    }
                    break;
                }
            } else if (object instanceof Resource) {
                editingDomain = EditingDomainUtils.registerEditingDomain((Resource)object);
            } else if (object instanceof ResourceSet) {
                editingDomain = EditingDomainUtils.registerEditingDomain((ResourceSet)object);
            }
        }
        return (TransactionalEditingDomain)editingDomain;
    }

    private static EditingDomain getEditingDomainFor(Object object) {
        EditingDomain editingDomain = null;
        if (object instanceof IEditingDomainProvider) {
            editingDomain = ((IEditingDomainProvider)object).getEditingDomain();
        } else if (object instanceof EObject) {
            editingDomain = EditingDomainUtils.getEditingDomainFor((EObject)object);
        } else if (object instanceof FeatureMap.Entry) {
            editingDomain = EditingDomainUtils.getEditingDomainFor(((FeatureMap.Entry)object).getValue());
        } else if (object instanceof IWrapperItemProvider) {
            editingDomain = EditingDomainUtils.getEditingDomainFor(((IWrapperItemProvider)object).getValue());
        }
        return editingDomain;
    }

    private static EditingDomain getEditingDomainFor(EObject object) {
        Resource resource = object.eResource();
        if (resource != null) {
            return EditingDomainUtils.getEditingDomainFor(resource);
        }
        return null;
    }

    private static EditingDomain getEditingDomainFor(Resource resource) {
        EditingDomain editingDomain = null;
        IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)EcoreUtil.getExistingAdapter((Notifier)resource, IEditingDomainProvider.class);
        if (editingDomainProvider != null) {
            editingDomain = editingDomainProvider.getEditingDomain();
        } else {
            ResourceSet resourceSet = resource.getResourceSet();
            editingDomain = EditingDomainUtils.getEditingDomainFor(resourceSet);
        }
        return editingDomain;
    }

    private static EditingDomain getEditingDomainFor(ResourceSet resourceSet) {
        IEditingDomainProvider editingDomainProvider;
        EditingDomain editingDomain = null;
        if (resourceSet instanceof IEditingDomainProvider) {
            editingDomain = ((IEditingDomainProvider)resourceSet).getEditingDomain();
        } else if (resourceSet != null && (editingDomainProvider = (IEditingDomainProvider)EcoreUtil.getExistingAdapter((Notifier)resourceSet, IEditingDomainProvider.class)) != null) {
            editingDomain = editingDomainProvider.getEditingDomain();
        }
        return editingDomain;
    }

    private static TransactionalEditingDomain registerEditingDomain(EObject eObject) {
        TransactionalEditingDomain editingDomain = null;
        Resource eResource = eObject.eResource();
        if (eResource != null) {
            editingDomain = EditingDomainUtils.registerEditingDomain(eResource);
        }
        return editingDomain;
    }

    private static TransactionalEditingDomain registerEditingDomain(Resource eResource) {
        TransactionalEditingDomain editingDomain = null;
        ResourceSet resourceSet = eResource.getResourceSet();
        if (resourceSet != null) {
            editingDomain = EditingDomainUtils.registerEditingDomain(resourceSet);
        }
        return editingDomain;
    }

    private static TransactionalEditingDomain registerEditingDomain(ResourceSet resourceSet) {
        return DiagramEditingDomainFactory.getInstance().createEditingDomain(resourceSet);
    }
}

