/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diagramdiff.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diagram.diagramdiff.BusinessDiagramEdgeChange;
import org.eclipse.emf.compare.diagram.diagramdiff.DiagramEdgeChange;
import org.eclipse.emf.compare.diagram.diagramdiff.impl.DiagramEdgeChangeImpl;
import org.eclipse.emf.compare.diagram.diff.util.DiffUtil;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessDiagramEdgeChangeImpl
extends DiagramEdgeChangeImpl
implements BusinessDiagramEdgeChange {
    private Edge leftEdge;
    private Edge rightEdge;
    private EAttribute attribute;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public Object getImage() {
        return null;
    }

    @Override
    public IMerger provideMerger() {
        return null;
    }

    @Override
    public void init(DiffElement origin, EcoreUtil.CrossReferencer crossReferencer, MatchModel match) {
        this.setHiddenDifferences(origin, crossReferencer);
        this.getRequires().addAll(this.getHideElements());
        if (this.leftEdge == null) {
            this.leftEdge = DiffUtil.getElement(origin, DiffUtil.Side.LEFT, Edge.class);
            this.setLeftElement((EObject)this.leftEdge);
        }
        if (this.rightEdge == null) {
            this.rightEdge = DiffUtil.getElement(origin, DiffUtil.Side.RIGHT, Edge.class);
            this.setRightElement((EObject)this.rightEdge);
        }
        if (origin instanceof UpdateAttribute && this.attribute == null) {
            this.attribute = ((UpdateAttribute)origin).getAttribute();
        }
        this.setRemote(DiffUtil.isRemote(this.getHideElements()));
        this.registerMyself(crossReferencer);
    }

    private void registerMyself(EcoreUtil.CrossReferencer crossReferencer) {
        EStructuralFeature.Setting leftSetting = this.eSetting((EStructuralFeature)DiffPackage.eINSTANCE.getUpdateModelElement_LeftElement());
        EStructuralFeature.Setting rightSetting = this.eSetting((EStructuralFeature)DiffPackage.eINSTANCE.getUpdateModelElement_RightElement());
        ArrayList<EStructuralFeature.Setting> values1 = new ArrayList<EStructuralFeature.Setting>();
        values1.add(leftSetting);
        crossReferencer.put((Object)this.leftEdge, values1);
        ArrayList<EStructuralFeature.Setting> values2 = new ArrayList<EStructuralFeature.Setting>();
        values2.add(rightSetting);
        crossReferencer.put((Object)this.rightEdge, values2);
    }

    private void setHiddenDifferences(DiffElement origin, EcoreUtil.CrossReferencer crossReferencer) {
        Edge lleftEdge = DiffUtil.getElement(origin, DiffUtil.Side.LEFT, Edge.class);
        Set<DiffElement> hiddenDiffsFromLeft = this.getAllRelatedEdgeChangesFrom((View)lleftEdge, crossReferencer);
        Edge lrightEdge = DiffUtil.getElement(origin, DiffUtil.Side.RIGHT, Edge.class);
        hiddenDiffsFromLeft.addAll(this.getAllRelatedEdgeChangesFrom((View)lrightEdge, crossReferencer));
        this.getHideElements().addAll(new ArrayList<DiffElement>(hiddenDiffsFromLeft));
    }

    private Set<DiffElement> getAllRelatedEdgeChangesFrom(View view, EcoreUtil.CrossReferencer crossReferencer) {
        HashSet<DiffElement> result = new HashSet<DiffElement>();
        if (view != null && crossReferencer != null) {
            TreeIterator it = view.eAllContents();
            while (it.hasNext()) {
                EObject prop = (EObject)it.next();
                Collection diffs = (Collection)crossReferencer.get((Object)prop);
                if (diffs == null) continue;
                for (EStructuralFeature.Setting setting : diffs) {
                    EObject obj = setting.getEObject();
                    if (!(obj instanceof DiffElement) || !BusinessDiagramEdgeChangeImpl.isLayoutEdgeComparison((DiffElement)obj)) continue;
                    result.add((DiffElement)obj);
                }
            }
        }
        return result;
    }

    @Override
    public Edge getLeftEdge() {
        return this.leftEdge;
    }

    @Override
    public Edge getRightEdge() {
        return this.rightEdge;
    }

    @Override
    public EAttribute getAttribute() {
        return this.attribute;
    }

    public static boolean isConcernedBy(DiffElement diff, EcoreUtil.CrossReferencer crossReferencer) {
        if (BusinessDiagramEdgeChangeImpl.isLayoutEdgeComparison(diff)) {
            return !BusinessDiagramEdgeChangeImpl.isDiagramEdgeChangeRegistered(diff, crossReferencer);
        }
        return false;
    }

    private static boolean isDiagramEdgeChangeRegistered(DiffElement diff, EcoreUtil.CrossReferencer crossReferencer) {
        Edge edge = DiffUtil.getElement(diff, DiffUtil.Side.ANY, Edge.class);
        Collection diffs = (Collection)crossReferencer.get((Object)edge);
        if (diffs != null) {
            for (EStructuralFeature.Setting setting : diffs) {
                EObject obj = setting.getEObject();
                if (!(obj instanceof DiagramEdgeChange)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLayoutEdgeComparison(DiffElement diff) {
        return BusinessDiagramEdgeChangeImpl.isBendpointsComparison(diff) || BusinessDiagramEdgeChangeImpl.isAnchorsComparison(diff);
    }

    private static boolean isBendpointsComparison(DiffElement diff) {
        return diff instanceof UpdateAttribute && BusinessDiagramEdgeChangeImpl.isBendpointsComparison((UpdateAttribute)diff);
    }

    private static boolean isBendpointsComparison(UpdateAttribute diff) {
        return diff.getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getRelativeBendpoints());
    }

    private static boolean isAnchorsComparison(DiffElement diff) {
        return BusinessDiagramEdgeChangeImpl.isAnchorAdded(diff) || BusinessDiagramEdgeChangeImpl.isAnchorChanged(diff);
    }

    private static boolean isAnchorsComparison(UpdateAttribute diff) {
        return diff.getAttribute().equals(NotationPackage.eINSTANCE.getIdentityAnchor_Id());
    }

    private static boolean isAnchorsComparison(ModelElementChange diff) {
        boolean result = false;
        if (diff instanceof ModelElementChangeLeftTarget) {
            result = BusinessDiagramEdgeChangeImpl.isAnchorsComparison((ModelElementChangeLeftTarget)diff);
        } else if (diff instanceof ModelElementChangeRightTarget) {
            result = BusinessDiagramEdgeChangeImpl.isAnchorsComparison((ModelElementChangeRightTarget)diff);
        }
        return result;
    }

    private static boolean isAnchorsComparison(ModelElementChangeLeftTarget diff) {
        return diff.getLeftElement() instanceof IdentityAnchor;
    }

    private static boolean isAnchorsComparison(ModelElementChangeRightTarget diff) {
        return diff.getRightElement() instanceof IdentityAnchor;
    }

    private static boolean isAnchorAdded(DiffElement diff) {
        return diff instanceof ModelElementChange && BusinessDiagramEdgeChangeImpl.isAnchorsComparison((ModelElementChange)diff);
    }

    private static boolean isAnchorChanged(DiffElement diff) {
        return diff instanceof UpdateAttribute && BusinessDiagramEdgeChangeImpl.isAnchorsComparison((UpdateAttribute)diff);
    }

    public static EObject getElement(DiffElement diff, DiffUtil.Side side) {
        if (diff instanceof BusinessDiagramEdgeChange) {
            return ((BusinessDiagramEdgeChange)diff).getLeftElement();
        }
        return (EObject)DiffUtil.getElement(diff, side, Edge.class);
    }

    @Override
    public EObject getElement() {
        return this.getLeftElement();
    }

    @Override
    public Resource getRightResource() {
        return this.getRightElement().eResource();
    }

    @Override
    public Resource getLeftResource() {
        return this.getLeftElement().eResource();
    }
}

