/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.provider.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diagram.provider.IViewLabelProvider;
import org.eclipse.emf.compare.diagram.provider.internal.ViewLabelProviderExtensionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewLabelProviderExtensionRegistry {
    public static final ViewLabelProviderExtensionRegistry INSTANCE = new ViewLabelProviderExtensionRegistry();
    private final List<ViewLabelProviderExtensionDescriptor> extensionsDescriptors = new ArrayList<ViewLabelProviderExtensionDescriptor>();

    private ViewLabelProviderExtensionRegistry() {
    }

    public synchronized void addExtension(ViewLabelProviderExtensionDescriptor extension) {
        this.extensionsDescriptors.add(extension);
    }

    public synchronized void clearRegistry() {
        this.extensionsDescriptors.clear();
    }

    public synchronized List<ViewLabelProviderExtensionDescriptor> getRegisteredExtensionsDescriptors() {
        return new ArrayList<ViewLabelProviderExtensionDescriptor>(this.extensionsDescriptors);
    }

    public synchronized void removeExtension(String extensionClassName) {
        for (ViewLabelProviderExtensionDescriptor extension : this.getRegisteredExtensionsDescriptors()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            this.extensionsDescriptors.remove(extension);
        }
    }

    public IViewLabelProvider getExtensionForType(String diagramType) {
        if (diagramType == null || "".equals(diagramType.trim())) {
            throw new IllegalArgumentException("nsURI");
        }
        List<ViewLabelProviderExtensionDescriptor> registeredExtensions = this.getRegisteredExtensionsDescriptors();
        for (ViewLabelProviderExtensionDescriptor viewLabelTypeProviderExtensionDescriptor : registeredExtensions) {
            if (!diagramType.equals(viewLabelTypeProviderExtensionDescriptor.getDiagramType())) continue;
            return viewLabelTypeProviderExtensionDescriptor.getViewLabelTypeProviderExtension();
        }
        return null;
    }

    public List<IViewLabelProvider> getLabelProviderExtensions() {
        ArrayList<IViewLabelProvider> result = new ArrayList<IViewLabelProvider>();
        List<ViewLabelProviderExtensionDescriptor> registeredExtensions = this.getRegisteredExtensionsDescriptors();
        for (ViewLabelProviderExtensionDescriptor viewLabelTypeProviderExtensionDescriptor : registeredExtensions) {
            result.add(viewLabelTypeProviderExtensionDescriptor.getViewLabelTypeProviderExtension());
        }
        return result;
    }
}

