/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CompareTextDialog
extends TrayDialog {
    protected static final String ERROR_DIALOG_TITLE = EMFCompareUIMessages.getString("CompareTextDialog_titleErrorMsg");
    private static final String PREFIX_SUFFIX_PROPERTY = "org.eclipse.emf.compare.ui.CompareTextDialog.prefixSuffix";
    protected EAttribute attribute;
    protected UpdateAttribute changeCompare;
    protected CompareConfiguration parentConfiguration;
    protected Object parentInput;
    protected ITypedElement ancestor;
    protected ITypedElement left;
    protected ITypedElement right;
    private TextMergeViewer fViewer;
    private String rightElement;
    private String leftElement;
    private String ancestorElement;
    private boolean isConflicting;
    private final int[] fPrefixSuffix = new int[2];
    private CompareViewerPane fCompareViewerPane;

    public CompareTextDialog(Shell parentShell, UpdateAttribute element) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 4);
        this.setChangeCompare(element);
    }

    public CompareTextDialog(Shell parentShell, UpdateAttribute element, ModelStructureMergeViewer parentViewer, Object input) {
        this(parentShell, element);
        this.parentConfiguration = parentViewer.getCompareConfiguration();
        this.parentInput = input;
    }

    protected boolean isResizable() {
        return true;
    }

    private void setChangeCompare(UpdateAttribute updateAttribute) {
        this.changeCompare = updateAttribute;
        this.attribute = updateAttribute.getAttribute();
        this.isConflicting = updateAttribute.isConflicting();
        this.setStringValues(updateAttribute);
        this.computePrefixSuffix();
    }

    private void setStringValues(UpdateAttribute updateAttribute) {
        EObject oRightElement = updateAttribute.getRightElement();
        EObject oLeftElement = updateAttribute.getLeftElement();
        EObject parent = updateAttribute.eContainer();
        try {
            ConflictingDiffElement conflict;
            EObject oAncestorElement;
            if (parent instanceof ConflictingDiffElement && (oAncestorElement = (conflict = (ConflictingDiffElement)parent).getOriginElement()) != null) {
                this.ancestorElement = EFactory.eGetAsString((EObject)oAncestorElement, (String)this.attribute.getName());
            }
            if (oRightElement != null) {
                this.rightElement = EFactory.eGetAsString((EObject)oRightElement, (String)this.attribute.getName());
            }
            if (oLeftElement != null) {
                this.leftElement = EFactory.eGetAsString((EObject)oLeftElement, (String)this.attribute.getName());
            }
            if (this.rightElement == null) {
                this.rightElement = "";
            }
            if (this.leftElement == null) {
                this.leftElement = "";
            }
            if (this.ancestorElement == null) {
                this.ancestorElement = "";
            }
        }
        catch (FactoryException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage());
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return EMFCompareUIPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName());
    }

    private void computePrefixSuffix() {
        int end = Math.min(this.rightElement.length(), this.leftElement.length());
        int i = 0;
        while (i < end) {
            if (this.rightElement.charAt(i) != this.leftElement.charAt(i)) break;
            ++i;
        }
        this.fPrefixSuffix[0] = i;
        int j = this.rightElement.length() - 1;
        int k = this.leftElement.length() - 1;
        int l = 0;
        while (k >= i && j >= i) {
            if (this.rightElement.charAt(j) != this.leftElement.charAt(k)) break;
            --k;
            --j;
            ++l;
        }
        this.fPrefixSuffix[1] = l;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EMFCompareUIMessages.getString("CompareTextDialog_title", this.attribute.getName()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, EMFCompareUIMessages.getString("CompareTextDialog_labelOK"), true);
        this.createButton(parent, 1, EMFCompareUIMessages.getString("CompareTextDialog_labelCancel"), true);
    }

    protected void okPressed() {
        this.fViewer.flush((IProgressMonitor)new NullProgressMonitor());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fCompareViewerPane = new CompareViewerPane(composite, 0x800800);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        data.heightHint = this.convertHeightInCharsToPixels(13);
        this.fCompareViewerPane.setLayoutData((Object)data);
        Control previewer = this.createPreviewer((Composite)this.fCompareViewerPane);
        this.fCompareViewerPane.setContent(previewer);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        CompareTextDialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        final CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel(this.parentConfiguration.getLeftLabel(this.parentInput));
        compareConfiguration.setLeftEditable(true);
        compareConfiguration.setRightLabel(this.parentConfiguration.getRightLabel(this.parentInput));
        compareConfiguration.setRightEditable(true);
        compareConfiguration.setAncestorLabel(this.parentConfiguration.getAncestorLabel(this.parentInput));
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)Boolean.FALSE);
        compareConfiguration.setProperty(PREFIX_SUFFIX_PROPERTY, (Object)this.fPrefixSuffix);
        this.fViewer = new TextMergeViewer(parent, 0, compareConfiguration);
        this.fViewer.setContentProvider((IContentProvider)new CustomMergeViewerContentProvider(compareConfiguration));
        this.setCompareViewerInput();
        Control control = this.fViewer.getControl();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                compareConfiguration.dispose();
            }
        });
        return control;
    }

    private void setCompareViewerInput() {
        if (!this.fViewer.getControl().isDisposed()) {
            if (this.isConflicting) {
                this.fViewer.setInput((Object)new DiffNode(12, (ITypedElement)new CompareElement(this.ancestorElement), (ITypedElement)new CompareElement(this.leftElement), (ITypedElement)new CompareElement(this.rightElement)));
            } else {
                this.fViewer.setInput((Object)new DiffNode((ITypedElement)new CompareElement(this.leftElement), (ITypedElement)new CompareElement(this.rightElement)));
            }
            this.fCompareViewerPane.setText(EMFCompareUIMessages.getString("CompareTextDialog_labelTextField", this.attribute.getName()));
        }
    }

    public void setInput(UpdateAttribute updateAttribute) {
        this.setChangeCompare(updateAttribute);
        this.setCompareViewerInput();
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String fContent;

        public CompareElement(String content) {
            this.fContent = content;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() {
            return "UTF-8";
        }
    }

    public class CustomMergeViewerContentProvider
    extends MergeViewerContentProvider {
        public CustomMergeViewerContentProvider(CompareConfiguration cc) {
            super(cc);
        }

        public boolean isLeftEditable(Object element) {
            return true;
        }

        public boolean isRightEditable(Object element) {
            return true;
        }

        public void saveLeftContent(Object element, byte[] bytes) {
            EObject obj = CompareTextDialog.this.changeCompare.getLeftElement();
            try {
                EFactory.eSet((EObject)obj, (String)CompareTextDialog.this.attribute.getName(), (Object)new String(bytes));
                obj.eResource().save(Collections.EMPTY_MAP);
            }
            catch (FactoryException e) {
                MessageDialog.openError((Shell)CompareTextDialog.this.getShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage());
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)CompareTextDialog.this.getShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage());
            }
        }

        public void saveRightContent(Object element, byte[] bytes) {
            EObject obj = CompareTextDialog.this.changeCompare.getLeftElement();
            try {
                EFactory.eSet((EObject)obj, (String)CompareTextDialog.this.attribute.getName(), (Object)new String(bytes));
                obj.eResource().save(Collections.EMPTY_MAP);
            }
            catch (FactoryException e) {
                MessageDialog.openError((Shell)CompareTextDialog.this.getShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage());
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)CompareTextDialog.this.getShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage());
            }
        }
    }
}

